/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.creatable;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.Convertible;
import oracle.bali.xml.model.convert.XmlKeyConvertibleMarker;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreatableConvertable;
import oracle.bali.xml.model.creatable.XmlCreatableSurroundable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.creatable.XmlCreationResult;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.NameToStringUtils;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

public class XmlKeyCreatable
extends XmlCreatable
implements XmlCreatableSurroundable,
XmlCreatableConvertable {
    private final XmlKey _xmlKey;

    public XmlKeyCreatable(XmlKey xmlKey) {
        if (xmlKey == null) {
            throw new IllegalArgumentException("XmlKeyCreatable:: null XmlKey passed to constructor");
        }
        this._xmlKey = xmlKey;
    }

    @Override
    public String getIdentifier() {
        return NameToStringUtils.writeXmlKeyWithPrefixMappings((XmlKey)this._xmlKey).toString();
    }

    @Override
    public String getShortDisplayName(XmlCreationContext context) {
        return context.getMetadataResolver().getShortDisplayName(this._xmlKey);
    }

    @Override
    public String getMediumDisplayName(XmlCreationContext context) {
        return context.getMetadataResolver().getMediumDisplayName(this._xmlKey);
    }

    @Override
    public String getLongDisplayName(XmlCreationContext context) {
        return context.getMetadataResolver().getLongDisplayName(this._xmlKey);
    }

    @Override
    public List<CategoryDefinition> getCategoryDefinition(XmlCreationContext context) {
        return context.getMetadataResolver().getCategoryDefinition(this._xmlKey);
    }

    @Override
    public int getDisplayOrder(XmlCreationContext context) {
        return context.getMetadataResolver().getDisplayOrder(this._xmlKey);
    }

    @Override
    public String getShortDescription(XmlCreationContext context) {
        return context.getMetadataResolver().getShortDescription(this._xmlKey);
    }

    @Override
    public String getHelpTopic(XmlCreationContext context) {
        return context.getMetadataResolver().getHelpTopic(this._xmlKey);
    }

    @Override
    public Icon getSmallIcon(XmlCreationContext context) {
        return context.getMetadataResolver().getSmallIcon(this._xmlKey);
    }

    @Override
    public Icon getLargeIcon(XmlCreationContext context) {
        return context.getMetadataResolver().getLargeIcon(this._xmlKey);
    }

    @Override
    public boolean isExpert(XmlCreationContext context) {
        return context.getMetadataResolver().isExpert(this._xmlKey);
    }

    @Override
    public boolean isHidden(XmlCreationContext context) {
        XmlMetadataResolver resolver = context.getMetadataResolver();
        if (context.matchesUsage("xmlef-insertion-menu")) {
            Node parent = null;
            DomPosition position = context.getDomPosition();
            if (position != null) {
                parent = position.getContainerNode();
            }
            return !resolver.isXmlKeyCreatableInMenu(parent, context.getParentKey(), this._xmlKey);
        }
        if (context.matchesUsage("xmlef-palette")) {
            return !resolver.isXmlKeyCreatableInPalette(this._xmlKey, context.getEditorUsage());
        }
        return resolver.isHidden(this._xmlKey) || resolver.isDeprecated(this._xmlKey);
    }

    @Override
    public String getSearchKeywords(XmlCreationContext context) {
        return this._xmlKey.getLocalName();
    }

    @Override
    public boolean isValidPosition(XmlCreationContext context, DomPosition domPosition) {
        return context.getMetadataResolver().isValidInsertion(domPosition, Collections.singletonList(this._xmlKey));
    }

    @Override
    public DomPosition findValidPosition(XmlCreationContext context, DomPosition domPosition) {
        AbstractModel model = context.getModel();
        if (model instanceof XmlModel) {
            XmlModel xmlModel = (XmlModel)model;
            return xmlModel.findValidInsertionPosition(this._xmlKey, null, domPosition, null);
        }
        return domPosition;
    }

    @Override
    public XmlCreationResult createAtPosition(XmlCreationContext context, final DomPosition domPosition, TransactionToken transactionToken) throws XmlCommitException {
        if (domPosition != null) {
            final Node[] ret = new Node[1];
            new StandardTransactionTask(){

                @Override
                protected String computeTransactionName(AbstractModel model) {
                    return model.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT", model.getXmlMetadataResolver().getShortDisplayName(XmlKeyCreatable.this._xmlKey));
                }

                @Override
                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Collection inserted;
                    Node node = XmlModelUtils.createNodeFromKey(model, XmlKeyCreatable.this._xmlKey, domPosition);
                    if (node != null && (inserted = model.insertNodes(domPosition, "internal txn", DomUtils.nodeToList((Node)node), true)) != null && !inserted.isEmpty()) {
                        ret[0] = inserted.contains(node) ? node : (Node)inserted.iterator().next();
                        return;
                    }
                    this.cancelTask();
                }
            }.runWithTokenThrowingXCE(context.getModel(), transactionToken);
            return XmlCreationResult.getSimpleResult(ret[0]);
        }
        return XmlCreationResult.NO_OP_RESULT;
    }

    public XmlKey getXmlKey() {
        return this._xmlKey;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof XmlKeyCreatable && ((XmlKeyCreatable)o)._xmlKey.equals((Object)this._xmlKey);
    }

    @Override
    public int hashCode() {
        return this._xmlKey.hashCode();
    }

    @Override
    public List<Node> getSurroundableNodes(AbstractModel model, List possibleNodes) {
        for (Node node : possibleNodes) {
            if (!model.getXmlMetadataResolver().isSurroundable(new Node[]{node}, this._xmlKey)) continue;
            return Collections.singletonList(node);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean doSurround(AbstractModel model, final Node node, final TransactionToken token, String txnName) {
        return new FixedNameTransactionTask(txnName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                model.getContext().setTransactionToken(token);
                Node target = node;
                if (model instanceof XmlView) {
                    target = ((XmlView)model).viewToModel(target);
                }
                boolean ok = false;
                if (target != null) {
                    XmlModel baseModel = model.getBaseModel();
                    baseModel.getSelection().set(target);
                    Node ret = baseModel.surroundSelection(XmlKeyCreatable.this._xmlKey);
                    boolean bl = ok = ret != null;
                }
                if (!ok) {
                    this.cancelTask();
                }
            }
        }.run(model);
    }

    @Override
    public List<Node> getConvertNodes(AbstractModel model, List possibleNodes) {
        for (Node node : possibleNodes) {
            Convertible convertible = this.findConvertible(model, node);
            if (convertible == null) continue;
            return Collections.singletonList(node);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean doConvert(AbstractModel model, Node node) {
        Convertible convertible = this.findConvertible(model, node);
        if (convertible != null) {
            try {
                return convertible.doConvert(node);
            }
            catch (XmlCommitException xce) {
                return false;
            }
        }
        return false;
    }

    private Convertible findConvertible(AbstractModel model, Node node) {
        List<ConvertPlugin> plugins = model.getXmlMetadataResolver().getConvertPlugins(node);
        for (ConvertPlugin plugin : plugins) {
            List<Convertible> convertibles = plugin.getConvertibles(node);
            for (Convertible convertible : convertibles) {
                XmlKeyConvertibleMarker marker;
                if (!(convertible instanceof XmlKeyConvertibleMarker) || !(marker = (XmlKeyConvertibleMarker)((Object)convertible)).matchesXmlKey(this._xmlKey)) continue;
                return convertible;
            }
        }
        return null;
    }
}

