/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreatableSurroundable;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractNodeTargetingOperation;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Node;

class XmlCreatableSurroundOperation
extends AbstractNodeTargetingOperation {
    XmlCreatableSurroundOperation() {
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragSurround");
        }
        return model.getTranslatedString("DragSurround_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.45f;
    }

    @Override
    public int getSupportedActions() {
        return 0;
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_XMLCREATABLE;
    }

    @Override
    protected boolean applyImpl(AbstractModel model, Node node, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        XmlCreatable creatable = (XmlCreatable)data.getData(FetchMode.STANDARD, false);
        if (creatable != null && creatable instanceof XmlCreatableSurroundable) {
            XmlCreatableSurroundable surroundable = (XmlCreatableSurroundable)((Object)creatable);
            return surroundable.doSurround(model, node, token, this.getDisplayName(model, data));
        }
        return false;
    }

    @Override
    protected List getApplicableNodesForDataImpl(AbstractModel model, List possibleNodes, TransferDataInfo data) {
        try {
            XmlCreatable creatable = (XmlCreatable)data.getData(FetchMode.STANDARD, false);
            if (creatable != null && creatable instanceof XmlCreatableSurroundable) {
                XmlCreatableSurroundable surroundable = (XmlCreatableSurroundable)((Object)creatable);
                return surroundable.getSurroundableNodes(model, possibleNodes);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

