/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;

class Jdk15AWTClipboardManager
extends AWTClipboardManager
implements FlavorListener {
    private boolean _inSetContents = false;
    private boolean _listenerAttached = false;
    private Reference<Transferable> _cachedRef;
    private static Clipboard _clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final Logger _LOGGER = Logger.getLogger(Jdk15AWTClipboardManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transferable getContents() {
        DataFlavor etFlavor = ExtendedTransferable.FLAVOR_EXTENDED_TRANSFERABLE;
        if (_clipboard.isDataFlavorAvailable(etFlavor)) {
            try {
                return (Transferable)_clipboard.getData(etFlavor);
            }
            catch (Exception e) {
                _LOGGER.warning("ExtendedTransferable flavor was available but getData failed; falling back to regular path.");
            }
        }
        Jdk15AWTClipboardManager e = this;
        synchronized (e) {
            Transferable cachedTrans;
            if (this._cachedRef != null && (cachedTrans = this._cachedRef.get()) != null) {
                return cachedTrans;
            }
        }
        Transferable trans = this._getContentsImpl();
        Jdk15AWTClipboardManager jdk15AWTClipboardManager = this;
        synchronized (jdk15AWTClipboardManager) {
            this._cachedRef = new SoftReference<Transferable>(trans);
        }
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setContents(Transferable newContents) {
        _LOGGER.log(Level.FINER, "setContents to {0}", newContents);
        this._cachedRef = new SoftReference<Transferable>(newContents);
        this._inSetContents = true;
        try {
            _clipboard.setContents(newContents, null);
        }
        finally {
            this._inSetContents = false;
        }
        this.notifyFlavorListeners();
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        if (!this._inSetContents) {
            this._cachedRef = null;
            this.notifyFlavorListeners();
        }
    }

    @Override
    public void setClipboard(Clipboard clipboard) {
        _clipboard = clipboard;
    }

    Jdk15AWTClipboardManager() {
    }

    @Override
    protected void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        this._attachOrDetachIfNeeded();
    }

    @Override
    protected void applicationActiveChanged() {
        super.applicationActiveChanged();
        boolean eventNow = this._attachOrDetachIfNeeded();
        if (eventNow) {
            this.notifyFlavorListeners();
        }
    }

    private synchronized boolean _attachOrDetachIfNeeded() {
        boolean shouldBeAttached;
        boolean bl = shouldBeAttached = this.isApplicationActive() && this.areFlavorListenersAttached();
        if (shouldBeAttached != this._listenerAttached) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "Clipboard manager attach/detach occuring; attaching={0}", shouldBeAttached);
            }
            if (shouldBeAttached) {
                _clipboard.addFlavorListener(this);
            } else {
                _clipboard.removeFlavorListener(this);
            }
            this._listenerAttached = shouldBeAttached;
            return this._listenerAttached;
        }
        return false;
    }

    private Transferable _getContentsImpl() {
        DataFlavor[] flavors = _clipboard.getAvailableDataFlavors();
        if (flavors == null || flavors.length == 0) {
            _LOGGER.finer("getContents found no flavors");
            return EMPTY_CONTENTS;
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "getContents found data; flavors={0}", Arrays.asList(flavors));
        }
        return new LazyClipboardTransferable(flavors);
    }

    private static class LazyClipboardTDI
    extends TransferDataInfo {
        private final DataFlavor _flavor;
        private final float _rank;

        public LazyClipboardTDI(DataFlavor flavor, float rank) {
            this._flavor = flavor;
            this._rank = rank;
        }

        public DataFlavor getDataFlavor() {
            return this._flavor;
        }

        public synchronized Object getData(FetchMode mode, boolean asReference) {
            if (mode == FetchMode.STANDARD) {
                try {
                    return _clipboard.getData(this._flavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public float getSuitabilityRank() {
            return this._rank;
        }
    }

    private static class LazyClipboardTransferable
    extends ExtendedTransferable {
        private final Map<DataFlavor, List<TransferDataInfo>> _flavorToData;
        private final String _desc;

        public LazyClipboardTransferable(DataFlavor[] flavors) {
            this._desc = TransferUtils.inventDescription((DataFlavor)flavors[0]);
            Map<DataFlavor, List<LazyClipboardTDI>> map = new LinkedHashMap(flavors.length);
            float rank = 1.0f;
            for (DataFlavor f : flavors) {
                LazyClipboardTDI dataInfo = new LazyClipboardTDI(f, rank);
                map.put(f, Collections.singletonList(dataInfo));
                rank = TransferUtils.lowerRank((float)rank);
            }
            map = Collections.unmodifiableMap(map);
            this._flavorToData = map;
        }

        public List getDataInfos(DataFlavor flavor) {
            List<TransferDataInfo> ret = this._flavorToData.get(flavor);
            if (ret != null) {
                return ret;
            }
            return Collections.EMPTY_LIST;
        }

        public Iterator getOrderedFlavorIterator() {
            return this._flavorToData.keySet().iterator();
        }

        public String getShortDescription() {
            return this._desc;
        }

        public String getMediumDescription() {
            return this.getShortDescription();
        }

        protected int getFlavorCount() {
            return this._flavorToData.size();
        }

        protected boolean isFlavorSupported(DataFlavor flavor) {
            return this._flavorToData.containsKey(flavor);
        }
    }
}

