/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.beanmodel.BeanBaseRegistry;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.util.EncodingUtils;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.share.TextBufferSource;
import oracle.bali.xml.util.InputStreamProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;

public class StreamXmlContext
extends XmlContext {
    private String _loadEncoding;
    private final TextBufferSource _textBufferSource;
    private final VersionManager _versionMgr;
    private final List<BeanBaseRegistry> _registries;
    private final WhitespaceMode _whitespaceMode;

    public StreamXmlContext(InputStreamProvider inputStreamProvider) throws IOException {
        this(inputStreamProvider, null);
    }

    public StreamXmlContext(InputStreamProvider inputStreamProvider, WhitespaceMode mode) throws IOException {
        this(inputStreamProvider, null, Collections.emptyList(), mode);
    }

    public StreamXmlContext(InputStreamProvider inputStreamProvider, VersionManager versionMgr, List<BeanBaseRegistry> registries) throws IOException {
        this(inputStreamProvider, versionMgr, registries, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamXmlContext(InputStreamProvider inputStreamProvider, VersionManager versionMgr, List<BeanBaseRegistry> registries, WhitespaceMode mode) throws IOException {
        this._versionMgr = versionMgr;
        this._registries = registries;
        this._whitespaceMode = mode;
        if (this._versionMgr != null) {
            this._versionMgr.setContext(this);
        }
        InputStream inputStream = null;
        InputStream combinedStream = null;
        try {
            inputStream = inputStreamProvider.openInputStream();
            combinedStream = this._setEncoding(inputStream);
            ReadWriteLock readWriteLock = new ReadWriteLock();
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer((ReadWriteLock)readWriteLock);
            InputStreamReader reader = new InputStreamReader(combinedStream, this._loadEncoding);
            textBuffer.read((Reader)reader);
            this._textBufferSource = new StreamTextBufferSource(textBuffer, readWriteLock);
        }
        finally {
            try {
                if (combinedStream != null) {
                    combinedStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {}
        }
        XmlModel xmlModel = new XmlModel(this.createMetadataProvider());
        this.finishInitialization();
        this.setModel(xmlModel);
        DomModel domModel = xmlModel.getDomModel();
        boolean hasXmlDecl = false;
        xmlModel.acquireReadLock();
        try {
            hasXmlDecl = domModel.getXmlDeclarationInfo() != null;
        }
        finally {
            xmlModel.releaseReadLock();
        }
        if (!hasXmlDecl) {
            domModel.setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, this._loadEncoding, null));
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this._loadEncoding);
        this.getTextBuffer().write((Writer)writer);
    }

    public TextBuffer getTextBuffer() {
        return this._textBufferSource.getTextBuffer();
    }

    public String getLoadEncoding() {
        return this._loadEncoding;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public String getRelativePathForURL(URL absoluteURL) {
        return null;
    }

    @Override
    public URL getURLForRelativePath(String relativePath) {
        return null;
    }

    public boolean isModified() {
        return this.getTextBuffer().isModified();
    }

    @Override
    protected final DomModel createSourceDomModel(XmlModel xmlModel) {
        BufferDomModelPluginFactory pluginFactory = new BufferDomModelPluginFactory(this._textBufferSource, (DOMImplementation)new XMLDOMImplementation(), this.getParserConfiguration(), (DocumentScannerFactory)new DefaultDocumentScannerFactory());
        WhitespaceHandler handler = null;
        handler = this._whitespaceMode != null ? new WhitespaceHandler(){

            @Override
            protected WhitespaceMode getElementContentWhitespaceModeImpl(TreeTraversal traversal, Element element, WhitespaceMode specifiedMode) {
                if (specifiedMode != null) {
                    return specifiedMode;
                }
                return StreamXmlContext.this._whitespaceMode;
            }
        } : xmlModel.getWhitespaceHandler();
        DomModel dom = DomModelFactory.createDomModel(this, pluginFactory, handler);
        return dom;
    }

    public MetadataProvider createMetadataProvider() {
        if (this._versionMgr != null) {
            return this._versionMgr.getMetadataProvider();
        }
        return new GrammarMetadataProvider(this.getGrammarResolver());
    }

    protected ParserConfiguration getParserConfiguration() {
        return new DefaultParserConfiguration();
    }

    @Override
    protected GrammarProvider createGrammarProvider() {
        if (this._versionMgr != null) {
            return this._versionMgr.getGrammarProvider();
        }
        return new SchemaGrammarProvider();
    }

    @Override
    protected VersionManager createVersionManager() {
        return this._versionMgr;
    }

    @Override
    protected List<BeanBaseRegistry> createBeanRegistries() {
        return this._registries;
    }

    private final InputStream _setEncoding(InputStream inputStream) throws IOException {
        String encodingToUse = null;
        String encodingClass = "UTF-8";
        String encodingInFile = null;
        int encodingScanSize = 512;
        byte[] scanArray = new byte[512];
        int length = EncodingUtils.fillEncodingScanArray(inputStream, scanArray, 512);
        ReadTextBuffer buffer = EncodingUtils.getTemporaryTextBuffer(scanArray, length, encodingClass = EncodingUtils.getEncodingClass(scanArray, length));
        AttributeLocator encodingLocator = EncodingUtils.getEncodingAttributeLocator(buffer);
        if (encodingLocator != null) {
            encodingInFile = EncodingUtils.getAttributeValue(buffer, encodingLocator);
        }
        encodingToUse = encodingClass;
        if (encodingInFile != null && encodingInFile.length() > 0) {
            encodingToUse = encodingInFile;
        }
        this._loadEncoding = encodingToUse;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(scanArray, 0, length);
        SequenceInputStream combinedStream = new SequenceInputStream(byteStream, inputStream);
        return combinedStream;
    }

    private class StreamTextBufferSource
    extends TextBufferSource {
        private final TextBuffer _textBuffer;
        private final ReadWriteLock _readWriteLock;

        public StreamTextBufferSource(TextBuffer textBuffer, ReadWriteLock underlyingReadWriteLock) {
            this._textBuffer = textBuffer;
            this._readWriteLock = underlyingReadWriteLock;
        }

        @Override
        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        @Override
        public ReadWriteLock getUnderlyingReadWriteLock() {
            return this._readWriteLock;
        }
    }
}

