/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected int leftOverFromPreviousRead = 0;
    protected int nextPacketOffset = 0;
    public SessionAtts sAtts;
    StringBuilder sb = null;
    StringBuilder tmpBuf = null;
    public static final String[] toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
    public static final char[] toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    public static final String DIVIDER = "     |";
    public static final String BLANK_SPACE = "   ";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    public Packet(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.sdu = sessionAtts.getSDU();
        this.tdu = sessionAtts.getTDU();
    }

    public Packet(SessionAtts sessionAtts, int n2) {
        this(sessionAtts);
        this.createBuffer(n2);
    }

    public Packet(SessionAtts sessionAtts, int n2, int n3, int n4) {
        this(sessionAtts);
        this.createBuffer(n2, n3, n4);
    }

    public Packet(Packet packet) {
        this(packet.sAtts);
        this.length = packet.length;
        this.type = packet.type;
        this.flags = packet.flags;
        this.dataLen = packet.dataLen;
        this.dataOff = packet.dataOff;
        this.buffer = packet.buffer;
    }

    protected void createBuffer(int n2) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
    }

    protected void createBuffer(int n2, int n3, int n4) {
        this.createBuffer(n2);
        this.buffer[5] = (byte)n4;
        this.buffer[4] = (byte)n3;
    }

    protected void receive() throws IOException, NetException {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.sdu;
        if (this.sAtts.enableJavaNetFastPath && !this.sAtts.anoActive) {
            n4 -= 37;
        }
        boolean bl = true;
        while (n4 > 0) {
            if (this.leftOverFromPreviousRead > 0) {
                System.arraycopy(this.buffer, this.nextPacketOffset, this.buffer, 0, this.leftOverFromPreviousRead);
                n2 = this.leftOverFromPreviousRead;
                if (n2 >= 8) {
                    this.processHeader();
                    bl = false;
                    if (this.length >= this.leftOverFromPreviousRead) {
                        n4 = this.length - this.leftOverFromPreviousRead;
                        this.leftOverFromPreviousRead = 0;
                        this.nextPacketOffset = 0;
                    } else {
                        this.leftOverFromPreviousRead -= this.length;
                        n4 = 0;
                        this.nextPacketOffset = this.length;
                    }
                } else {
                    n4 -= n2;
                    this.leftOverFromPreviousRead -= n2;
                    this.nextPacketOffset = 0;
                }
            }
            try {
                if (n4 > 0) {
                    n3 = this.sAtts.ntInputStream.read(this.buffer, n2, n4);
                    if (n3 <= 0) {
                        throw new NetException(0);
                    }
                    n2 += n3;
                }
                if (bl && n2 >= 8) {
                    bl = false;
                    this.processHeader();
                    n4 = this.length;
                    if (n2 > this.length) {
                        this.leftOverFromPreviousRead = n2 - this.length;
                        n4 = 0;
                        this.nextPacketOffset = this.length;
                        continue;
                    }
                    this.leftOverFromPreviousRead = 0;
                    this.nextPacketOffset = 0;
                    n4 -= n2;
                    continue;
                }
                n4 -= n3;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new NetException(504);
            }
        }
    }

    void processHeader() throws IOException, NetException {
        this.length = this.buffer[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.buffer[1] & 0xFF;
        this.type = this.buffer[4];
        this.flags = this.buffer[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > 65535 || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
        }
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] byArray = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(byArray) < 0) {
                throw new NetException(0);
            }
            this.data = new String(byArray, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    void setFlags(int n2) throws NetException {
        this.flags = n2;
        this.buffer[5] = (byte)this.flags;
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.sAtts = sessionAtts;
    }

    public static final int toUb2(byte[] byArray, int n2) {
        int n3 = 0;
        n3 = byArray[n2] & 0xFF;
        n3 <<= 8;
        return n3 |= byArray[n2 + 1] & 0xFF;
    }

    public static final void setUb2ToBytes(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 << 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n3 & 0xFF);
    }

    int readLocal(byte[] byArray, int n2, int n3) throws NetException {
        int n4 = 0;
        if (this.leftOverFromPreviousRead > 0) {
            if (this.leftOverFromPreviousRead > n3) {
                n4 = n3;
                System.arraycopy(this.buffer, this.nextPacketOffset, byArray, n2, n4);
                this.leftOverFromPreviousRead -= n4;
                this.nextPacketOffset += n4;
            } else {
                n4 = this.leftOverFromPreviousRead;
                System.arraycopy(this.buffer, this.nextPacketOffset, byArray, n2, n4);
                this.leftOverFromPreviousRead -= n4;
                this.nextPacketOffset = 0;
            }
        }
        return n4;
    }

    protected String dumpBytes(byte[] byArray, int n2, int n3) {
        if (this.sb == null) {
            this.sb = new StringBuilder(16384);
            this.tmpBuf = new StringBuilder(80);
        }
        return this.dumpBytes(byArray, n2, n3, 8, this.sb, this.tmpBuf);
    }

    public String dumpBytes(byte[] byArray, int n2, int n3, int n4, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (byArray == null) {
            return "NULL";
        }
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder2.delete(0, stringBuilder2.length());
        int n5 = n2 + n3;
        boolean bl = false;
        int n6 = 0;
        for (int i2 = n2; i2 < n5; ++i2) {
            int n7 = byArray[i2] & 0xFF;
            stringBuilder.append(toHex[n7]);
            stringBuilder2.append(toChar[n7]);
            if (++n6 != n4) continue;
            stringBuilder.append(DIVIDER);
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
            n6 = 0;
        }
        if (n6 > 0) {
            int n8;
            int n9 = n4 - n6 - 1;
            for (n8 = 0; n8 <= n9; ++n8) {
                stringBuilder.append(BLANK_SPACE);
            }
            stringBuilder.append(DIVIDER);
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            for (n8 = 0; n8 <= n9; ++n8) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        return stringBuilder.substring(0, stringBuilder.length());
    }

    protected void dump(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + byArray.length);
        System.out.println("offset       =" + n2);
        System.out.println("len          =" + n3);
        for (int i2 = n2; i2 < n3; i2 += 8) {
            System.out.print("|");
            for (int i3 = 0; i3 < 8 && n4 < n3 - 1; ++i3) {
                n4 = i2 + i3;
                RepConversion.printInHex(byArray[n4]);
                System.out.print(" ");
            }
            System.out.println("|");
        }
        System.out.println("finish dump");
    }
}

