/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetFactory;
import oracle.sql.CharacterSetFactoryDefault;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.ReadWriteCharacterSetNamesMap;
import oracle.sql.converter.CharacterConverterFactoryOGS;

public abstract class CharacterSet {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short US7ASCII_CHARSET = 1;
    public static final short WE8DEC_CHARSET = 2;
    public static final short WE8HP_CHARSET = 3;
    public static final short US8PC437_CHARSET = 4;
    public static final short WE8EBCDIC37_CHARSET = 5;
    public static final short WE8EBCDIC500_CHARSET = 6;
    public static final short WE8EBCDIC285_CHARSET = 8;
    public static final short WE8PC850_CHARSET = 10;
    public static final short D7DEC_CHARSET = 11;
    public static final short F7DEC_CHARSET = 12;
    public static final short S7DEC_CHARSET = 13;
    public static final short E7DEC_CHARSET = 14;
    public static final short SF7ASCII_CHARSET = 15;
    public static final short NDK7DEC_CHARSET = 16;
    public static final short I7DEC_CHARSET = 17;
    public static final short NL7DEC_CHARSET = 18;
    public static final short CH7DEC_CHARSET = 19;
    public static final short YUG7ASCII_CHARSET = 20;
    public static final short SF7DEC_CHARSET = 21;
    public static final short TR7DEC_CHARSET = 22;
    public static final short IW7IS960_CHARSET = 23;
    public static final short IN8ISCII_CHARSET = 25;
    public static final short WE8ISO8859P1_CHARSET = 31;
    public static final short EE8ISO8859P2_CHARSET = 32;
    public static final short SE8ISO8859P3_CHARSET = 33;
    public static final short NEE8ISO8859P4_CHARSET = 34;
    public static final short CL8ISO8859P5_CHARSET = 35;
    public static final short AR8ISO8859P6_CHARSET = 36;
    public static final short EL8ISO8859P7_CHARSET = 37;
    public static final short IW8ISO8859P8_CHARSET = 38;
    public static final short WE8ISO8859P9_CHARSET = 39;
    public static final short NE8ISO8859P10_CHARSET = 40;
    public static final short TH8TISASCII_CHARSET = 41;
    public static final short TH8TISEBCDIC_CHARSET = 42;
    public static final short BN8BSCII_CHARSET = 43;
    public static final short VN8VN3_CHARSET = 44;
    public static final short VN8MSWIN1258_CHARSET = 45;
    public static final short WE8NEXTSTEP_CHARSET = 50;
    public static final short AR8ASMO708PLUS_CHARSET = 61;
    public static final short AR8EBCDICX_CHARSET = 70;
    public static final short AR8XBASIC_CHARSET = 72;
    public static final short EL8DEC_CHARSET = 81;
    public static final short TR8DEC_CHARSET = 82;
    public static final short WE8EBCDIC37C_CHARSET = 90;
    public static final short WE8EBCDIC500C_CHARSET = 91;
    public static final short IW8EBCDIC424_CHARSET = 92;
    public static final short TR8EBCDIC1026_CHARSET = 93;
    public static final short WE8EBCDIC871_CHARSET = 94;
    public static final short WE8EBCDIC284_CHARSET = 95;
    public static final short WE8EBCDIC1047_CHARSET = 96;
    public static final short EEC8EUROASCI_CHARSET = 110;
    public static final short EEC8EUROPA3_CHARSET = 113;
    public static final short LA8PASSPORT_CHARSET = 114;
    public static final short BG8PC437S_CHARSET = 140;
    public static final short EE8PC852_CHARSET = 150;
    public static final short RU8PC866_CHARSET = 152;
    public static final short RU8BESTA_CHARSET = 153;
    public static final short IW8PC1507_CHARSET = 154;
    public static final short RU8PC855_CHARSET = 155;
    public static final short TR8PC857_CHARSET = 156;
    public static final short CL8MACCYRILLIC_CHARSET = 158;
    public static final short CL8MACCYRILLICS_CHARSET = 159;
    public static final short WE8PC860_CHARSET = 160;
    public static final short IS8PC861_CHARSET = 161;
    public static final short EE8MACCES_CHARSET = 162;
    public static final short EE8MACCROATIANS_CHARSET = 163;
    public static final short TR8MACTURKISHS_CHARSET = 164;
    public static final short IS8MACICELANDICS_CHARSET = 165;
    public static final short EL8MACGREEKS_CHARSET = 166;
    public static final short IW8MACHEBREWS_CHARSET = 167;
    public static final short EE8MSWIN1250_CHARSET = 170;
    public static final short CL8MSWIN1251_CHARSET = 171;
    public static final short ET8MSWIN923_CHARSET = 172;
    public static final short BG8MSWIN_CHARSET = 173;
    public static final short EL8MSWIN1253_CHARSET = 174;
    public static final short IW8MSWIN1255_CHARSET = 175;
    public static final short LT8MSWIN921_CHARSET = 176;
    public static final short TR8MSWIN1254_CHARSET = 177;
    public static final short WE8MSWIN1252_CHARSET = 178;
    public static final short BLT8MSWIN1257_CHARSET = 179;
    public static final short D8EBCDIC273_CHARSET = 180;
    public static final short I8EBCDIC280_CHARSET = 181;
    public static final short DK8EBCDIC277_CHARSET = 182;
    public static final short S8EBCDIC278_CHARSET = 183;
    public static final short EE8EBCDIC870_CHARSET = 184;
    public static final short CL8EBCDIC1025_CHARSET = 185;
    public static final short F8EBCDIC297_CHARSET = 186;
    public static final short IW8EBCDIC1086_CHARSET = 187;
    public static final short CL8EBCDIC1025X_CHARSET = 188;
    public static final short N8PC865_CHARSET = 190;
    public static final short BLT8CP921_CHARSET = 191;
    public static final short LV8PC1117_CHARSET = 192;
    public static final short LV8PC8LR_CHARSET = 193;
    public static final short BLT8EBCDIC1112_CHARSET = 194;
    public static final short LV8RST104090_CHARSET = 195;
    public static final short CL8KOI8R_CHARSET = 196;
    public static final short BLT8PC775_CHARSET = 197;
    public static final short F7SIEMENS9780X_CHARSET = 201;
    public static final short E7SIEMENS9780X_CHARSET = 202;
    public static final short S7SIEMENS9780X_CHARSET = 203;
    public static final short DK7SIEMENS9780X_CHARSET = 204;
    public static final short N7SIEMENS9780X_CHARSET = 205;
    public static final short I7SIEMENS9780X_CHARSET = 206;
    public static final short D7SIEMENS9780X_CHARSET = 207;
    public static final short WE8GCOS7_CHARSET = 210;
    public static final short EL8GCOS7_CHARSET = 211;
    public static final short US8BS2000_CHARSET = 221;
    public static final short D8BS2000_CHARSET = 222;
    public static final short F8BS2000_CHARSET = 223;
    public static final short E8BS2000_CHARSET = 224;
    public static final short DK8BS2000_CHARSET = 225;
    public static final short S8BS2000_CHARSET = 226;
    public static final short WE8BS2000_CHARSET = 231;
    public static final short CL8BS2000_CHARSET = 235;
    public static final short WE8BS2000L5_CHARSET = 239;
    public static final short WE8DG_CHARSET = 241;
    public static final short WE8NCR4970_CHARSET = 251;
    public static final short WE8ROMAN8_CHARSET = 261;
    public static final short EE8MACCE_CHARSET = 262;
    public static final short EE8MACCROATIAN_CHARSET = 263;
    public static final short TR8MACTURKISH_CHARSET = 264;
    public static final short IS8MACICELANDIC_CHARSET = 265;
    public static final short EL8MACGREEK_CHARSET = 266;
    public static final short IW8MACHEBREW_CHARSET = 267;
    public static final short US8ICL_CHARSET = 277;
    public static final short WE8ICL_CHARSET = 278;
    public static final short WE8ISOICLUK_CHARSET = 279;
    public static final short WE8MACROMAN8_CHARSET = 351;
    public static final short WE8MACROMAN8S_CHARSET = 352;
    public static final short TH8MACTHAI_CHARSET = 353;
    public static final short TH8MACTHAIS_CHARSET = 354;
    public static final short HU8CWI2_CHARSET = 368;
    public static final short EL8PC437S_CHARSET = 380;
    public static final short EL8EBCDIC875_CHARSET = 381;
    public static final short EL8PC737_CHARSET = 382;
    public static final short LT8PC772_CHARSET = 383;
    public static final short LT8PC774_CHARSET = 384;
    public static final short EL8PC869_CHARSET = 385;
    public static final short EL8PC851_CHARSET = 386;
    public static final short CDN8PC863_CHARSET = 390;
    public static final short HU8ABMOD_CHARSET = 401;
    public static final short AR8ASMO8X_CHARSET = 500;
    public static final short AR8NAFITHA711T_CHARSET = 504;
    public static final short AR8SAKHR707T_CHARSET = 505;
    public static final short AR8MUSSAD768T_CHARSET = 506;
    public static final short AR8ADOS710T_CHARSET = 507;
    public static final short AR8ADOS720T_CHARSET = 508;
    public static final short AR8APTEC715T_CHARSET = 509;
    public static final short AR8NAFITHA721T_CHARSET = 511;
    public static final short AR8HPARABIC8T_CHARSET = 514;
    public static final short AR8NAFITHA711_CHARSET = 554;
    public static final short AR8SAKHR707_CHARSET = 555;
    public static final short AR8MUSSAD768_CHARSET = 556;
    public static final short AR8ADOS710_CHARSET = 557;
    public static final short AR8ADOS720_CHARSET = 558;
    public static final short AR8APTEC715_CHARSET = 559;
    public static final short AR8MSAWIN_CHARSET = 560;
    public static final short AR8NAFITHA721_CHARSET = 561;
    public static final short AR8SAKHR706_CHARSET = 563;
    public static final short AR8ARABICMAC_CHARSET = 565;
    public static final short AR8ARABICMACS_CHARSET = 566;
    public static final short AR8ARABICMACT_CHARSET = 567;
    public static final short LA8ISO6937_CHARSET = 590;
    public static final short US8NOOP_CHARSET = 797;
    public static final short WE8DECTST_CHARSET = 798;
    public static final short JA16VMS_CHARSET = 829;
    public static final short JA16EUC_CHARSET = 830;
    public static final short JA16EUCYEN_CHARSET = 831;
    public static final short JA16SJIS_CHARSET = 832;
    public static final short JA16DBCS_CHARSET = 833;
    public static final short JA16SJISYEN_CHARSET = 834;
    public static final short JA16EBCDIC930_CHARSET = 835;
    public static final short JA16MACSJIS_CHARSET = 836;
    public static final short JA16EUCTILDE_CHARSET = 837;
    public static final short JA16SJISTILDE_CHARSET = 838;
    public static final short KO16KSC5601_CHARSET = 840;
    public static final short KO16DBCS_CHARSET = 842;
    public static final short KO16KSCCS_CHARSET = 845;
    public static final short KO16MSWIN949_CHARSET = 846;
    public static final short ZHS16CGB231280_CHARSET = 850;
    public static final short ZHS16MACCGB231280_CHARSET = 851;
    public static final short ZHS16GBK_CHARSET = 852;
    public static final short ZHS16DBCS_CHARSET = 853;
    public static final short ZHS32GB18030_CHARSET = 854;
    public static final short ZHT32EUC_CHARSET = 860;
    public static final short ZHT32SOPS_CHARSET = 861;
    public static final short ZHT16DBT_CHARSET = 862;
    public static final short ZHT32TRIS_CHARSET = 863;
    public static final short ZHT16DBCS_CHARSET = 864;
    public static final short ZHT16BIG5_CHARSET = 865;
    public static final short ZHT16CCDC_CHARSET = 866;
    public static final short ZHT16MSWIN950_CHARSET = 867;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short UTFE_CHARSET = 872;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short KO16TSTSET_CHARSET = 996;
    public static final short JA16TSTSET2_CHARSET = 997;
    public static final short JA16TSTSET_CHARSET = 998;
    public static final short US16TSTFIXED_CHARSET = 1001;
    public static final short AL16UTF16_CHARSET = 2000;
    public static final short AL16UTF16LE_CHARSET = 2002;
    public static final short TH8TISEBCDICS_CHARSET = 319;
    public static final short BLT8EBCDIC1112S_CHARSET = 314;
    public static final short CE8BS2000_CHARSET = 233;
    public static final short CL8EBCDIC1025R_CHARSET = 323;
    public static final short CL8EBCDIC1158R_CHARSET = 326;
    public static final short D8EBCDIC1141_CHARSET = 189;
    public static final short DK8EBCDIC1142_CHARSET = 198;
    public static final short EE8BS2000_CHARSET = 232;
    public static final short EE8EBCDIC870S_CHARSET = 316;
    public static final short EL8EBCDIC423R_CHARSET = 327;
    public static final short EL8EBCDIC875S_CHARSET = 311;
    public static final short EL8EBCDIC875R_CHARSET = 324;
    public static final short F8EBCDIC1147_CHARSET = 208;
    public static final short I8EBCDIC1144_CHARSET = 200;
    public static final short WE8BS2000E_CHARSET = 230;
    public static final short WE8EBCDIC1047E_CHARSET = 100;
    public static final short WE8EBCDIC1140_CHARSET = 7;
    public static final short WE8EBCDIC1145_CHARSET = 98;
    public static final short WE8EBCDIC1146_CHARSET = 9;
    public static final short WE8EBCDIC1148_CHARSET = 27;
    public static final short AR8EBCDIC420S_CHARSET = 320;
    public static final short IW8EBCDIC424S_CHARSET = 315;
    public static final short TR8EBCDIC1026S_CHARSET = 312;
    public static final short ZHT16HKSCS_CHARSET = 868;
    public static final short BLT8ISO8859P13_CHARSET = 47;
    public static final short WE8ISO8859P15_CHARSET = 46;
    public static final short AR8MSWIN1256_CHARSET = 560;
    public static final short S8EBCDIC1143_CHARSET = 199;
    public static final short ZHT16HKSCS31_CHARSET = 992;
    public static final short AZ8ISO8859P9E_CHARSET = 52;
    public static final short CEL8ISO8859P14_CHARSET = 48;
    public static final short CL8ISOIR111_CHARSET = 49;
    public static final short CL8KOI8U_CHARSET = 51;
    public static final short WE8PC858_CHARSET = 28;
    public static final short CL8EBCDIC1025C_CHARSET = 322;
    public static final short CL8EBCDIC1025S_CHARSET = 317;
    public static final short CL8EBCDIC1158_CHARSET = 325;
    public static final short EE8EBCDIC870C_CHARSET = 301;
    public static final short WE8EBCDIC924_CHARSET = 101;
    public static final short WE8EBCDIC1140C_CHARSET = 97;
    public static final short WE8EBCDIC1148C_CHARSET = 99;
    public static final short UNICODE_2_CHARSET = 871;
    private static CharacterSet asciiCharSet = null;
    static CharacterSetFactory factory;
    private int oracleId;
    int rep;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Mon_Aug_29_23:34:29_PDT_2011";
    public static final boolean TRACE = false;

    CharacterSet(int n2) {
        this.oracleId = n2;
    }

    public static CharacterSet make(int n2) {
        return factory.make(n2);
    }

    public String toString() {
        if (ReadWriteCharacterSetNamesMap.cache == null) {
            this.buildCharacterSetNames();
        }
        return ReadWriteCharacterSetNamesMap.cache.get(new Short((short)this.oracleId));
    }

    synchronized void buildCharacterSetNames() {
        if (ReadWriteCharacterSetNamesMap.cache == null) {
            Class<CharacterSet> clazz = CharacterSet.class;
            Field[] fieldArray = clazz.getFields();
            HashMap<Short, String> hashMap = new HashMap<Short, String>();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                try {
                    String string = fieldArray[i2].getName();
                    int n2 = string.lastIndexOf("_CHARSET");
                    if (n2 == -1 || (string = string.substring(0, n2)).equals("ASCII") || string.equals("ISO_LATIN_1") || string.equals("AR8MSAWIN") || string.equals("UNICODE_1") || string.equals("UNICODE_2")) continue;
                    short s2 = fieldArray[i2].getShort(CharacterSet.class);
                    int n3 = fieldArray[i2].getModifiers();
                    if (!Modifier.isStatic(n3) || !Modifier.isFinal(n3)) continue;
                    String string2 = (String)hashMap.get(new Short(s2));
                    if (string2 != null) {
                        throw new RuntimeException("duplicate field name: " + string + " for id: " + s2);
                    }
                    hashMap.put(new Short(s2), string);
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed for field: " + fieldArray[i2], exception);
                }
            }
            ReadWriteCharacterSetNamesMap.cache = hashMap;
        }
    }

    public abstract boolean isLossyFrom(CharacterSet var1);

    public abstract boolean isConvertibleFrom(CharacterSet var1);

    public boolean isUnicode() {
        return false;
    }

    boolean isWellFormed(byte[] byArray, int n2, int n3) {
        return true;
    }

    public int getOracleId() {
        return this.oracleId;
    }

    int getRep() {
        return this.rep;
    }

    public int getRatioTo(CharacterSet characterSet) {
        throw new Error("oracle.sql.CharacterSet.getRationTo Not Implemented");
    }

    public boolean equals(Object object) {
        return object instanceof CharacterSet && this.oracleId == ((CharacterSet)object).oracleId;
    }

    public int hashCode() {
        return this.oracleId;
    }

    public abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        String string = this.toStringWithReplacement(byArray, n2, n3);
        byte[] byArray2 = this.convert(string);
        if (n3 != byArray2.length) {
            CharacterSet.failCharacterConversion(this);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray2[i2] == byArray[n2 + i2]) continue;
            CharacterSet.failCharacterConversion(this);
        }
        return null;
    }

    public abstract byte[] convert(String var1) throws SQLException;

    public abstract byte[] convertWithReplacement(String var1);

    public abstract byte[] convert(CharacterSet var1, byte[] var2, int var3, int var4) throws SQLException;

    public byte[] convertUnshared(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2 = this.convert(characterSet, byArray, n2, n3);
        if (byArray2 == byArray) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
        }
        return byArray2;
    }

    abstract int decode(CharacterWalker var1) throws SQLException;

    abstract void encode(CharacterBuffer var1, int var2) throws SQLException;

    static final void failCharacterConversion(CharacterSet characterSet) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(null, 55, characterSet);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static final byte[] useOrCopy(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        if (byArray.length == n3 && n2 == 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        return byArray2;
    }

    static final void need(CharacterBuffer characterBuffer, int n2) {
        int n3 = n2 + characterBuffer.next;
        int n4 = characterBuffer.bytes.length;
        if (n3 <= n4) {
            return;
        }
        while (n3 > n4) {
            n4 = 2 * n4;
        }
        byte[] byArray = characterBuffer.bytes;
        characterBuffer.bytes = new byte[n4];
        System.arraycopy(byArray, 0, characterBuffer.bytes, 0, characterBuffer.next);
    }

    public static final String UTFToString(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        return new String(CharacterSet.UTFToJavaChar(byArray, n2, n3, bl));
    }

    public static final String UTFToString(byte[] byArray, int n2, int n3) throws SQLException {
        return CharacterSet.UTFToString(byArray, n2, n3, false);
    }

    public static final char[] UTFToJavaChar(byte[] byArray, int n2, int n3) throws SQLException {
        return CharacterSet.UTFToJavaChar(byArray, n2, n3, false);
    }

    public static final char[] UTFToJavaChar(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        char[] cArray = null;
        cArray = new char[n3];
        int[] nArray = new int[]{n3};
        int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, bl);
        char[] cArray2 = new char[n4];
        System.arraycopy(cArray, 0, cArray2, 0, n4);
        cArray = null;
        return cArray2;
    }

    public static final char[] UTFToJavaCharWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray = null;
        try {
            cArray = new char[n3];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, true);
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = null;
            return cArray2;
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException.getMessage());
        }
    }

    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl) throws SQLException {
        return CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, n3, nArray, bl, cArray.length - n3);
    }

    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl, int n4) throws SQLException {
        int n5;
        CharacterConverterBehavior characterConverterBehavior = bl ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int n6 = nArray[0];
        nArray[0] = 0;
        int n7 = n2;
        int n8 = n2 + n6;
        int n9 = n3;
        int n10 = n3 + n4;
        block5: while (n7 < n8) {
            byte by = byArray[n7++];
            n5 = by & 0xF0;
            switch (n5 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n9 < n10) {
                        cArray[n9++] = (char)(by & 0xFFFFFFFF);
                        continue block5;
                    }
                    nArray[0] = n8 - n7 + 2;
                    break block5;
                }
                case 12: 
                case 13: {
                    if (n7 >= n8) {
                        nArray[0] = 1;
                        characterConverterBehavior.onFailConversion();
                        break block5;
                    }
                    char c2 = CharacterSet.conv2ByteUTFtoUTF16(by, byArray[n7++]);
                    if (n9 >= n10) {
                        nArray[0] = n8 - n7 + 3;
                        break block5;
                    }
                    cArray[n9++] = c2;
                    characterConverterBehavior.onFailConversion(c2);
                    continue block5;
                }
                case 14: {
                    char c2;
                    if (n7 + 1 >= n8) {
                        nArray[0] = n8 - n7 + 1;
                        characterConverterBehavior.onFailConversion();
                        break block5;
                    }
                    char c3 = CharacterSet.conv3ByteUTFtoUTF16(by, byArray[n7++], byArray[n7++]);
                    if (n5 != 244 && byArray[n7 - 2] != -65 && byArray[n7 - 1] != -67) {
                        characterConverterBehavior.onFailConversion(c3);
                    }
                    if (CharacterSet.isHiSurrogate(c3)) {
                        if (n9 > n10 - 2) {
                            nArray[0] = n8 - n7 + 4;
                            break block5;
                        }
                        if (n7 >= n8) continue block5;
                        by = byArray[n7];
                        if ((byte)(by & 0xF0) != -32) {
                            cArray[n9++] = 65533;
                            characterConverterBehavior.onFailConversion();
                            continue block5;
                        }
                        if (++n7 + 1 >= n8) {
                            nArray[0] = n8 - n7 + 1;
                            characterConverterBehavior.onFailConversion();
                            break block5;
                        }
                        if (CharacterSet.isLoSurrogate(c2 = CharacterSet.conv3ByteUTFtoUTF16(by, byArray[n7++], byArray[n7++]))) {
                            cArray[n9++] = c3;
                        } else {
                            cArray[n9++] = 65533;
                            characterConverterBehavior.onFailConversion();
                        }
                        cArray[n9++] = c2;
                        continue block5;
                    }
                    if (n9 < n10) {
                        cArray[n9++] = c3;
                        continue block5;
                    }
                    nArray[0] = n8 - n7 + 4;
                    break block5;
                }
                default: {
                    if (n9 >= n10) {
                        nArray[0] = n8 - n7 + 2;
                        break block5;
                    }
                    cArray[n9++] = 65533;
                    characterConverterBehavior.onFailConversion();
                    continue block5;
                }
            }
        }
        n5 = n9 - n3;
        return n5;
    }

    public static final byte[] stringToUTF(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length * 3;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray = new byte[n2];
        int n3 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, byArray, 0, cArray.length);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byArray = null;
        return byArray2;
    }

    public static final int convertJavaCharsToUTFBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6 = n2;
        int n7 = n2 + n4;
        int n8 = n3;
        for (int i2 = n6; i2 < n7; ++i2) {
            n5 = cArray[i2];
            if (n5 >= 0 && n5 <= 127) {
                byArray[n8++] = (byte)n5;
                continue;
            }
            if (n5 > 2047) {
                byArray[n8++] = (byte)(0xE0 | n5 >>> 12 & 0xF);
                byArray[n8++] = (byte)(0x80 | n5 >>> 6 & 0x3F);
                byArray[n8++] = (byte)(0x80 | n5 >>> 0 & 0x3F);
                continue;
            }
            byArray[n8++] = (byte)(0xC0 | n5 >>> 6 & 0x1F);
            byArray[n8++] = (byte)(0x80 | n5 >>> 0 & 0x3F);
        }
        n5 = n8 - n3;
        return n5;
    }

    public static final int UTFStringLength(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        int n6 = n2 + n3;
        block6: while (n5 < n6) {
            switch ((byArray[n5] & 0xF0) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n5;
                    ++n4;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (n5 + 1 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    ++n4;
                    n5 += 2;
                    continue block6;
                }
                case 14: {
                    if (n5 + 2 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    ++n4;
                    n5 += 3;
                    continue block6;
                }
                case 15: {
                    if (n5 + 3 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    n4 += 2;
                    n5 += 4;
                    continue block6;
                }
            }
            ++n5;
            ++n4;
        }
        return n4;
    }

    public static final int stringUTFLength(String string) {
        char[] cArray = string.toCharArray();
        return CharacterSet.charArrayUTF8Length(cArray);
    }

    static final int charArrayUTF8Length(char[] cArray) {
        int n2 = 0;
        for (char c2 : cArray) {
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static final String AL32UTF8ToString(byte[] byArray, int n2, int n3) {
        return CharacterSet.AL32UTF8ToString(byArray, n2, n3, false);
    }

    public static final String AL32UTF8ToString(byte[] byArray, int n2, int n3, boolean bl) {
        char[] cArray = null;
        try {
            cArray = CharacterSet.AL32UTF8ToJavaChar(byArray, n2, n3, bl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new String(cArray);
    }

    public static final char[] AL32UTF8ToJavaChar(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        char[] cArray = null;
        try {
            cArray = new char[n3];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n2, cArray, 0, nArray, bl);
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = null;
            return cArray2;
        }
        catch (SQLException sQLException) {
            CharacterSet.failUTFConversion();
            return new char[0];
        }
    }

    public static final int convertAL32UTF8BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl) throws SQLException {
        return CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n2, cArray, n3, nArray, bl, cArray.length - n3);
    }

    public static final int convertAL32UTF8BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl, int n4) throws SQLException {
        int n5;
        CharacterConverterBehavior characterConverterBehavior = bl ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int n6 = nArray[0];
        nArray[0] = 0;
        int n7 = n2;
        int n8 = n2 + n6;
        int n9 = n3;
        int n10 = n3 + n4;
        block6: while (n7 < n8) {
            byte by = byArray[n7++];
            int n11 = by & 0xF0;
            switch (n11 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n9 < n10) {
                        cArray[n9++] = (char)(by & 0xFFFFFFFF);
                        continue block6;
                    }
                    nArray[0] = n8 - n7 + 2;
                    break block6;
                }
                case 12: 
                case 13: {
                    if (n7 >= n8) {
                        nArray[0] = 1;
                        characterConverterBehavior.onFailConversion();
                        break block6;
                    }
                    char c2 = CharacterSet.conv2ByteUTFtoUTF16(by, byArray[n7++]);
                    if (n9 >= n10) {
                        nArray[0] = n8 - n7 + 3;
                        break block6;
                    }
                    cArray[n9++] = c2;
                    characterConverterBehavior.onFailConversion(c2);
                    continue block6;
                }
                case 14: {
                    if (n7 + 1 >= n8) {
                        nArray[0] = n8 - n7 + 1;
                        characterConverterBehavior.onFailConversion();
                        break block6;
                    }
                    char c2 = CharacterSet.conv3ByteAL32UTF8toUTF16(by, byArray[n7++], byArray[n7++]);
                    if (n9 >= n10) {
                        nArray[0] = n8 - n7 + 4;
                        break block6;
                    }
                    cArray[n9++] = c2;
                    characterConverterBehavior.onFailConversion(c2);
                    continue block6;
                }
                case 15: {
                    if (n7 + 2 >= n8) {
                        nArray[0] = n8 - n7 + 1;
                        characterConverterBehavior.onFailConversion();
                        break block6;
                    }
                    if (n9 > n10 - 2) {
                        nArray[0] = n8 - n7 + 2;
                        break block6;
                    }
                    if ((n5 = CharacterSet.conv4ByteAL32UTF8toUTF16(by, byArray[n7++], byArray[n7++], byArray[n7++], cArray, n9)) == 1) {
                        characterConverterBehavior.onFailConversion();
                        ++n9;
                        continue block6;
                    }
                    n9 += 2;
                    continue block6;
                }
                default: {
                    if (n9 >= n10) {
                        nArray[0] = n8 - n7 + 2;
                        break block6;
                    }
                    cArray[n9++] = 65533;
                    characterConverterBehavior.onFailConversion();
                    continue block6;
                }
            }
        }
        n5 = n9 - n3;
        return n5;
    }

    public static final byte[] stringToAL32UTF8(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length * 3;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray = new byte[n2];
        int n3 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, 0, byArray, 0, cArray.length);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byArray = null;
        return byArray2;
    }

    public static final int convertJavaCharsToAL32UTF8Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6 = n2;
        int n7 = n2 + n4;
        int n8 = n3;
        for (int i2 = n6; i2 < n7; ++i2) {
            char c2 = cArray[i2];
            char c3 = '\u0000';
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                byArray[n8++] = (byte)c2;
                continue;
            }
            if (CharacterSet.isHiSurrogate(c2)) {
                if (i2 + 1 < n7 && CharacterSet.isLoSurrogate(c3 = cArray[i2 + 1])) {
                    n5 = (c2 >>> 6 & 0xF) + 1;
                    byArray[n8++] = (byte)(n5 >>> 2 | 0xF0);
                    byArray[n8++] = (byte)((n5 & 3) << 4 | c2 >>> 2 & 0xF | 0x80);
                    byArray[n8++] = (byte)((c2 & 3) << 4 | c3 >>> 6 & 0xF | 0x80);
                    byArray[n8++] = (byte)(c3 & 0x3F | 0x80);
                    ++i2;
                    continue;
                }
                byArray[n8++] = -17;
                byArray[n8++] = -65;
                byArray[n8++] = -67;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n8++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                byArray[n8++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                byArray[n8++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                continue;
            }
            byArray[n8++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
            byArray[n8++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
        }
        n5 = n8 - n3;
        return n5;
    }

    public static final int string32UTF8Length(String string) {
        return CharacterSet.charArray32UTF8Length(string.toCharArray());
    }

    static final int charArray32UTF8Length(char[] cArray) {
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 > '\u07ff') {
                if (CharacterSet.isHiSurrogate(c2)) {
                    if (i2 + 1 >= n3) continue;
                    n2 += 4;
                    ++i2;
                    continue;
                }
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static final String AL16UTF16BytesToString(byte[] byArray, int n2) {
        char[] cArray = new char[n2 >>> 1];
        CharacterSet.AL16UTF16BytesToJavaChars(byArray, n2, cArray);
        return new String(cArray);
    }

    public static final int AL16UTF16BytesToJavaChars(byte[] byArray, int n2, char[] cArray) {
        int n3;
        int n4 = n2 >>> 1;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = byArray[n5] << 8;
            cArray[n3] = (char)(n6 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
        }
        return n3;
    }

    public static final int convertAL16UTF16BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean bl) throws SQLException {
        CharacterConverterBehavior characterConverterBehavior = bl ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int n5 = n3;
        int n6 = n2;
        int n7 = n2 + n4;
        while (n6 + 1 < n7) {
            int n8 = byArray[n6] << 8;
            char c2 = (char)(n8 | byArray[n6 + 1] & 0xFF);
            cArray[n5++] = c2;
            n6 += 2;
        }
        n6 = n5 - n3;
        return n6;
    }

    public static final int convertAL16UTF16LEBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean bl) throws SQLException {
        CharacterConverterBehavior characterConverterBehavior = bl ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int n5 = n3;
        int n6 = n2;
        int n7 = n2 + n4;
        while (n6 + 1 < n7) {
            int n8 = byArray[n6 + 1] << 8;
            int n9 = n8 | byArray[n6] & 0xFF;
            if (CharacterSet.isHiSurrogate((char)n9)) {
                if ((n6 += 2) + 1 < n7) {
                    char c2 = (char)((byArray[n6 + 1] << 8) + (byArray[n6] & 0xFF));
                    cArray[n5++] = CharacterSet.isLoSurrogate(c2) ? n9 : 65533;
                    cArray[n5++] = c2;
                }
            } else {
                cArray[n5++] = n9;
            }
            n6 += 2;
        }
        n6 = n5 - n3;
        return n6;
    }

    public static final byte[] stringToAL16UTF16Bytes(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        byte[] byArray = new byte[n2 * 2];
        CharacterSet.javaCharsToAL16UTF16Bytes(cArray, n2, byArray);
        return byArray;
    }

    public static final int javaCharsToAL16UTF16Bytes(char[] cArray, int n2, byte[] byArray) {
        int n3 = Math.min(n2, byArray.length >>> 1);
        return CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, 0, byArray, 0, n3);
    }

    public static final int convertJavaCharsToAL16UTF16Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        int n6 = n3;
        int n7 = n2 + n4;
        while (n5 < n7) {
            byArray[n6] = (byte)(cArray[n5] >>> 8 & 0xFF);
            byArray[n6 + 1] = (byte)(cArray[n5] & 0xFF);
            ++n5;
            n6 += 2;
        }
        return n6 - n3;
    }

    public static final byte[] stringToAL16UTF16LEBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        CharacterSet.javaCharsToAL16UTF16LEBytes(cArray, cArray.length, byArray);
        return byArray;
    }

    public static final int javaCharsToAL16UTF16LEBytes(char[] cArray, int n2, byte[] byArray) {
        return CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, 0, byArray, 0, n2);
    }

    public static final int convertJavaCharsToAL16UTF16LEBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        int n6 = n3;
        int n7 = n2 + n4;
        while (n5 < n7) {
            byArray[n6] = (byte)(cArray[n5] & 0xFF);
            byArray[n6 + 1] = (byte)(cArray[n5] >>> 8);
            ++n5;
            n6 += 2;
        }
        return n6 - n3;
    }

    public static final int convertASCIIBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        int n5 = n3 + n4;
        int n6 = n3;
        int n7 = n2;
        while (n6 < n5) {
            cArray[n6] = (char)(0xFF & byArray[n7]);
            ++n6;
            ++n7;
        }
        return n4;
    }

    public static final int convertJavaCharsToASCIIBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        CharacterSet.convertJavaCharsToASCIIBytes(cArray, n2, byArray, n3, n4, false);
        return n4;
    }

    public static final int convertJavaCharsToASCIIBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4, boolean bl) throws SQLException {
        if (bl) {
            if (asciiCharSet == null) {
                asciiCharSet = CharacterSet.make(1);
            }
            byte[] byArray2 = asciiCharSet.convertWithReplacement(new String(cArray, n2, n4));
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            return byArray2.length;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n3 + i2] = (byte)cArray[n2 + i2];
        }
        return n4;
    }

    public static final int convertJavaCharsToISOLATIN1Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = cArray[n2 + i2];
            byArray[n3 + i2] = c2 > '\u00ff' ? -65 : (byte)c2;
        }
        return n4;
    }

    public static final byte[] stringToASCII(String string) {
        byte[] byArray = new byte[string.length()];
        byArray = string.getBytes();
        return byArray;
    }

    public static final long convertUTF32toUTF16(long l2) {
        if (l2 > 65535L) {
            long l3 = 0xD8L | l2 - 65536L >> 18 & 0xFFL;
            l3 = l2 - 65536L >> 10 & 0xFFL | l3 << 8;
            l3 = 0xDCL | (l2 & 0x3FFL) >> 8 & 0xFFL | l3 << 8;
            l3 = l2 & 0xFFL | l3 << 8;
            return l3;
        }
        return l2;
    }

    static final boolean isHiSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\ud800';
    }

    static final boolean isLoSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\udc00';
    }

    static final boolean check80toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128;
    }

    static final boolean check80to8F(byte by) {
        return (by & 0xFFFFFFF0) == -128;
    }

    static final boolean check80to9F(byte by) {
        return (by & 0xFFFFFFE0) == -128;
    }

    static final boolean checkA0toBF(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    static final boolean check90toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128 && (by & 0x30) != 0;
    }

    static final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        if (by < -62 || by > -33 || !CharacterSet.check80toBF(by2)) {
            return '\ufffd';
        }
        return (char)((by & 0x1F) << 6 | by2 & 0x3F);
    }

    static final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && CharacterSet.checkA0toBF(by2) && CharacterSet.check80toBF(by3) || by >= -31 && by <= -17 && CharacterSet.check80toBF(by2) && CharacterSet.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && CharacterSet.checkA0toBF(by2) && CharacterSet.check80toBF(by3) || by >= -31 && by <= -20 && CharacterSet.check80toBF(by2) && CharacterSet.check80toBF(by3) || by == -19 && CharacterSet.check80to9F(by2) && CharacterSet.check80toBF(by3) || by >= -18 && by <= -17 && CharacterSet.check80toBF(by2) && CharacterSet.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n2) {
        boolean bl = false;
        if (!(by == -16 && CharacterSet.check90toBF(by2) && CharacterSet.check80toBF(by3) && CharacterSet.check80toBF(by4) || by >= -15 && by <= -13 && CharacterSet.check80toBF(by2) && CharacterSet.check80toBF(by3) && CharacterSet.check80toBF(by4) || by == -12 && CharacterSet.check80to8F(by2) && CharacterSet.check80toBF(by3) && CharacterSet.check80toBF(by4))) {
            cArray[n2] = 65533;
            return 1;
        }
        cArray[n2] = (char)((((by & 7) << 2 | by2 >>> 4 & 3) - 1 & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >>> 4 & 3 | 0xD800);
        cArray[n2 + 1] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
        return 2;
    }

    static void failUTFConversion() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(null, 55);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public int encodedByteLength(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.convertWithReplacement(string).length;
    }

    public int encodedByteLength(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0;
        }
        return this.convertWithReplacement(new String(cArray)).length;
    }

    public int toCharWithReplacement(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    static {
        try {
            Class.forName("oracle.i18n.text.converter.CharacterConverterSJIS");
            CharacterSetWithConverter.ccFactory = new CharacterConverterFactoryOGS();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        factory = new CharacterSetFactoryDefault();
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS = new char[1];
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior("Report Error"){

            @Override
            public void onFailConversion() throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 55);
                sQLException.fillInStackTrace();
                throw sQLException;
            }

            @Override
            public void onFailConversion(char c2) throws SQLException {
                if (c2 == '\ufffd') {
                    SQLException sQLException = DatabaseError.createSqlException(null, 55);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior("Replacement"){

            @Override
            public void onFailConversion() throws SQLException {
            }

            @Override
            public void onFailConversion(char c2) throws SQLException {
            }
        };
        private final String m_name;

        public CharacterConverterBehavior(String string) {
            this.m_name = string;
        }

        public abstract void onFailConversion(char var1) throws SQLException;

        public abstract void onFailConversion() throws SQLException;
    }
}

