/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

final class JavaVersion {
    JavaVersion() {
    }

    String maxVersion() {
        return System.getProperty("ide.java.maxversion", this.defaultMaxVersion());
    }

    String minVersion() {
        return System.getProperty("ide.java.minversion", this.defaultMinVersion());
    }

    private String defaultMaxVersion() {
        return "1.8";
    }

    private String defaultMinVersion() {
        return "1.6.0_35";
    }

    String currentVersion() {
        return System.getProperty("java.version");
    }

    private String normalizedMaxVersion() {
        return this.normalize(this.maxVersion());
    }

    private String normalizedMinVersion() {
        return this.normalize(this.minVersion());
    }

    private String normalizedCurrentVersion() {
        return this.normalize(this.currentVersion());
    }

    boolean isSupported() {
        String minVersion = this.normalizedMinVersion();
        String maxVersion = this.normalizedMaxVersion();
        String curVersion = this.normalizedCurrentVersion();
        boolean atLeastMin = minVersion.compareTo(curVersion) <= 0;
        boolean belowMax = maxVersion.compareTo(curVersion) > 0;
        return atLeastMin && belowMax;
    }

    private String normalize(String versionString) {
        versionString = versionString.trim();
        StringBuilder mainversion = new StringBuilder();
        StringBuilder subversion = null;
        boolean subversionIsNumeric = true;
        for (int i = 0; i < versionString.length(); ++i) {
            char c = versionString.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                if (subversion == null) {
                    mainversion.append(c);
                    continue;
                }
                subversion.append(c);
                continue;
            }
            if (subversion != null) {
                if (subversion.length() > 0 && c == '-') break;
                subversionIsNumeric = false;
                continue;
            }
            if (c != '_') continue;
            subversion = new StringBuilder();
        }
        if (subversion != null && subversionIsNumeric) {
            mainversion.append('.');
            mainversion.append((CharSequence)subversion);
        }
        return mainversion.toString();
    }
}

