/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ide.osgi.boot.api.IdeBootProperties;

public class DeadlockDetector {
    private static final DeadlockDetector INSTANCE = new DeadlockDetector();
    private static final boolean TESTING = Boolean.getBoolean("ide.test.deadlock.detector");
    private static final long INTERVAL = TESTING ? 5000L : 60000L;
    private static final boolean DISABLED = Boolean.getBoolean("ide.disable.deadlock.detector");
    private Timer timer;
    private TimerTask task;
    private volatile String className;
    private volatile String methodName;
    private volatile File reportDir;
    private final ThreadMXBean threadBean = DISABLED ? null : ManagementFactory.getThreadMXBean();
    private final AtomicInteger purgeCounter = new AtomicInteger(1);

    public static DeadlockDetector getInstance() {
        return INSTANCE;
    }

    private DeadlockDetector() {
    }

    public synchronized void start() {
        if (DISABLED) {
            return;
        }
        this.scheduleTask();
        if (TESTING) {
            this.testDeadlockDetector();
        }
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void setClassName(String className) {
        this.className = className;
        this.reschedule();
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.reschedule();
    }

    private synchronized void reschedule() {
        if (!DISABLED) {
            this.cancelTask();
            this.scheduleTask();
        }
    }

    private synchronized void cancelTask() {
        if (this.task != null) {
            this.task.cancel();
            int count = this.purgeCounter.getAndIncrement();
            if (count % 1000 == 0) {
                this.timer.purge();
            }
        }
    }

    private synchronized void scheduleTask() {
        if (this.timer == null) {
            this.timer = new Timer("IDE Deadlock Detector", true);
        }
        if (this.task == null) {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    DeadlockDetector.this.checkForDeadlocks();
                }
            };
            this.timer.scheduleAtFixedRate(this.task, INTERVAL, INTERVAL);
        }
    }

    public void checkForDeadlocks() {
        if (!DISABLED) {
            long[] deadlocked;
            long[] lArray = deadlocked = this.threadBean.isSynchronizerUsageSupported() ? this.threadBean.findDeadlockedThreads() : this.threadBean.findMonitorDeadlockedThreads();
            if (deadlocked != null) {
                this.handleDeadlock(deadlocked);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeadlock(long[] threadIds) {
        ThreadInfo[] deadlocked;
        StringBuilder builder = new StringBuilder();
        String separator = System.getProperty("line.separator");
        builder.append("Deadlock detected:");
        builder.append(separator);
        builder.append("==================");
        builder.append(separator);
        builder.append(separator);
        for (ThreadInfo ti : deadlocked = this.threadBean.getThreadInfo(threadIds, true, true)) {
            builder.append("\"");
            builder.append(ti.getThreadName());
            builder.append("\":");
            builder.append(separator);
            String lockName = ti.getLockName();
            if (lockName == null) continue;
            builder.append("  waiting to lock " + lockName);
            builder.append(separator);
            String owner = ti.getLockOwnerName();
            if (owner == null) continue;
            builder.append("  which is held by \"");
            builder.append(ti.getLockOwnerName());
            builder.append("\"");
            builder.append(separator);
        }
        builder.append(separator);
        builder.append("Full thread dump:");
        builder.append(separator);
        builder.append("=================");
        builder.append(separator);
        for (ThreadInfo ti : this.threadBean.dumpAllThreads(true, true)) {
            builder.append(this.toString(ti));
        }
        String report = builder.toString();
        System.err.print(builder.toString());
        File reportFile = this.getDeadlockReportFile();
        if (reportFile != null) {
            try {
                PrintWriter out = new PrintWriter(reportFile);
                try {
                    out.print(report.toString());
                    System.err.println("Deadlock report written to " + reportFile);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                System.err.println("Unable to write deadlock report to " + reportFile);
            }
        }
        if (this.shouldKillProcess()) {
            System.setProperty("oracle.ide.ignore.checkExit", Boolean.toString(false));
            try {
                Runtime.getRuntime().halt(-1);
            }
            catch (SecurityException e) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> topSecurityManager = cl.loadClass("org.netbeans.TopSecurityManager");
                    if (topSecurityManager.isAssignableFrom(System.getSecurityManager().getClass())) {
                        Method uninstall = topSecurityManager.getDeclaredMethod("uninstall", new Class[0]);
                        uninstall.setAccessible(true);
                        uninstall.invoke(null, new Object[0]);
                        Runtime.getRuntime().halt(-1);
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                System.err.println("Unable to exit JVM");
                e.printStackTrace();
            }
        } else {
            this.stop();
        }
    }

    private String toString(ThreadInfo ti) {
        LockInfo[] locks;
        int i;
        String separator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append(separator);
        StackTraceElement[] stackTrace = ti.getStackTrace();
        for (i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append(separator);
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + ti.getLockInfo());
                        sb.append(separator);
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append(separator);
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append(separator);
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : ti.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append(separator);
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append(separator);
        }
        if ((locks = ti.getLockedSynchronizers()).length > 0) {
            sb.append(separator);
            sb.append("\tNumber of locked synchronizers = " + locks.length);
            sb.append(separator);
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append(separator);
            }
        }
        sb.append(separator);
        return sb.toString();
    }

    private boolean shouldKillProcess() {
        RuntimeMXBean runtime;
        if (Boolean.getBoolean("ide.never.kill.process.on.deadlock")) {
            return false;
        }
        if (Boolean.getBoolean("ide.always.kill.process.on.deadlock")) {
            return true;
        }
        return GraphicsEnvironment.isHeadless() && (runtime = ManagementFactory.getRuntimeMXBean()) != null && !runtime.getInputArguments().contains("-Xdebug");
    }

    private File getDeadlockReportFile() {
        File reportDir = this.getDeadlockReportDir();
        if (reportDir != null) {
            File testDir;
            File file = new File(reportDir, this.getFileName("DEADLOCK.txt"));
            String localClassName = this.className;
            if (localClassName != null && (testDir = new File(reportDir, localClassName)).mkdirs()) {
                String localMethodName = this.methodName;
                file = localMethodName != null ? new File(testDir, this.getFileName(localMethodName + "-DEADLOCK.txt")) : new File(testDir, "deadlock.txt");
            }
            return file;
        }
        return null;
    }

    public void setDeadlockReportDir(File reportDir) {
        if (this.reportDir == null) {
            this.reportDir = reportDir;
        }
    }

    private File getDeadlockReportDir() {
        File tempDir;
        File diagnosticsDir;
        File localReportDir = this.reportDir;
        if (localReportDir != null) {
            return localReportDir;
        }
        String diagnosticsDirProperty = IdeBootProperties.getDiagnosticsDirectory();
        if (diagnosticsDirProperty != null && !diagnosticsDirProperty.trim().isEmpty() && (diagnosticsDir = new File(diagnosticsDirProperty)).isDirectory()) {
            return diagnosticsDir;
        }
        String tempDirProperty = System.getProperty("java.io.tmpdir");
        if (tempDirProperty != null && !tempDirProperty.trim().isEmpty() && (tempDir = new File(tempDirProperty)).isDirectory()) {
            return tempDir;
        }
        return null;
    }

    private String getFileName(String suffix) {
        Calendar calendar = Calendar.getInstance();
        StringBuilder name = new StringBuilder();
        name.append(calendar.get(1));
        DeadlockDetector.append(name, calendar.get(2) + 1, 2);
        DeadlockDetector.append(name, calendar.get(5), 2);
        name.append('-');
        DeadlockDetector.append(name, calendar.get(11), 2);
        DeadlockDetector.append(name, calendar.get(12), 2);
        DeadlockDetector.append(name, calendar.get(13), 2);
        if (suffix != null && !suffix.isEmpty()) {
            name.append("-" + suffix);
        }
        return name.toString();
    }

    private static void append(StringBuilder buffer, int value, int width) {
        String string = String.valueOf(value);
        for (int i = string.length(); i < width; ++i) {
            buffer.append('0');
        }
        buffer.append(string);
    }

    private void testDeadlockDetector() {
        Object a = new Object();
        Object b = new Object();
        final CountDownLatch latch = new CountDownLatch(2);
        class DeadlockThread
        extends Thread {
            private final Object[] locks;

            DeadlockThread(String name, Object[] locks) {
                super(name);
                this.locks = locks;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    Object object = this.locks[0];
                    synchronized (object) {
                        latch.countDown();
                        latch.await();
                        Object object2 = this.locks[1];
                        synchronized (object2) {
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        new DeadlockThread("AB", new Object[]{a, b}).start();
        new DeadlockThread("BA", new Object[]{b, a}).start();
    }
}

