/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.awt.GraphicsEnvironment;

public class IdeBootProperties {
    private static final String AWT_HEADLESS_PROPERTY = "java.awt.headless";
    private static final String ASSERT_TRACING_DISABLED_PROPERTY = "ide.AssertTracingDisabled";
    private static final String DEBUG_BUILD_PROPERTY = "ide.debugbuild";
    private static final String DIAGNOSTICS_DIR_PROPERTY = "ide.diagnostics.dir";
    private static final String HIDDEN_FRAME_ICON_PROPERTY = "hidden.frame.icon";
    private static final String IDE_ARGS_PROPERTY = "oracle.ide.args";
    private static final String IDE_BUNDLE_SEARCH_PATH_PROPERTY = "ide.bundle.search.path";
    private static final String IDE_CLUSTER_DIRS_PROPERTY = "ide.cluster.dirs";
    private static final String IDE_CONF_PATH_PROPERTY = "ide.conf";
    private static final String IDE_LOGGING_CONFIG_FILE_PROPERTY = "ide.logging.config.file";
    private static final String IDE_LOGGING_NONDEBUG_PROPERTY = "ide.logging.nondebug";
    private static final String IDE_LOGGING_PROPERTIES_PROPERTY = "ide.logging.properties";
    private static final String IDE_PATCHES_DIR_PROPERTY = "ide.patches.dir";
    private static final String IDE_PREF_DIR_PROPERTY = "ide.pref.dir";
    private static final String IDE_PRODUCT_PROPERTY = "ide.product";
    private static final String IDE_SUPPORTED_LOCALES_PROPERTY = "ide.supportedLocales";
    private static final String IDE_THROTTLE_LOCALE_PROPERTY = "ide.throttleLocale";
    private static final String IDE_USER_DIR_PROPERTY = "ide.user.dir";
    private static final String IDE_WORK_DIR_PROPERTY = "ide.work.dir";
    private static final String IDE_SPLASH_SCREEN_PROPERTY = "ide.splash.screen";
    private static final String IDE_RECTANGULAR_SPLASH_SCREEN_PROPERTY = "ide.RectangularSplashScreen";
    private static final String JAVA_HOME_PROPERTY = "java.home";
    private static final String JAVA_RUNTIME_VERSION_PROPERTY = "java.runtime.version";
    private static final String LOGGING_CONFIG_CLASS_PROPERTY = "java.util.logging.config.class";
    private static final String LOGGING_CONFIG_FILE_PROPERTY = "java.util.logging.config.file";
    private static final String NETBEANS_HOME_PROPERTY = "netbeans.home";
    private static final String NETBEANS_USER_PROPERTY = "netbeans.user";
    private static final String ORACLE_DOT_HOME_PROPERTY = "oracle.home";
    private static final String ORACLE_FMW_DIR_PROPERTY = "oracle.fmw.dir";
    private static final String ORACLE_PRODUCT_HOME_PROPERTY = "oracle.product.home";
    public static final String ORACLE_INSTALL_TIMESTAMP_LOCATION = "oracle.install.timestamp.location";
    public static final String ORACLE_INSTALL_RESCAN = "oracle.install.rescan";
    private static final String ORACLE_FCP_HOME_PROPERTY = "oracle.fcp.home";
    private static final String ORACLE_JRF_HOME_PROPERTY = "oracle.jrf.home";
    private static final String ORACLE_HOME_PROPERTY = "ORACLE_HOME";
    private static final String OS_VERSION_PROPERTY = "os.version";
    private static final String OSGI_CLEAN_PROPERTY = "osgi.clean";
    private static final String OSGI_CONFIGURATION_AREA_PROPERTY = "osgi.configuration.area";
    private static final String OSGI_CONSOLE_PROPERTY = "osgi.console";
    private static final String OSGI_FRAMEWORK_VERSION_PROPERTY = "osgi.framework.version";
    private static final String OSGI_FRAMEWORK_LIBRARY_EXTENSIONS_PROPERTY = "osgi.framework.library.extensions";
    private static final String PRODUCT_CLUSTER_DIRS_PROPERTY = "product.cluster.dirs";
    private static final String SIMPLE_CONFIGURATOR_PROPERTY = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String SYSTEM_DIR_PROPERTY = "ide.system.dir";
    private static final String TOOL_USER_CONF_PATH_PROPERTY = "tool.user.conf";
    private static final String USER_CONF_PATH_PROPERTY = "user.conf";
    private static final String USER_COUNTRY_PROPERTY = "user.country";
    private static final String USER_DIR_PROPERTY = "user.dir";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_LANGUAGE_PROPERTY = "user.language";

    public static String getIDEClusterDirectories() {
        String ideClusterDirs = System.getProperty(IDE_CLUSTER_DIRS_PROPERTY);
        if (ideClusterDirs == null) {
            throw new IllegalStateException("Missing ide.cluster.dirs");
        }
        return ideClusterDirs;
    }

    public static String getProductClusterDirectories() {
        return System.getProperty(PRODUCT_CLUSTER_DIRS_PROPERTY);
    }

    public static String getNetbeansHome() {
        String netbeansHome = System.getProperty(NETBEANS_HOME_PROPERTY);
        if (netbeansHome == null) {
            throw new IllegalStateException("Missing netbeans.home");
        }
        return netbeansHome;
    }

    public static void setNetbeansHome(String value) {
        System.setProperty(NETBEANS_HOME_PROPERTY, value);
    }

    public static String getNetbeansCacheDirectory() {
        return System.getProperty(NETBEANS_USER_PROPERTY);
    }

    public static void setNetbeansCacheDirectory(String value) {
        System.setProperty(NETBEANS_USER_PROPERTY, value);
    }

    public static String getOsgiFrameworkVersion() {
        return System.getProperty(OSGI_FRAMEWORK_VERSION_PROPERTY);
    }

    public static String getOsgiFrameworkLibraryExtensions() {
        return System.getProperty(OSGI_FRAMEWORK_LIBRARY_EXTENSIONS_PROPERTY);
    }

    public static String getPatchesDirectory() {
        return System.getProperty(IDE_PATCHES_DIR_PROPERTY);
    }

    public static String getOsgiCleanProperty() {
        return System.getProperty(OSGI_CLEAN_PROPERTY);
    }

    public static void setOsgiCleanProperty(String value) {
        System.setProperty(OSGI_CLEAN_PROPERTY, value);
    }

    public static String getOsgiConsoleProperty() {
        return System.getProperty(OSGI_CONSOLE_PROPERTY);
    }

    public static void setOsgiConsoleProperty(String value) {
        System.setProperty(OSGI_CONSOLE_PROPERTY, value);
    }

    public static void setOsgiFrameworkLibraryExtensions(String value) {
        System.setProperty(OSGI_FRAMEWORK_LIBRARY_EXTENSIONS_PROPERTY, value);
    }

    public static String getBundleSearchPath() {
        return System.getProperty(IDE_BUNDLE_SEARCH_PATH_PROPERTY);
    }

    public static void setBundleSearchPath(String value) {
        System.setProperty(IDE_BUNDLE_SEARCH_PATH_PROPERTY, value);
    }

    public static String getIdeArguments() {
        return System.getProperty(IDE_ARGS_PROPERTY);
    }

    public static void setIdeArguments(String args) {
        System.setProperty(IDE_ARGS_PROPERTY, args);
    }

    public static boolean isHeadlessMode() {
        return GraphicsEnvironment.isHeadless();
    }

    public static void setHeadlessMode(String value) {
        System.setProperty(AWT_HEADLESS_PROPERTY, value);
    }

    public static String getJavaVersion() {
        return System.getProperty(JAVA_RUNTIME_VERSION_PROPERTY);
    }

    public static String getJavaHome() {
        return System.getProperty(JAVA_HOME_PROPERTY);
    }

    public static String getIdeThrottleLocale(String defaultValue) {
        return System.getProperty(IDE_THROTTLE_LOCALE_PROPERTY, defaultValue);
    }

    public static String getSupportedLocales(String defaultValue) {
        return System.getProperty(IDE_SUPPORTED_LOCALES_PROPERTY, defaultValue);
    }

    public static String getUserCountry() {
        return System.getProperty(USER_COUNTRY_PROPERTY);
    }

    public static String setUserCountry(String value) {
        return System.setProperty(USER_COUNTRY_PROPERTY, value);
    }

    public static String getUserLanguage() {
        return System.getProperty(USER_LANGUAGE_PROPERTY);
    }

    public static String setUserLanguage(String value) {
        return System.setProperty(USER_LANGUAGE_PROPERTY, value);
    }

    public static Boolean isDebugBuild() {
        return Boolean.getBoolean(DEBUG_BUILD_PROPERTY);
    }

    public static void setDebugBuild(String value) {
        System.setProperty(DEBUG_BUILD_PROPERTY, value);
    }

    public static boolean hasAssertTracingDisabled() {
        return System.getProperty(ASSERT_TRACING_DISABLED_PROPERTY) != null;
    }

    public static Boolean isAssertTracingDisabled() {
        return Boolean.getBoolean(ASSERT_TRACING_DISABLED_PROPERTY);
    }

    public static void setAssertTracingDisabled(boolean value) {
        System.setProperty(ASSERT_TRACING_DISABLED_PROPERTY, Boolean.toString(value));
    }

    public static String getIdeConfPath() {
        return System.getProperty(IDE_CONF_PATH_PROPERTY);
    }

    public static void setIdeConfPath(String value) {
        System.setProperty(IDE_CONF_PATH_PROPERTY, value);
    }

    public static String getUserConfPath() {
        return System.getProperty(USER_CONF_PATH_PROPERTY);
    }

    public static void setUserConfPath(String value) {
        System.setProperty(USER_CONF_PATH_PROPERTY, value);
    }

    public static String getToolSpecificUserConfPath() {
        return System.getProperty(TOOL_USER_CONF_PATH_PROPERTY);
    }

    public static void setToolSpecificUserConfPath(String value) {
        System.setProperty(TOOL_USER_CONF_PATH_PROPERTY, value);
    }

    public static String getProductHome() {
        return System.getProperty(ORACLE_PRODUCT_HOME_PROPERTY);
    }

    public static String setProductHome(String value) {
        return System.setProperty(ORACLE_PRODUCT_HOME_PROPERTY, value);
    }

    public static String getOracleInstallTimestampLocation() {
        return System.getProperty(ORACLE_INSTALL_TIMESTAMP_LOCATION);
    }

    public static String getOracleInstallRescan() {
        return System.getProperty(ORACLE_INSTALL_RESCAN);
    }

    public static String getFCPHome() {
        return System.getProperty(ORACLE_FCP_HOME_PROPERTY);
    }

    public static String setFCPHome(String value) {
        return System.setProperty(ORACLE_FCP_HOME_PROPERTY, value);
    }

    public static String getJRFHome() {
        return System.getProperty(ORACLE_JRF_HOME_PROPERTY);
    }

    public static String setJRFHome(String value) {
        return System.setProperty(ORACLE_JRF_HOME_PROPERTY, value);
    }

    public static String getFMWRelativeHome() {
        return System.getProperty(ORACLE_FMW_DIR_PROPERTY);
    }

    public static String setFMWRelativeHome(String value) {
        return System.setProperty(ORACLE_FMW_DIR_PROPERTY, value);
    }

    public static String getOracleHome() {
        return System.getProperty(ORACLE_DOT_HOME_PROPERTY);
    }

    public static String setOracleHome(String value) {
        return System.setProperty(ORACLE_DOT_HOME_PROPERTY, value);
    }

    public static String getMiddlewareHome() {
        return System.getProperty(ORACLE_HOME_PROPERTY);
    }

    public static void setMiddlewareHome(String value) {
        System.setProperty(ORACLE_HOME_PROPERTY, value);
    }

    public static String getProductName() {
        return System.getProperty(IDE_PRODUCT_PROPERTY);
    }

    public static String getOsVersion() {
        return System.getProperty(OS_VERSION_PROPERTY);
    }

    public static String getUserHome() {
        return System.getProperty(USER_HOME_PROPERTY);
    }

    public static String getOsgiConfigurationArea() {
        return System.getProperty(OSGI_CONFIGURATION_AREA_PROPERTY);
    }

    public static void setOsgiConfigurationArea(String value) {
        System.setProperty(OSGI_CONFIGURATION_AREA_PROPERTY, value);
    }

    public static String getSimpleConfiguratorPath() {
        return System.getProperty(SIMPLE_CONFIGURATOR_PROPERTY);
    }

    public static void setSimpleConfiguratorPath(String value) {
        System.setProperty(SIMPLE_CONFIGURATOR_PROPERTY, value);
    }

    public static String getIdePrefDir() {
        return System.getProperty(IDE_PREF_DIR_PROPERTY);
    }

    public static void setIdePrefDir(String value) {
        System.setProperty(IDE_PREF_DIR_PROPERTY, value);
    }

    public static String getIdeWorkDir() {
        return System.getProperty(IDE_WORK_DIR_PROPERTY);
    }

    public static void setIdeWorkDir(String value) {
        System.setProperty(IDE_WORK_DIR_PROPERTY, value);
    }

    public static String getIdeUserDir() {
        return System.getProperty(IDE_USER_DIR_PROPERTY);
    }

    public static void setIdeUserDir(String value) {
        System.setProperty(IDE_USER_DIR_PROPERTY, value);
    }

    public static String getUserDir() {
        return System.getProperty(USER_DIR_PROPERTY);
    }

    public static String getUserDir(String defaultValue) {
        return System.getProperty(USER_DIR_PROPERTY, defaultValue);
    }

    public static void setUserDir(String value) {
        System.setProperty(USER_DIR_PROPERTY, value);
    }

    public static String getSystemDirectory() {
        return System.getProperty(SYSTEM_DIR_PROPERTY);
    }

    public static void setSystemDirectory(String value) {
        System.setProperty(SYSTEM_DIR_PROPERTY, value);
    }

    public static String getDiagnosticsDirectory() {
        return System.getProperty(DIAGNOSTICS_DIR_PROPERTY);
    }

    public static void setDiagnosticsDirectory(String value) {
        System.setProperty(DIAGNOSTICS_DIR_PROPERTY, value);
    }

    public static String getLoggingConfigClass() {
        return System.getProperty(LOGGING_CONFIG_CLASS_PROPERTY);
    }

    public static void setLoggingConfigClass(String value) {
        System.setProperty(LOGGING_CONFIG_CLASS_PROPERTY, value);
    }

    public static String getLoggingConfigFile() {
        return System.getProperty(LOGGING_CONFIG_FILE_PROPERTY);
    }

    public static void setLoggingConfigFile(String value) {
        System.setProperty(LOGGING_CONFIG_FILE_PROPERTY, value);
    }

    public static String getIdeLoggingConfigFile() {
        return System.getProperty(IDE_LOGGING_CONFIG_FILE_PROPERTY);
    }

    public static String getIdeLoggingProperties() {
        return System.getProperty(IDE_LOGGING_PROPERTIES_PROPERTY);
    }

    public static Boolean isIdeLoggingNondebug() {
        return Boolean.getBoolean(IDE_LOGGING_NONDEBUG_PROPERTY);
    }

    public static String getIdeSplashScreen() {
        return System.getProperty(IDE_SPLASH_SCREEN_PROPERTY);
    }

    public static String getHiddenFrameIcon() {
        return System.getProperty(HIDDEN_FRAME_ICON_PROPERTY);
    }

    public static boolean isSplashScreenRectangular() {
        return Boolean.parseBoolean(System.getProperty(IDE_RECTANGULAR_SPLASH_SCREEN_PROPERTY, "false"));
    }
}

