/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

class BundleDetails {
    private static final Logger LOG = Logger.getLogger(BundleDetails.class.getName());
    private String bundleSymbolicName;
    private String bundleVersion;
    private File bundleFile;

    BundleDetails() {
    }

    void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    String getBundleVersion() {
        return this.bundleVersion;
    }

    void setBundleFile(File bundleFile) {
        this.bundleFile = bundleFile;
    }

    File getBundleFile() {
        return this.bundleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BundleDetails getOsgiBundleDetails(File file) throws TaskFailedException {
        String fileName = file.getName().toLowerCase();
        if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) {
            return null;
        }
        ZipFile zipFile = null;
        BufferedReader reader = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (entry == null) {
                    BundleDetails bundleDetails = null;
                    return bundleDetails;
                }
                BundleDetails bundleDetails = new BundleDetails();
                bundleDetails.setBundleFile(file);
                reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("Bundle-SymbolicName:")) {
                        bundleDetails.setBundleSymbolicName(BundleDetails.getDetail(line));
                    } else if (line.startsWith("Bundle-Version:")) {
                        String version = BundleDetails.getDetail(line);
                        bundleDetails.setBundleVersion(version);
                    }
                    if (bundleDetails.getBundleSymbolicName() != null && bundleDetails.getBundleVersion() != null) {
                        BundleDetails bundleDetails2 = bundleDetails;
                        return bundleDetails2;
                    }
                    line = reader.readLine();
                }
                return null;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        catch (Exception ex) {
            String msg = UpdateArb.format("READ_FAILED", file.getPath());
            throw new TaskFailedException(msg);
        }
    }

    private static String getDetail(String line) {
        int index = line.indexOf(58);
        if (index >= 0 && index < line.length()) {
            return line.substring(index + 1).trim();
        }
        return null;
    }
}

