/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ideimpl.deferredupdate.AbstractProgressMonitor;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.CreateExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.DeinstallExtensionTask;
import oracle.ideimpl.deferredupdate.task.InstallExtensionTask;
import oracle.ideimpl.deferredupdate.task.ScheduleHookTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskProgress;
import oracle.ideimpl.deferredupdate.task.TaskStack;

public final class TaskList {
    private List<AtomicTask> tasks = new ArrayList<AtomicTask>();

    public TaskList(Map<String, List<String>> properties, TaskContext tc) {
        for (String taskName : properties.keySet()) {
            if (taskName.equals("DeinstallExtensionTask")) {
                this.createDeinstallExtensionTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals("InstallExtensionTask")) {
                this.createInstallExtensionTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals("ScheduleHookTask")) {
                this.createScheduleHookTasks(properties.get(taskName));
                continue;
            }
            if (!taskName.equals("UpdateExtraInfo")) continue;
            this.createExtraInfoTasks(properties.get(taskName));
        }
    }

    private void createDeinstallExtensionTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length != 2) continue;
            this.tasks.add(new DeinstallExtensionTask(pieces[0], pieces[1]));
        }
    }

    private void createExtraInfoTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            this.tasks.add(new CreateExtraInfoTask(task));
        }
    }

    private void createInstallExtensionTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length < 4) continue;
            ArrayList<String> updateIds = new ArrayList<String>();
            for (int x = 3; x < pieces.length; ++x) {
                updateIds.add(pieces[x]);
            }
            this.tasks.add(new InstallExtensionTask(pieces[0], pieces[1], pieces[2].equals("true"), updateIds));
        }
    }

    private void createScheduleHookTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length != 3) continue;
            this.tasks.add(new ScheduleHookTask(pieces[0], pieces[1], pieces[2]));
        }
    }

    public void executeAll(TaskContext tc, final AbstractProgressMonitor mon) throws TaskFailedException {
        tc.setProgress(new TaskProgress(){

            @Override
            public void setPercentProgress(double progress) {
                mon.setStepProgress(progress);
            }
        });
        mon.setMajorStepCount(this.tasks.size());
        TaskStack ts = new TaskStack();
        int step = 0;
        Iterator<AtomicTask> i = this.tasks.iterator();
        while (i.hasNext()) {
            try {
                mon.startStep(step);
                ts.performTask(i.next(), tc);
                mon.endStep(step);
            }
            catch (TaskFailedException tfe) {
                ts.rollbackTasks(tc);
                throw tfe;
            }
        }
        ts.commitTasks(tc);
    }
}

