/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

public class TaskUtil {
    public static final String BUNDLE_NAME = "bundle_name";
    public static final String EXTENSION_NAME = "extension_name";
    public static final String BACKED_UP_FILE = "backed_up_file";
    public static final String FILE_CREATED = "file_created";
    public static final String DIRECTORY_CREATED = "directory_created";
    public static final String ORIGINAL_FILE_NAME = "ORIGINAL:";
    public static final String BACKUP_FILE_NAME = "BACKUP:";

    private TaskUtil() {
    }

    public static File findBundlesHome(TaskContext tc) {
        File bundlesHome = new File(tc.getDirectories().getBundlesInfoHome());
        if (!bundlesHome.exists()) {
            bundlesHome.mkdirs();
        }
        return bundlesHome;
    }

    public static File findCFUBundlesInfoFile(TaskContext tc) {
        File file = TaskUtil.findBundlesFile(tc, "cfu_bundles.info");
        return file;
    }

    static File findCFUBundlesExtrasFile(TaskContext tc) {
        File file = TaskUtil.findBundlesFile(tc, "cfu_bundles.extras");
        return file;
    }

    public static File findBundlesFile(TaskContext tc, String fileName) {
        File bundlesHome = TaskUtil.findBundlesHome(tc);
        File file = new File(bundlesHome, fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<String>> readProperties(File updateFile) throws TaskFailedException {
        LinkedHashMap<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
        try {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(updateFile));
                while ((line = reader.readLine()) != null) {
                    int index = line.indexOf(61);
                    if (index <= 0) continue;
                    String propertyName = line.substring(0, index);
                    List<String> details = properties.get(propertyName);
                    if (details == null) {
                        details = new ArrayList<String>();
                        properties.put(propertyName, details);
                    }
                    details.add(line.substring(index + 1));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException io) {
            throw new TaskFailedException(UpdateArb.get("IO_EXCEPTION"), io);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(List<String> lines, File file) throws TaskFailedException {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(file));
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            String msg = UpdateArb.format("WRITE_FAILED", file.getPath());
            throw new TaskFailedException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(File file) throws TaskFailedException {
        Object line;
        block7: {
            BufferedReader reader = null;
            try {
                ArrayList<String> lines = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    lines.add((String)line);
                }
                line = lines;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    String msg = UpdateArb.format("READ_FAILED", file.getPath());
                    throw new TaskFailedException(msg, ex);
                }
            }
            reader.close();
        }
        return line;
    }
}

