/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.CloudProtocolException;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class RestConnErrorDialog
implements Runnable {
    private Throwable m_ex;
    private String m_msg;
    private String m_title;

    public static void displayMessage(String string, String string2) {
        RestConnErrorDialog.displayMessage(string, string2, null);
    }

    public static void displayMessage(String string, String string2, Throwable throwable) {
        RestConnErrorDialog restConnErrorDialog = new RestConnErrorDialog(string, string2, throwable);
        if (SwingUtilities.isEventDispatchThread()) {
            restConnErrorDialog.run();
        } else {
            try {
                SwingUtilities.invokeLater(restConnErrorDialog);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RestConnErrorDialog(String string, String string2, Throwable throwable) {
        this.m_title = string;
        this.m_msg = string2;
        if (throwable != null) {
            this.m_ex = throwable instanceof CConnectionException && throwable.getCause() != null ? throwable.getCause() : throwable;
        }
    }

    @Override
    public void run() {
        String string;
        Frame frame = IdeUtil.getMainWindow();
        if (this.m_ex != null) {
            if (this.m_ex instanceof AuthenticationFailedException) {
                CloudProtocolException cloudProtocolException = (CloudProtocolException)this.m_ex;
                Throwable throwable = cloudProtocolException.getCause();
                String string2 = "";
                if (throwable != null) {
                    string2 = throwable.getLocalizedMessage();
                } else {
                    string2 = cloudProtocolException.getAdditionalDetails();
                    if (RestUtils.emptyValue(string2)) {
                        string2 = cloudProtocolException.getLocalizedMessage();
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                string = this.m_msg != null ? this.m_msg.concat(System.getProperty("line.separator")).concat(string2) : string2;
                this.m_title = CloudBrowserResources.getString((String)"AUTHORIZATION_FAILURE_TITLE");
            } else {
                String string3 = this.m_ex.getLocalizedMessage() != null ? this.m_ex.getLocalizedMessage() : "";
                string = this.m_msg != null ? this.m_msg.concat(System.getProperty("line.separator")).concat(string3) : string3;
            }
        } else {
            string = this.m_msg;
        }
        MessageDialog.error((Component)frame, (Object)string, (String)this.m_title, null);
    }
}

