/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public abstract class RestXMLResponseHandler<V>
implements ResponseHandler<V> {
    private String _entityTag;
    private String _charsetName;

    public final V handleResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        if (n != 200) {
            throw new IOException((Throwable)new CConnectionException(statusLine.getReasonPhrase()));
        }
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header == null) {
            throw new IOException(RestArb.getString("MISSING_CONTENT_TYPE"));
        }
        ContentType contentType = ContentType.contentType((CharSequence)header.getValue());
        if (contentType == null || !contentType.matches(ContentTypes.XML_TYPES)) {
            throw new IOException(RestArb.getString("UNEXPECTED_CONTENT_TYPE") + contentType);
        }
        this._charsetName = contentType.parameter("charset");
        header = httpResponse.getFirstHeader("ETag");
        if (header != null) {
            this._entityTag = header.getValue();
        }
        HttpEntity httpEntity = null;
        InputStream inputStream = null;
        try {
            httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new IOException(RestArb.getString("ENTITY_ERROR"));
            }
            inputStream = httpEntity.getContent();
            V v = this.load(inputStream);
            return v;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
    }

    protected String getEntityTag() {
        return this._entityTag;
    }

    protected String getCharacterSetName() {
        return this._charsetName;
    }

    protected abstract V load(InputStream var1) throws IOException;
}

