/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.ui.RestResourceHandlerPanel;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;

public class RestDetailsPanel
extends JPanel {
    private RestResourceHandler _handler;
    private RestResourceHandlerPanel _handlerPanel;
    private HandlerDetailsView _view;
    private JPanel _mainPanel;
    private JPanel _examplePanel;
    private JLabel _uriModule;
    private JLabel _uriTemplate;
    private JLabel _uriExample1;

    public RestDetailsPanel(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
    }

    public void initialize(Toolbar toolbar, String string, String string2) {
        this._view = new HandlerDetailsView(toolbar);
        this.setLayout(new BorderLayout());
        this.add((Component)this._view.getToolbar(), "North");
        this._handlerPanel = new RestResourceHandlerPanel(this._handler);
        int n = 0;
        this._mainPanel = new JPanel(new GridBagLayout());
        if (this._handler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.POST || this._handler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.PUT) {
            this._mainPanel.add((Component)this._handlerPanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        } else {
            this._mainPanel.add((Component)this._handlerPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        }
        this.buildExamplePanel(string, string2, this._handlerPanel.getSecureAccessCheckBox().isSelected());
        if (this._examplePanel != null) {
            this._mainPanel.add((Component)this._examplePanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        }
        this._mainPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this._mainPanel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)jScrollPane, "Center");
        this._handlerPanel.getSecureAccessCheckBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = RestDetailsPanel.this._handlerPanel.getSecureAccessCheckBox().isSelected();
                if (RestDetailsPanel.this._uriExample1 != null && RestDetailsPanel.this._uriExample1.getText().startsWith("http:") && bl || RestDetailsPanel.this._uriExample1.getText().startsWith("https:") && !bl) {
                    RestDetailsPanel.this.buildURIExample(RestDetailsPanel.this._uriModule.getText(), RestDetailsPanel.this._uriTemplate.getText(), bl);
                }
            }
        });
    }

    private void buildExamplePanel(String string, String string2, boolean bl) {
        if (RestUtils.emptyValue(string) && RestUtils.emptyValue(string2)) {
            this._examplePanel = null;
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this._uriModule = new JLabel(RestUtils.emptyValue(string) ? "" : string);
        this._uriTemplate = new JLabel(string2);
        this.buildURIExample(string, string2);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._uriModule, (String)RestArb.getString("URI_MODULE"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._uriTemplate, (String)StringUtils.stripMnemonic((String)RestArb.getString("URI_TEMPLATE")));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._uriModule, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._uriTemplate, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._uriExample1, new GridBagConstraints(0, n, 1, 1, 0.5, 1.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        n = 0;
        this._examplePanel = new JPanel(new GridBagLayout());
        this._examplePanel.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._examplePanel.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._examplePanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)this._examplePanel, (String)RestArb.getString("URI_EXAMPLES"));
    }

    private void buildURIExample(String string, String string2) {
        if (this._handlerPanel != null) {
            this.buildURIExample(string, string2, this._handlerPanel.getSecureAccessCheckBox().isSelected());
        } else {
            this.buildURIExample(string, string2, true);
        }
    }

    private void buildURIExample(String string, String string2, boolean bl) {
        String string3 = string == null ? "" : string;
        String string4 = string2 == null ? "" : string2;
        String string5 = "";
        if (!RestUtils.emptyValue(string3)) {
            string5 = string3;
        }
        if (!RestUtils.emptyValue(string4)) {
            string5 = string3.endsWith("/") || string4.startsWith("/") ? string5 + string4 : string5 + "/" + string4;
        }
        if (this._uriExample1 == null) {
            this._uriExample1 = new JLabel();
        }
        URI uRI = RestUtils.getBaseURI();
        String string6 = "";
        if (uRI != null) {
            string6 = uRI.toString();
            String string7 = uRI.getScheme();
            if (!RestUtils.emptyValue(string7)) {
                if (string7.equalsIgnoreCase("http") && bl) {
                    string6 = string6.replace("http", "https");
                } else if (string7.equalsIgnoreCase("https") && !bl) {
                    string6 = string6.replace("https", "http");
                }
            }
            if (string5.startsWith("/") && string6.endsWith("/")) {
                string6 = string6.substring(0, string6.length() - 1);
            }
            string6 = string6 + string5;
        } else {
            string6 = bl ? RestArb.getString("HTTPS_EXAMPLE_HOST_PORT") : RestArb.getString("HTTPS_EXAMPLE_HOST_PORT");
            string6 = string5.startsWith("/") ? string6 + string5 : string6 + "/" + string5;
        }
        this._uriExample1.setText(string6);
    }

    public RestResourceHandler getResourceHandler() {
        if (this._handlerPanel != null) {
            return this._handlerPanel.getValues();
        }
        return null;
    }

    public boolean refresh(RestResourceHandler restResourceHandler, String string, String string2) {
        if (restResourceHandler.getMethodType() == this._handlerPanel.getMethodType()) {
            this._handlerPanel.updateValues(restResourceHandler);
            this._handlerPanel.revalidate();
            this._handlerPanel.repaint();
            this.refreshURIExamples(string, string2, true);
        } else {
            this._mainPanel.remove(this._handlerPanel);
            this._handlerPanel = new RestResourceHandlerPanel(restResourceHandler);
            this._mainPanel.add((Component)this._handlerPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.refreshURIExamples(string, string2, false);
            this._mainPanel.validate();
            this._mainPanel.repaint();
        }
        return true;
    }

    public void refreshURIExamples(String string, String string2, boolean bl) {
        String string3;
        String string4 = RestUtils.emptyValue(string) ? "" : string;
        String string5 = string3 = RestUtils.emptyValue(string2) ? "" : string2;
        if (!string4.equals(this._uriModule.getText()) || !string3.equals(this._uriTemplate.getText())) {
            if (!string4.equals(this._uriModule.getText())) {
                this._uriModule.setText(string4);
            }
            if (!string3.equals(this._uriTemplate.getText())) {
                this._uriTemplate.setText(string3);
            }
            this.buildURIExample(string4, string3);
            if (bl) {
                this._examplePanel.validate();
                this._examplePanel.repaint();
            }
        }
    }

    private class HandlerDetailsView
    extends View {
        private Toolbar _toolbar;

        protected HandlerDetailsView(Toolbar toolbar) {
            this._toolbar = toolbar;
            RestDetailsPanel.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    View.updateToolbarActions((Toolbar)HandlerDetailsView.this.getToolbar());
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    View.updateToolbarActions((Toolbar)HandlerDetailsView.this.getToolbar());
                }
            });
            View.updateToolbarActions((Toolbar)this.getToolbar());
        }

        public Component getGUI() {
            return RestDetailsPanel.this;
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }
    }
}

