/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.rest.editor.RestEditor;
import oracle.dbtools.rest.editor.RestHandlerEditorPanel;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.navigator.RestHandlerEditorNode;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;

public class RestHandlerEditor
extends RestEditor {
    private RestHandlerEditorPanel _gui = null;

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_resthandlereditor_html");
    }

    public Component getGUI() {
        return this.getRESTfulHandlerGUI();
    }

    private RestHandlerEditorPanel getRESTfulHandlerGUI() {
        if (this._gui == null) {
            this._gui = this.initializeGUI();
        }
        return this._gui;
    }

    private RestHandlerEditorPanel initializeGUI() {
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        RestResourceHandler restResourceHandler = restHandlerNode.getUserObject();
        RestHandlerEditorPanel restHandlerEditorPanel = new RestHandlerEditorPanel(restResourceHandler);
        ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>();
        arrayList.add(this.getPinAction());
        List<String> list = RestUtils.getTemplateParameters(restHandlerNode.getTemplateURI());
        restHandlerEditorPanel.initPanel(arrayList, list, restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI());
        return restHandlerEditorPanel;
    }

    public RestResourceHandler getResourceHandler() {
        return this._gui.getResourceHandler();
    }

    public int getNodeId() {
        RestHandlerEditorNode restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode();
        return restHandlerEditorNode != null ? restHandlerEditorNode.getHandlerNode().getNodeId() : 0;
    }

    public boolean refresh() {
        RestHandlerNode restHandlerNode;
        boolean bl = false;
        RestHandlerEditorNode restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode();
        if (restHandlerEditorNode != null && (restHandlerNode = restHandlerEditorNode.getHandlerNode()) != null) {
            bl = this._gui.refresh(restHandlerNode);
        }
        return bl;
    }

    public void saveResourceHandler() {
        RestHandlerNode restHandlerNode = ((RestHandlerEditorNode)this.getContext().getNode()).getHandlerNode();
        restHandlerNode.setUserObject(this._gui.getResourceHandler());
    }

    public void close() {
        this.saveResourceHandler();
        super.close();
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        RestHandlerNode restHandlerNode;
        RestHandlerEditorNode restHandlerEditorNode;
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED && (restHandlerEditorNode = (RestHandlerEditorNode)this.getContext().getNode()) != null && (restHandlerNode = restHandlerEditorNode.getHandlerNode()) != null) {
            this._gui.refreshURI(restHandlerNode);
        }
    }

    public Controller getController() {
        if (this.getRESTfulHandlerGUI().isRESTWorksheetTab()) {
            return this.getRESTfulHandlerGUI().getRESTWorksheet().getController();
        }
        return super.getController();
    }
}

