/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.editor.RestDetailsPanel;
import oracle.dbtools.rest.editor.RestEditor;
import oracle.dbtools.rest.editor.RestParametersPanel;
import oracle.dbtools.rest.editor.RestWorkSheet;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;

public class RestHandlerEditorPanel
extends JPanel {
    private CustomTabbedPane _tabbed;
    private RestWorkSheet _worksheet;
    private RestParametersPanel _parameters;
    private RestDetailsPanel _details;
    private RestResourceHandler _handler;

    public RestHandlerEditorPanel(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
    }

    public void initPanel(ArrayList<IdeAction> arrayList, List<String> list, String string, String string2) {
        this._worksheet = new RestWorkSheet(arrayList, this._handler.getSQL(), list);
        this._parameters = new RestParametersPanel(this._handler);
        this._details = new RestDetailsPanel(this._handler);
        this._parameters.initialize(this.createToolbar(arrayList));
        this._details.initialize(this.createToolbar(arrayList), string, string2);
        this._tabbed = new CustomTabbedPane();
        this._tabbed.addTab(null, RestArb.getString("WORKSHEET"), this._worksheet.getGUI());
        this._tabbed.addTab(null, RestArb.getString("PARAMETERS"), (Component)this._parameters);
        this._tabbed.addTab(null, RestArb.getString("DETAILS"), (Component)this._details);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbed, "Center");
    }

    private Toolbar createToolbar(ArrayList<IdeAction> arrayList) {
        Toolbar toolbar = null;
        if (arrayList != null) {
            toolbar = new Toolbar();
            for (IdeAction ideAction : arrayList) {
                if (ideAction.getCommandId() == RestEditor.PIN_EDITOR_CMD_ID) {
                    toolbar.add((Component)new ToggleToolButton((ToggleAction)ideAction));
                    continue;
                }
                toolbar.add((ToggleAction)ideAction);
            }
        }
        return toolbar;
    }

    public RestResourceHandler getResourceHandler() {
        this._handler = this._details.getResourceHandler();
        String string = this._worksheet.getText();
        if (string != null) {
            string = string.trim();
            if (this._handler.getSourceType() != null && this._handler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL && string.endsWith(";") && this._handler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL) {
                string = string.substring(0, string.length() - 1);
            }
        }
        this._handler.setSQL(string);
        if (this._worksheet.getConnectionName() != null) {
            this._handler.setConnectionName(this._worksheet.getConnectionName());
        }
        this._handler.setParameters(this._parameters.getParameters());
        return this._handler;
    }

    public boolean refresh(RestHandlerNode restHandlerNode) {
        if (restHandlerNode == null) {
            return false;
        }
        this._handler = restHandlerNode.getHandler();
        this._worksheet.setText(this._handler.getSQL());
        this._worksheet.updateBindVariables(RestUtils.getTemplateParameters(restHandlerNode.getTemplateURI()));
        this._parameters.refresh(this._handler);
        this._details.refresh(this._handler, restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI());
        return true;
    }

    public void refreshURI(RestHandlerNode restHandlerNode) {
        if (restHandlerNode == null) {
            return;
        }
        this._worksheet.updateBindVariables(RestUtils.getTemplateParameters(restHandlerNode.getTemplateURI()));
        this._details.refreshURIExamples(restHandlerNode.getModuleURI(), restHandlerNode.getTemplateURI(), true);
    }

    public boolean isRESTWorksheetTab() {
        return this._tabbed.getSelectedIndex() == 0;
    }

    public RestWorkSheet getRESTWorksheet() {
        return this._worksheet;
    }
}

