/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.model;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestHandlerParameter;

public class RestResourceHandler {
    public static final String GENERATOR_QUERY_JSON = "json/query";
    public static final String GENERATOR_QUERY_CSV = "csv/query";
    public static final String GENERATOR_QUERY_ONE_ROW = "json/query;type=single";
    public static final String GENERATOR_FEED = "json/query;type=feed";
    public static final String GENERATOR_MEDIA = "resource/lob";
    public static final String GENERATOR_PLSQL = "plsql/block";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    public static final String METHOD_PUT = "put";
    public static final String METHOD_DELETE = "delete";
    public static final String FORMAT_JSON = "JSON";
    public static final String FORMAT_CSV = "CSV";
    private HTTP_METHOD_TYPE _httpMethodType;
    private String _sql;
    private SOURCE_TYPE _sourceType;
    private FORMAT_TYPE _formatType;
    private boolean _securedAccess;
    private long _paginationSize;
    private List<String> _mimeTypes;
    private String _qualifiedConnName;
    private List<RestHandlerParameter> _parameters;

    public HTTP_METHOD_TYPE getMethodType() {
        return this._httpMethodType;
    }

    public void setMethodType(HTTP_METHOD_TYPE hTTP_METHOD_TYPE) {
        this._httpMethodType = hTTP_METHOD_TYPE;
    }

    public String getSQL() {
        return this._sql;
    }

    public void setSQL(String string) {
        this._sql = string;
    }

    public SOURCE_TYPE getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(SOURCE_TYPE sOURCE_TYPE) {
        this._sourceType = sOURCE_TYPE;
    }

    public FORMAT_TYPE getFormatType() {
        return this._formatType;
    }

    public void setFormatType(FORMAT_TYPE fORMAT_TYPE) {
        this._formatType = fORMAT_TYPE;
    }

    public boolean isSecuredAccess() {
        return this._securedAccess;
    }

    public void setSecuredAccess(boolean bl) {
        this._securedAccess = bl;
    }

    public long getPaginationSize() {
        return this._paginationSize;
    }

    public void setPaginationSize(long l) {
        this._paginationSize = l;
    }

    public List<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(List<String> list) {
        this._mimeTypes = list;
    }

    public String getConnectionName() {
        return this._qualifiedConnName;
    }

    public void setConnectionName(String string) {
        this._qualifiedConnName = string;
    }

    public List<RestHandlerParameter> getParameters() {
        return this._parameters;
    }

    public void setParameters(List<RestHandlerParameter> list) {
        this._parameters = list;
    }

    public void addParameter(RestHandlerParameter restHandlerParameter) {
        if (this._parameters == null) {
            this._parameters = new ArrayList<RestHandlerParameter>();
        }
        this._parameters.add(restHandlerParameter);
    }

    public String getGeneratorType() {
        if (this._httpMethodType != null) {
            if (this._httpMethodType == HTTP_METHOD_TYPE.GET) {
                if (this._sourceType != null) {
                    if (this._sourceType == SOURCE_TYPE.QUERY && this._formatType == FORMAT_TYPE.CSV) {
                        return GENERATOR_QUERY_CSV;
                    }
                    return this._sourceType.getGenerator();
                }
            } else {
                return GENERATOR_PLSQL;
            }
        }
        return GENERATOR_QUERY_JSON;
    }

    public static enum FORMAT_TYPE {
        JSON("JSON", RestArb.getString("FORMAT_JSON")),
        CSV("CSV", RestArb.getString("FORMAT_CSV"));

        private String type;
        private String nlsName;

        private FORMAT_TYPE(String string2, String string3) {
            this.type = string2;
            this.nlsName = string3;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum HTTP_METHOD_TYPE {
        GET("get", RestArb.getString("LABEL_GET")),
        POST("post", RestArb.getString("LABEL_POST")),
        PUT("put", RestArb.getString("LABEL_PUT")),
        DELETE("delete", RestArb.getString("LABEL_DELETE"));

        private String type;
        private String nlsName;

        private HTTP_METHOD_TYPE(String string2, String string3) {
            this.type = string2;
            this.nlsName = string3;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum SOURCE_TYPE {
        QUERY("json/query", RestArb.getString("SOURCE_QUERY")),
        QUERY_ONE_ROW("json/query;type=single", RestArb.getString("SOURCE_QUERY_ONE_ROW")),
        FEED("json/query;type=feed", RestArb.getString("SOURCE_FEED")),
        PLSQL("plsql/block", RestArb.getString("SOURCE_PLSQL")),
        MEDIA_RESOURCE("resource/lob", RestArb.getString("SOURCE_MEDIA"));

        private String generator;
        private String nlsName;

        private SOURCE_TYPE(String string2, String string3) {
            this.generator = string2;
            this.nlsName = string3;
        }

        public String getGenerator() {
            return this.generator;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }
}

