/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONValue;

public class RestJSONUtil {
    private static final String INDENT = "  ";
    private StringBuilder _buf;

    public static String restPrivilegestoJSON(List<RestSecurity> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return new RestJSONUtil().privilegestoJSON(list);
    }

    public static String restPrivilegetoJSON(RestSecurity restSecurity) {
        if (restSecurity == null) {
            return null;
        }
        return new RestJSONUtil().privilegetoJSON(restSecurity);
    }

    public static List<RestSecurity> getPrivileges(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return new RestJSONUtil().createPrivileges(jSONObject);
    }

    public static RestSecurity getPrivilege(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return new RestJSONUtil().getPrivilegeDetails(jSONObject);
    }

    private String privilegestoJSON(List<RestSecurity> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"items\":[\n");
        for (int i = 0; i < list.size(); ++i) {
            RestSecurity restSecurity = list.get(i);
            String string = RestJSONUtil.restPrivilegetoJSON(restSecurity);
            if (string == null) continue;
            stringBuilder.append(RestJSONUtil.restPrivilegetoJSON(restSecurity));
            if (i < list.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private String privilegetoJSON(RestSecurity restSecurity) {
        String string;
        Object object;
        Object object2;
        this._buf = new StringBuilder(INDENT);
        this._buf.append("{");
        this._buf.append("\"name\":").append("\"").append(restSecurity.getName()).append("\"");
        this._buf.append(",");
        this._buf.append("\"title\":").append("\"").append(restSecurity.getTitle()).append("\"");
        String string2 = restSecurity.getDescription();
        if (!RestUtils.emptyValue(string2)) {
            this._buf.append(",");
            object2 = "\\\"";
            string2 = string2.replace("\"", (CharSequence)object2);
            this._buf.append("\"description\":").append("\"").append(string2).append("\"");
        }
        if ((object2 = restSecurity.getRoles()) != null && !object2.isEmpty() && !RestUtils.emptyValue((String)(object = this.formatCommaDelimitedDoubleQuotedList(restSecurity.getRoles())))) {
            this._buf.append(",");
            this._buf.append("\"roles\":");
            this._buf.append("[").append((String)object).append("]");
        }
        if ((object = restSecurity.getModules()) != null && !object.isEmpty() && !RestUtils.emptyValue(string = this.formatCommaDelimitedDoubleQuotedList(restSecurity.getModules()))) {
            this._buf.append(",");
            this._buf.append("\"modules\":");
            this._buf.append("[").append(string).append("]");
        }
        this._buf.append("}");
        return this._buf.toString();
    }

    private String formatCommaDelimitedDoubleQuotedList(List<String> list) {
        String string = "";
        if (list != null && !list.isEmpty()) {
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                string2 = list.get(i);
                if (RestUtils.emptyValue(string2)) continue;
                string2 = "\"" + string2 + "\"";
                string = string + string2;
                if (i >= list.size() - 1) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public List<RestSecurity> createPrivileges(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ArrayList<RestSecurity> arrayList = new ArrayList<RestSecurity>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (JSONValue jSONValue : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)jSONValue.value();
            arrayList.add(this.getPrivilegeDetails(jSONObject2));
        }
        return arrayList;
    }

    private RestSecurity getPrivilegeDetails(JSONObject jSONObject) {
        JSONArray jSONArray;
        if (jSONObject == null) {
            return null;
        }
        RestSecurity restSecurity = new RestSecurity();
        restSecurity.setName((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"name"));
        restSecurity.setTitle((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"title"));
        restSecurity.setDescription((String)JSONUtils.getValue((JSONObject)jSONObject, (String)"description"));
        JSONArray jSONArray2 = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"modules");
        if (jSONArray2 != null) {
            jSONArray = new ArrayList();
            for (Object object : jSONArray2.values()) {
                jSONArray.add((String)object.value());
            }
            restSecurity.setModules((List<String>)jSONArray);
        }
        if ((jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"roles")) != null) {
            ArrayList arrayList = new ArrayList();
            for (JSONValue jSONValue : jSONArray.values()) {
                arrayList.add((String)jSONValue.value());
            }
            restSecurity.setRoles(arrayList);
        }
        return restSecurity;
    }
}

