/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class RestWizSummaryPanel
extends DefaultTraversablePanel {
    private JTree _summary = new JTree();

    public RestWizSummaryPanel() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this._summary.setCellRenderer(new NodeRenderer());
        jScrollPane.setViewportView(this._summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(10, 8, 0, 0), 0, 0));
    }

    private void buildSummaryTree(TraversableContext traversableContext) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        this._summary.removeAll();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_ROOT"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = this.getModuleSummaryNode(traversableContext);
        if (defaultMutableTreeNode4 != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        if ((defaultMutableTreeNode2 = this.getTemplateSummaryNode(traversableContext)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if ((defaultMutableTreeNode = this.getHandlerSummaryNode(traversableContext)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
        }
        this._summary.setModel(new DefaultTreeModel(defaultMutableTreeNode3));
        if (defaultMutableTreeNode4 != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
        }
        if (defaultMutableTreeNode2 != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        if (defaultMutableTreeNode != null) {
            this._summary.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private DefaultMutableTreeNode getModuleSummaryNode(TraversableContext traversableContext) {
        RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
        if (restModule == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_MODULE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("MODULE_NAME")), restModule.getName())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PREFIX")), restModule.getURIPrefix())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("PUBLISH")), restModule.isPublished())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restModule.getPaginationSize()))));
        List<String> list = restModule.getOrigins();
        if (list != null && !list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("ORIGINS_ALLOWED"));
            for (String string : restModule.getOrigins()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(RestArb.getString("WIZ_ORIGINS_NONE")));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getTemplateSummaryNode(TraversableContext traversableContext) {
        RestTemplate restTemplate = (RestTemplate)traversableContext.get("REST_TEMPLATE");
        if (restTemplate == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_TEMPLATE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PREFIX")), restTemplate.getURIPrefix())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PRIORITY")), Long.toString(restTemplate.getPriority()))));
        if (restTemplate.getEntityTag() == RestTemplate.ENTITY_TAG_TYPE.QUERY) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS()));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(restTemplate.getEntityTagQuery())));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS())));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getHandlerSummaryNode(TraversableContext traversableContext) {
        RestResourceHandler restResourceHandler = (RestResourceHandler)traversableContext.get("REST_HANDLER");
        if (restResourceHandler == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_RESOURCE_HANDLER"));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("GET_NODE"))));
                break;
            }
            case POST: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("POST_NODE"))));
                break;
            }
            case PUT: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("PUT_NODE"))));
                break;
            }
            case DELETE: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("DELETE_NODE"))));
            }
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("SECURE_ACCESS")), restResourceHandler.isSecuredAccess())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("SOURCE_TYPE")), restResourceHandler.getSourceType().getNLS())));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                String string = null;
                string = restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.MEDIA_RESOURCE ? RestArb.getString("FORMAT_BINARY") : restResourceHandler.getFormatType().getNLS();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("DATA_FORMAT")), string)));
                if (restResourceHandler.getSourceType() == null || restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) break;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restResourceHandler.getPaginationSize()))));
                break;
            }
            case POST: 
            case PUT: {
                List<String> list = restResourceHandler.getMimeTypes();
                if (list == null || list.isEmpty()) break;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("MIME_TYPES"));
                for (String string : list) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        return defaultMutableTreeNode;
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public JLabel getLabel(String string) {
        JLabel jLabel = new JLabel();
        String string2 = string != null ? string : "";
        jLabel.setText(string2);
        return jLabel;
    }

    private String format(String string, String string2) {
        return string + " " + string2;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.buildSummaryTree(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
            RestTemplate restTemplate = (RestTemplate)traversableContext.get("REST_TEMPLATE");
            RestResourceHandler restResourceHandler = (RestResourceHandler)traversableContext.get("REST_HANDLER");
            if (restModule != null && restTemplate != null) {
                restModule.addTemplate(restTemplate);
            }
            if (restTemplate != null && restResourceHandler != null) {
                restTemplate.addResourceHandler(restResourceHandler.getMethodType(), restResourceHandler);
            }
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

