/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.wizard.RestWizHandlerPanel;
import oracle.dbtools.rest.wizard.RestWizModulePanel;
import oracle.dbtools.rest.wizard.RestWizSummaryPanel;
import oracle.dbtools.rest.wizard.RestWizTemplatePanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class RestWizard {
    public static final String TRANSITION_TEMPLATE = "Transition.Template";
    public static final String STATE_TEMPLATE = "State.Template";
    public static final String TRANSITION_HANDLER = "Transition.Handler";
    public static final String STATE_HANDLER = "State.Handler";
    public static final String TRANSITION_FINISH = "Transition.Finish";
    public static final String STATE_FINISH = "State.Finish";
    public static final String KEY_REST_MODULE = "REST_MODULE";
    public static final String KEY_REST_TEMPLATE = "REST_TEMPLATE";
    public static final String KEY_REST_HANDLER = "REST_HANDLER";
    public static final String KEY_MODULE_URI = "REST_MODULE_URI";
    public static final String KEY_EXISTING_NAMES = "REST_EXISTING_NAMES";
    public static final String KEY_EXISTING_URIS = "REST_EXISTING_URIS";
    public static final String KEY_MODULE_PAGINATION = "REST_MODULE_PAGINATION";
    private static RestWizard INSTANCE;

    public static RestWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestWizard();
        }
        return INSTANCE;
    }

    public RestModule launchCreateRESTfulModule(List<String> list) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_REST_MODULE, (Object)new RestModule());
        namespace.put(KEY_EXISTING_NAMES, list);
        FSM fSM = RestWizard.getFSMforRESTfulModule();
        boolean bl = this.launchWizard(fSM, namespace);
        if (bl) {
            return (RestModule)namespace.get(KEY_REST_MODULE);
        }
        return null;
    }

    public RestTemplate launchCreateRESTfulTemplate(List<String> list, String string, long l) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_REST_TEMPLATE, (Object)new RestTemplate());
        namespace.put(KEY_EXISTING_URIS, list);
        namespace.put(KEY_MODULE_URI, (Object)string);
        namespace.put(KEY_MODULE_PAGINATION, (Object)new Long(l));
        FSM fSM = RestWizard.getFSMforRESTfulTemplate();
        boolean bl = this.launchWizard(fSM, namespace);
        if (bl) {
            return (RestTemplate)namespace.get(KEY_REST_TEMPLATE);
        }
        return null;
    }

    public boolean launchWizard(FSM fSM, Namespace namespace) {
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(RestArb.getString("WIZ_TITLE"));
        fSMWizard.setLogoImage(RestArb.getImage("WIZ_LOGO_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        boolean bl = WizardLauncher.runDialog((JDialog)fSMWizard.getDialog((Frame)Ide.getMainWindow()));
        return bl;
    }

    private static FSM getFSMforRESTfulModule() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_MODULE"), RestWizModulePanel.class, "f1_rest_module_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_TEMPLATE, (Object)STATE_TEMPLATE);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newState((Object)STATE_TEMPLATE, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_REST_HANDLER"), RestWizHandlerPanel.class, "f1_rest_handler_html");
        fSMBuilder.newState((Object)STATE_HANDLER, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step4 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforRESTfulTemplate() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(RestArb.getString("WIZ_STEP_REST_TEMPLATE"), RestWizTemplatePanel.class, "f1_rest_template_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_HANDLER, (Object)STATE_HANDLER);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step2 = new Step(RestArb.getString("WIZ_STEP_REST_HANDLER"), RestWizHandlerPanel.class, "f1_rest_handler_html");
        fSMBuilder.newState((Object)STATE_HANDLER, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FINISH, (Object)STATE_FINISH);
        Step step3 = new Step(RestArb.getString("WIZ_STEP_SUMMARY"), RestWizSummaryPanel.class, "f1_rest_summary_html");
        fSMBuilder.newFinalState((Object)STATE_FINISH, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }
}

