/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.dynamicconfig;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.dynamicconfig.BundleLocator;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class DynamicConfigFS
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Info,
InvocationHandler,
AbstractFileSystem.Attr {
    static final Logger LOG = Logger.getLogger("com.oracle.jdeveloper.nbbridge");
    private transient Date date = new Date();
    private transient Properties props;

    public DynamicConfigFS() {
        this.info = this;
        this.list = this;
        this.attr = this;
        String bootDelegation = System.getProperty("org.osgi.framework.bootdelegation");
        if (bootDelegation == null) {
            System.setProperty("org.osgi.framework.bootdelegation", "org.xml.sax,com.sun.jdi,org.w3c.dom,javax.xml.xpath,javax.xml.namespace");
        }
        LOG.log(Level.FINE, "OSGi Boot delegation: {0}", System.getProperty("org.osgi.framework.bootdelegation"));
        LOG.log(Level.FINE, "OSGi Parent ClassLoader: {0}", System.getProperty("osgi.parentClassloader"));
        LOG.log(Level.FINE, "NetBeans Boot delegation: {0}", System.getProperty("netbeans.bootdelegation"));
    }

    public String getDisplayName() {
        return "DynamicModules";
    }

    public boolean isReadOnly() {
        return true;
    }

    public String[] children(String path) {
        if ("".equals(path)) {
            return new String[]{"Modules"};
        }
        if ("Modules".equals(path)) {
            this.initialize();
            ArrayList<String> arr = new ArrayList<String>();
            for (String p : this.props.stringPropertyNames()) {
                if (p.startsWith("enabled.") || p.startsWith("cnb.")) continue;
                arr.add(p + ".xml");
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "  Faking Modules/{0}.xml", p);
            }
            String disable = System.getProperty("jdev.disable.modules");
            if (disable != null) {
                for (String d : disable.split(",")) {
                    String file = d.replace('.', '-') + ".xml_hidden";
                    arr.add(file);
                    LOG.log(Level.INFO, "Disabling module by generating {0}", file);
                }
            }
            return arr.toArray(new String[0]);
        }
        return null;
    }

    public Date lastModified(String string) {
        return this.date;
    }

    public boolean folder(String path) {
        return path.equals("") || path.equals("Modules");
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return "text/xml";
    }

    public long size(String path) {
        return this.generate(path).length();
    }

    public InputStream inputStream(String path) throws FileNotFoundException {
        if (path.endsWith("_hidden")) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            String v = this.generate(path);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Serving content of {0}:\n{1}", new Object[]{path, v});
            }
            return new ByteArrayInputStream(v.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
        throw new IOException();
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    public Object readAttribute(String path, String attr) {
        if (path.equals("") && attr.equals("fallback")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void writeAttribute(String string, String string1, Object o) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String attr) {
        if (attr.equals("")) {
            return Enumerations.singleton((Object)"fallback");
        }
        return Enumerations.empty();
    }

    public void renameAttributes(String string, String string1) {
    }

    public void deleteAttributes(String string) {
    }

    private void initialize() {
        if (this.props != null) {
            return;
        }
        Properties p = new Properties();
        InputStream is = DynamicConfigFS.cache();
        if (is != null) {
            try {
                p.load(is);
                is.close();
                this.props = p;
                return;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        BundleLocator.Response r = new BundleLocator.Response(p);
        Iterator i$ = Lookup.getDefault().lookupAll(BundleLocator.class).iterator();
        if (i$.hasNext()) {
            BundleLocator bl = (BundleLocator)i$.next();
            bl.search(r);
        }
        this.props = p;
        this.requestSave();
    }

    private String generate(String path) {
        if (!path.endsWith(".xml")) {
            LOG.log(Level.FINE, "no content for {0}", path);
            return "";
        }
        if (!path.startsWith("Modules/")) {
            LOG.log(Level.FINE, "no content for {0}", path);
            return "";
        }
        String name = path.substring(8, path.length() - 4);
        String cnb = name.replace('-', '.');
        String loc = this.props.getProperty(name);
        if (loc == null) {
            LOG.log(Level.FINE, "no location specified for {0}", path);
            return "";
        }
        if ("true".equals(this.props.get("enabled." + name))) {
            LOG.log(Level.FINE, "generating enabled module {0}", path);
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + cnb + "\">\n" + "    <param name=\"autoload\">false</param>\n" + "    <param name=\"eager\">false</param>\n" + "    <param name=\"enabled\">true</param>\n" + "    <param name=\"jar\">" + loc + "</param>\n" + "    <param name=\"reloadable\">false</param>\n" + "</module>\n";
        }
        LOG.log(Level.FINE, "generating autoloadmodule {0}", path);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + cnb + "\">\n" + "    <param name=\"autoload\">true</param>\n" + "    <param name=\"eager\">false</param>\n" + "    <param name=\"jar\">" + loc + "</param>\n" + "    <param name=\"reloadable\">false</param>\n" + "</module>\n";
    }

    private void storeProperties(OutputStream outputStream) throws IOException {
        this.props.store(outputStream, "");
    }

    private static InputStream cache() {
        try {
            Class<?> c = Class.forName("org.netbeans.Stamps");
            Object stamps = c.getMethod("getModulesJARs", new Class[0]).invoke(null, new Object[0]);
            return (InputStream)c.getMethod("asStream", String.class).invoke(stamps, "jdev-module-configs");
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void requestSave() {
        try {
            Class<?> c = Class.forName("org.netbeans.Stamps");
            Object stamps = c.getMethod("getModulesJARs", new Class[0]).invoke(null, new Object[0]);
            Class<?> i = Class.forName("org.netbeans.Stamps$Updater");
            Object proxy = Proxy.newProxyInstance(i.getClassLoader(), new Class[]{i}, (InvocationHandler)this);
            c.getMethod("scheduleSave", i, String.class, Boolean.TYPE).invoke(stamps, proxy, "jdev-module-configs", false);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (method.getName().equals("cacheReady")) {
            return null;
        }
        assert (method.getName().equals("flushCaches")) : method.getName();
        this.storeProperties((OutputStream)args[0]);
        return null;
    }
}

