/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.commands.TTExplainPlanNode;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TTAutotraceTreeModel
extends AutotraceTreeModel {
    private Connection theConnection;
    private String theCurrentSql;

    public TTAutotraceTreeModel(AutotracePanel autotracePanel) {
        super(autotracePanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explainPlan(String string, String string2, Connection connection) {
        boolean bl = false;
        boolean bl2 = false;
        Statement statement = null;
        Statement statement2 = null;
        this.theCurrentSql = string;
        this.originalSQL = string;
        try {
            bl = connection.getAutoCommit();
            if (bl) {
                connection.setAutoCommit(false);
                bl2 = true;
            }
            statement = connection.createStatement();
            statement.execute("call ttOptSetflag('GenPlan', 1)");
            statement2 = connection.prepareStatement(string);
            ResultSet resultSet = statement.executeQuery("select * from sys.plan order by step");
            TTExplainPlanNode tTExplainPlanNode = null;
            int n = -1;
            Stack<TTExplainPlanNode> stack = new Stack<TTExplainPlanNode>();
            while (resultSet.next()) {
                tTExplainPlanNode = new TTExplainPlanNode(resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7));
                if (n == -1) {
                    n = resultSet.getInt(2);
                    stack.push(tTExplainPlanNode);
                    continue;
                }
                if (n == resultSet.getInt(2)) {
                    stack.push(tTExplainPlanNode);
                    continue;
                }
                while (!stack.empty()) {
                    TTExplainPlanNode tTExplainPlanNode2 = (TTExplainPlanNode)((Object)stack.pop());
                    tTExplainPlanNode2.setTheParent(tTExplainPlanNode);
                    tTExplainPlanNode.add((MutableTreeNode)((Object)tTExplainPlanNode2));
                }
                n = resultSet.getInt(2);
                stack.push(tTExplainPlanNode);
            }
            this.root = tTExplainPlanNode;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            String string3 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)Messages.getString("TTAutotraceTreeModel.failedToExplainPlan"), null);
        }
        finally {
            try {
                if (bl2) {
                    connection.setAutoCommit(bl);
                }
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.reload();
    }

    public void reload(String string, String string2, Connection connection) {
        this.reload();
    }

    private void reload() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TTAutotraceTreeModel.this.fireTreeStructureChanged(this, new TreeNode[]{(TreeNode)TTAutotraceTreeModel.this.root}, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public List<String> displayedColumns() {
        List<String> list = TTExplainPlanNode.SysPlanColumns.getDisplayedColumns();
        return list;
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof TTExplainPlanNode) {
            Object object2 = ((TTExplainPlanNode)((Object)object)).getValue(n);
            return object2;
        }
        return super.getValueAt(object, n);
    }
}

