/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.utils.ValidatedTextField;
import oracle.javatools.dialogs.MessageDialog;

class CacheGroupNameField
extends ValidatedTextField {
    private String _lastName;
    private final int MAX_NAME_FIELD_LENGTH = 30;

    public CacheGroupNameField() {
        super(true);
        this.setText("");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CacheGroupNameField.this.setText(CacheGroupNameField.this.getText());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (CacheGroupNameField.this.getText().length() > 30) {
                    MessageDialog.error(null, (Object)(CacheGroupNameField.this.getText() + " " + Messages.getString("CGCCGPanel.isTooLong")), (String)Messages.getString("TimesTen.common.error"), null);
                    CacheGroupNameField.this.setText(CacheGroupNameField.this._lastName);
                    return;
                }
                if (!CacheGroupNameField.this.getText().matches("[a-zA-Z][_0-9a-zA-Z]*") && CacheGroupNameField.this.getText().length() > 0) {
                    MessageDialog.error(null, (Object)(CacheGroupNameField.this.getText() + " " + Messages.getString("CGCCGPanel.containsIllegalCharacter")), (String)Messages.getString("TimesTen.common.error"), null);
                    CacheGroupNameField.this.setText(CacheGroupNameField.this.getText().replaceAll("[\\W]|_", ""));
                }
                CacheGroupNameField.this._lastName = CacheGroupNameField.this.getText();
            }
        });
    }

    @Override
    protected String validate(String string) {
        if (string.length() > 30) {
            return this.getText() + " " + Messages.getString("CGCCGPanel.isTooLong");
        }
        if (string.length() == 0) {
            return Messages.getString("CGCCGPanel.cacheGroupNameCannotBeempty");
        }
        if (!string.matches("[a-zA-Z][_0-9a-zA-Z]*")) {
            return string + " " + Messages.getString("CGCCGPanel.containsIllegalCharacter");
        }
        return null;
    }
}

