/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvicePanel;
import oracle.dbtools.raptor.timesten.advisor.StatisticsPanel;
import oracle.dbtools.raptor.timesten.dialogs.connection.DatabaseCapturePanels;
import oracle.dbtools.raptor.timesten.dialogs.connection.MessageIndeterminateProgressMonitor;
import oracle.dbtools.raptor.timesten.dialogs.connection.TableStatistics;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class DatabaseCapture
extends AbstractMenuAction {
    private static Logger LOGGER = Logger.getLogger(DatabaseCapture.class.getPackage().getName());
    private static String MESSAGE = "message";
    private static String PROGRESS = "progress";
    private String[] progressMessages = new String[]{Messages.getString("IndexAdvisor.endingIndexAdvisorCapture"), Messages.getString("IndexAdvisor.collectingIndexAdvisorAdvice"), Messages.getString("IndexAdvisor.collectingOptimizerStatistics"), Messages.getString("IndexAdvisor.dropingIndexAdvisorData")};
    private JEWTDialog _dialog;
    private DatabaseCapturePanels _dcp;
    private MessageIndeterminateProgressMonitor _progressMonitor;
    private JButton _startButton;
    private JButton _stopButton;
    DBObject _dbObject;
    private boolean _captureState;
    private String _connectionID;
    private String _startTime;
    private final String LINE_SEPARATOR = TimesTenUtil.getLineSeparator();
    private static final String HOME_DIR;
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String START_DB_CAPTURE = "call ttIndexAdviceCaptureStart(1,0)";
    private static final String STOP_DB_CAPTURE = "call ttIndexAdviceCaptureEnd(1)";
    private static final String DROP_INFO = "call ttIndexAdviceCaptureDrop";
    private static final String CAPTURE_GET_INFO = "call ttIndexAdviceCaptureInfoGet()";
    private static final String[] TITLES;
    private ConfigurationPanel configurationPanel;
    private IndexAdvicePanel indexAdvisePanel;
    private StatisticsPanel statisticsPanel;
    private JPanel[] _panels;
    private boolean databaseCaptureFound = false;
    private boolean errorOnCapture;

    private IndexAdvicePanel getIndexAdvicePanel() {
        return this.indexAdvisePanel;
    }

    private StatisticsPanel getStatisticsPanel() {
        return this.statisticsPanel;
    }

    private synchronized void setCaptureState(boolean bl) {
        this._captureState = bl;
    }

    public void launch() {
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)this._dbObject);
        this._dbObject = this.getDBObject();
        this.setBlockOACRefresh(true);
        this._dcp = new DatabaseCapturePanels(this.getDBObject());
        this._panels = new JPanel[2];
        this.configurationPanel = new ConfigurationPanel(this.getDBObject());
        this.indexAdvisePanel = this._dcp.getTheIndexAdvicePanel();
        this._panels[0] = this.configurationPanel;
        this._panels[1] = this.indexAdvisePanel;
        MyActionListener myActionListener = new MyActionListener();
        this._dialog = UIUtils.createTabbedPanelDialog2((JPanel[])this._panels, (String[])TITLES, (String)Messages.getString("IndexAdvisor.databaseLeveCaptureTitle"), (ActionListener)myActionListener, null, null);
        this._dialog.setSize(new Dimension(800, 650));
        this._dialog.setButtonMask(20);
        this._startButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.start")));
        this._startButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.start")));
        this._startButton.addActionListener(myActionListener);
        this._stopButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.stop")));
        this._stopButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.stop")));
        this._stopButton.addActionListener(myActionListener);
        this._stopButton.setEnabled(false);
        this._dialog.addCustomButton((Component)this._startButton);
        this._dialog.addCustomButton((Component)this._stopButton);
        this.updateDatabaseCapture();
        JTabbedPane jTabbedPane = (JTabbedPane)this._dialog.getContent();
        jTabbedPane.setEnabledAt(1, false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.configurationPanel, "f1_ott_index_advisor_db_capture_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.indexAdvisePanel, "f1_ott_index_advisor_db_capture_html");
        TableStatistics tableStatistics = new TableStatistics(this.getDBObject().getConnection(), (Dialog)this._dialog);
        int n = tableStatistics.displayWarning();
        if (n != 1) {
            this._dialog.closeDialog(true);
            this._dialog.dispose();
        } else {
            this._dialog.setVisible(true);
        }
    }

    private void updateDatabaseCapture() {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this._dialog, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                Connection connection = DatabaseCapture.this.getDBObject().getConnection();
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    Connections.getInstance().lock(connection);
                    ResultSet resultSet = statement.executeQuery(DatabaseCapture.CAPTURE_GET_INFO);
                    while (resultSet.next()) {
                        Integer n = (Integer)resultSet.getObject("captureLevel");
                        if (n == 0) continue;
                        Integer n2 = (Integer)resultSet.getObject("captureState");
                        if (n2 == 1) {
                            DatabaseCapture.this.databaseCaptureFound = true;
                            DatabaseCapture.this.setCaptureState(true);
                            DatabaseCapture.this._connectionID = resultSet.getString("connId");
                            DatabaseCapture.this._startTime = resultSet.getString("captureStartTime");
                        } else {
                            DatabaseCapture.this.setCaptureState(false);
                        }
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Can't get ttstats captures", sQLException);
                    MessageDialog.error((Component)DatabaseCapture.this._dialog, (Object)TTSQLExceptionScrubber.getInstance().getMessage(DatabaseCapture.CAPTURE_GET_INFO, sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            LOGGER.log(Level.SEVERE, "Can't close statement", sQLException);
                        }
                    }
                    Connections.getInstance().unlock(connection);
                }
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
                if (DatabaseCapture.this.databaseCaptureFound && DatabaseCapture.this._captureState) {
                    DatabaseCapture.this.configurationPanel.refreshGUIWithDBCapture();
                    DatabaseCapture.this._startButton.setEnabled(false);
                    DatabaseCapture.this._stopButton.setEnabled(true);
                    DatabaseCapture.this.enableTabs(false);
                } else if (DatabaseCapture.this.databaseCaptureFound && !DatabaseCapture.this._captureState) {
                    DatabaseCapture.this.configurationPanel.refreshGuiWithDbStoped();
                    DatabaseCapture.this._startButton.setEnabled(true);
                    DatabaseCapture.this._stopButton.setEnabled(false);
                    DatabaseCapture.this.enableTabs(true);
                } else {
                    DatabaseCapture.this.configurationPanel.refreshGUIWIthNoDBCapture();
                    DatabaseCapture.this._startButton.setEnabled(true);
                    DatabaseCapture.this._stopButton.setEnabled(false);
                    DatabaseCapture.this.enableTabs(false);
                }
            }
        };
        swingWorker.execute();
    }

    private void enableTabs(boolean bl) {
        JTabbedPane jTabbedPane = (JTabbedPane)this._dialog.getContent();
        jTabbedPane.setEnabledAt(1, bl);
    }

    private void generateAdvice() {
        this.getIndexAdvicePanel().setCaptureLevel(1);
        this.getIndexAdvicePanel().generateAdvice();
    }

    private void generateTableStatistics() {
        this.getStatisticsPanel().generateStatistics(this.getDBObject().getConnection());
    }

    static {
        TITLES = new String[]{Messages.getString("IndexAdvisor.control"), Messages.getString("IndexAdvisor.indexRecommendations")};
        HOME_DIR = System.getProperty("user.home");
    }

    private class ConfigurationPanel
    extends JPanel {
        private ConfigurationPanel(DBObject dBObject) {
            this.setLayout(new GridBagLayout());
        }

        private void refreshGUIWIthNoDBCapture() {
            this.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            String string = Messages.getString("IndexAdvisor.databaseCaptureWarning");
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setBackground(Color.GRAY);
            jLabel.setPreferredSize(new Dimension(0, 40));
            jLabel.setHorizontalAlignment(0);
            this.add((Component)jLabel, gridBagConstraints);
            this.repaint();
        }

        private void refreshGUIWithDBCapture() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(1, 15, 1, 15);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.removeAll();
            String string = Messages.getString("IndexAdvisor.databaseCaptureInProgress");
            JLabel jLabel = new JLabel(string);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.captureStatus")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.inProgress")), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.startDate")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(DatabaseCapture.this._startTime), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.connectionId")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(DatabaseCapture.this._connectionID), gridBagConstraints);
            this.repaint();
        }

        private void refreshGuiWithDbStoped() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(1, 15, 1, 15);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.removeAll();
            String string = Messages.getString("IndexAdvisor.databaseCaptureDone");
            JLabel jLabel = new JLabel(string);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.captureStatus")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.notActive")), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.startDate")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(DatabaseCapture.this._startTime), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel(Messages.getString("IndexAdvisor.connectionId")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(DatabaseCapture.this._connectionID), gridBagConstraints);
            this.repaint();
        }
    }

    private class DatabaseCaptureWorker
    extends SwingWorker<Void, Void> {
        private final String _command;
        private boolean _enableTabs;

        private DatabaseCaptureWorker(String string) {
            this._command = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this._command.equals(DatabaseCapture.START)) {
                this.start();
            } else {
                this.stop();
            }
            return null;
        }

        @Override
        protected void done() {
            if (this._command.equals(DatabaseCapture.STOP) && !DatabaseCapture.this.errorOnCapture && this._enableTabs) {
                DatabaseCapture.this.enableTabs(true);
                DatabaseCapture.this._dcp.getTheIndexAdvicePanel().displayFeedback((Component)DatabaseCapture.this._dialog);
            }
            DatabaseCapture.this._progressMonitor.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start() throws Exception {
            Statement statement = null;
            Connection connection = null;
            DatabaseCapture.this.errorOnCapture = false;
            try {
                connection = DatabaseCapture.this.getDBObject().getConnection();
                Connections.getInstance().lock(connection);
                statement = connection.createStatement();
                this.firePropertyChange(MESSAGE, null, Messages.getString("IndexAdvisor.startDatabaseCapture"));
                statement.execute(DatabaseCapture.START_DB_CAPTURE);
                this.setProgress(100);
            }
            catch (SQLException sQLException) {
                DatabaseCapture.this._progressMonitor.close();
                DatabaseCapture.this.errorOnCapture = true;
                LOGGER.log(Level.SEVERE, "Can't start capture", sQLException);
                final String string = TTSQLExceptionScrubber.getInstance().getMessage(DatabaseCapture.this._dbObject.getConnectionName(), sQLException);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.error((Component)DatabaseCapture.this._dialog, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                    }
                });
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, "Error while closing statement", sQLException);
                    }
                }
                if (connection != null) {
                    Connections.getInstance().unlock(connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() throws Exception {
            Statement statement = null;
            Connection connection = null;
            DatabaseCapture.this.errorOnCapture = false;
            try {
                connection = DatabaseCapture.this.getDBObject().getConnection();
                statement = connection.createStatement();
                Connections.getInstance().lock(connection);
                this.firePropertyChange(MESSAGE, null, DatabaseCapture.this.progressMessages[0]);
                statement.execute(DatabaseCapture.STOP_DB_CAPTURE);
                this.firePropertyChange(MESSAGE, null, DatabaseCapture.this.progressMessages[1]);
                DatabaseCapture.this.generateAdvice();
                this.firePropertyChange(MESSAGE, null, DatabaseCapture.this.progressMessages[3]);
                statement.execute(DatabaseCapture.DROP_INFO);
                this.setProgress(100);
                this._enableTabs = true;
            }
            catch (SQLException sQLException) {
                DatabaseCapture.this._progressMonitor.close();
                DatabaseCapture.this.errorOnCapture = true;
                LOGGER.log(Level.SEVERE, "Can't stop capture", sQLException);
                final String string = TTSQLExceptionScrubber.getInstance().getMessage(DatabaseCapture.this._dbObject.getConnectionName(), sQLException);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.error((Component)DatabaseCapture.this._dialog, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                    }
                });
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, "Error while closing statement", sQLException);
                    }
                }
                if (connection != null) {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private String startOrStop;

        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DatabaseCapture.this._startButton) {
                this.startOrStop = DatabaseCapture.START;
            }
            if (actionEvent.getSource() == DatabaseCapture.this._stopButton) {
                this.startOrStop = DatabaseCapture.STOP;
            }
            DatabaseCapture.this._progressMonitor = new MessageIndeterminateProgressMonitor((Component)DatabaseCapture.this._dialog, Messages.getString("IndexAdvisor.databaseCaptureProgress"), Messages.getString("IndexAdvisor.databaseCaptureProgress"), null);
            DatabaseCapture.this._progressMonitor.addCancellationListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DatabaseCapture.this._progressMonitor.close();
                }
            });
            final DatabaseCaptureWorker databaseCaptureWorker = new DatabaseCaptureWorker(this.startOrStop);
            databaseCaptureWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (PROGRESS == propertyChangeEvent.getPropertyName()) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        String string = String.format(Messages.getString("IndexAdvisor.pertentageComplete"), n);
                        DatabaseCapture.this._progressMonitor.updateMessage(string);
                        if (n == 100) {
                            DatabaseCapture.this.updateDatabaseCapture();
                            DatabaseCapture.this._progressMonitor.finish();
                        }
                        DatabaseCapture.this._progressMonitor.updateTextArea(string);
                        DatabaseCapture.this._progressMonitor.updateTextArea(DatabaseCapture.this.LINE_SEPARATOR);
                        if (DatabaseCapture.this._progressMonitor.isCanceled() || databaseCaptureWorker.isDone()) {
                            Toolkit.getDefaultToolkit().beep();
                            if (DatabaseCapture.this._progressMonitor.isCanceled()) {
                                databaseCaptureWorker.cancel(true);
                            } else {
                                DatabaseCapture.this._progressMonitor.finish();
                            }
                        }
                    } else if (MESSAGE == propertyChangeEvent.getPropertyName()) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        DatabaseCapture.this._progressMonitor.updateTextArea(string);
                        DatabaseCapture.this._progressMonitor.updateTextArea(DatabaseCapture.this.LINE_SEPARATOR);
                    }
                }
            });
            databaseCaptureWorker.execute();
            DatabaseCapture.this._progressMonitor.start();
        }
    }
}

