/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadOracleTablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadSchema;
import oracle.dbtools.raptor.timesten.dialogs.table.load.OracleTableLoader;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class LoadOracleTable
extends AbstractMenuAction {
    private JEWTDialog _dialog;

    public void launch() {
        DBObject dBObject = this.getDBObject();
        OracleTableLoader oracleTableLoader = new OracleTableLoader(dBObject);
        LoadSchema loadSchema = new LoadSchema(dBObject);
        final LoadOracleTablePanel loadOracleTablePanel = new LoadOracleTablePanel(dBObject, oracleTableLoader, loadSchema);
        this._dialog = UIUtils.createPanelDialog((JPanel)loadOracleTablePanel, (String)Messages.getString("LoadTablesFromOracle.loadTablesTitle"), (ActionListener)loadOracleTablePanel);
        loadOracleTablePanel.setDialog(this._dialog);
        this._dialog.setButtonMask(2);
        this._dialog.setCancelButtonText(Messages.getString("LoadTablesFromOracle.closeButton"));
        this._dialog.setSize(new Dimension(1000, 650));
        this._dialog.setDefaultCloseOperation(2);
        this._dialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                loadOracleTablePanel.freeResources();
            }
        });
        this._dialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                loadOracleTablePanel.freeResources();
                LoadOracleTable.this._dialog.dispose();
            }
        });
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
        HelpSystem.getHelpSystem().registerTopic((JComponent)loadOracleTablePanel, "f1_ott_load_data_from_oracle_database_html");
        this._dialog.setVisible(true);
    }
}

