/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TT2ColGridBagConstraints;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.load.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.dialogs.table.load.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.load.MultipleOracleLoadable;
import oracle.dbtools.raptor.timesten.dialogs.table.load.SchemaProvider;
import oracle.dbtools.raptor.timesten.dialogs.table.load.SchemaTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.table.load.TableRefresher;
import oracle.dbtools.raptor.timesten.utils.ValidatedTextField;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadOracleTablePanel
extends JPanel
implements ActionListener,
TableRefresher {
    private static Logger _logger = Logger.getLogger(LoadOracleTablePanel.class.getPackage().getName());
    private DBObject _dbObject;
    private JPanel _leftPanel;
    private JPanel _buttonPanel;
    private JScrollPane _scrollTree;
    private SchemaTreePanel _tree;
    private LoadPanel _loadPanel;
    private JSplitPane _splitPane;
    private JButton _plusButton;
    private JButton _lessButton;
    private JButton _loadButton;
    private JComboBox _indexComboBox;
    private JLabel _indexLabel;
    private List<Object> _allSchemas;
    private List<Object> _openedSchemas;
    private SchemaTreeNode _treeRoot;
    private SchemaTreeNode _currentSchemaNode;
    private SchemasTreeModel _treeModel;
    private LoadTablesTable _loadTable;
    private JEWTDialog _dialog;
    private MultipleOracleLoadable _loadable;
    private TimesTenPassthrough _passthrough;
    private SchemaProvider provider;

    public LoadOracleTablePanel(DBObject dBObject, MultipleOracleLoadable multipleOracleLoadable, SchemaProvider schemaProvider) {
        this.setLayout(new BorderLayout());
        this._dbObject = dBObject;
        this._passthrough = new TimesTenPassthrough(this._dbObject);
        this._loadable = multipleOracleLoadable;
        this.provider = schemaProvider;
        this._treeRoot = new SchemaTreeNode(Messages.getString("LoadTablesFromOracle.schemas"), 1, null);
        this._currentSchemaNode = new SchemaTreeNode(this._dbObject.getSchemaName(), 2, null);
        this._treeRoot.add(this._currentSchemaNode);
        this._allSchemas = new LinkedList<Object>();
        this._openedSchemas = new LinkedList<Object>();
        this._plusButton = new JButton("+");
        this._lessButton = new JButton("-");
        this._loadButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        this._loadButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        String[] stringArray = new String[]{Messages.getString("LoadTablesFromOracle.indexCreationOption1"), Messages.getString("LoadTablesFromOracle.indexCreationOption2"), Messages.getString("LoadTablesFromOracle.indexCreationOption3")};
        this._indexComboBox = new JComboBox<String>(stringArray);
        this._indexLabel = new JLabel(Messages.getString("LoadTablesFromOracle.indexCreationLabel"));
        this._buttonPanel = new JPanel(new FlowLayout(1));
        this._buttonPanel.add(this._plusButton);
        this._buttonPanel.add(this._lessButton);
        this._leftPanel = new JPanel(new BorderLayout());
        this._loadTable = new LoadTablesTable(this, this._dbObject);
        this._loadPanel = new LoadPanel(this._loadTable);
        this._loadPanel.addIndexComponents(this._indexComboBox, this._indexLabel);
        this._splitPane = new JSplitPane(1);
        this._leftPanel.add((Component)this._buttonPanel, "North");
        this._treeModel = new SchemasTreeModel(this._treeRoot);
        this._tree = new SchemaTreePanel(this._treeModel);
        this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._scrollTree = new JScrollPane(this._tree);
        this._leftPanel.add((Component)this._scrollTree, "Center");
        this._splitPane.setLeftComponent(this._leftPanel);
        this._splitPane.setRightComponent(this._loadPanel);
        this._splitPane.setDividerLocation(0.5);
        this._splitPane.setContinuousLayout(true);
        this.add((Component)this._splitPane, "Center");
        this._plusButton.addActionListener(this);
        this._lessButton.addActionListener(this);
        this._loadButton.addActionListener(this);
        if (schemaProvider != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            schemaProvider.getSchemas(arrayList, this);
            for (Object e : arrayList) {
                if (!this._allSchemas.contains(e)) {
                    this._allSchemas.add(e);
                }
                if (!this._allSchemas.isEmpty()) continue;
                this._plusButton.setEnabled(false);
            }
        }
        this.setEnabledLoadButton(false);
        this.loadSchemaNodeTable(this._currentSchemaNode);
        if (System.getProperty("oracle.dbtools.raptor.timesten.maxparallelloads") == null) {
            System.setProperty("oracle.dbtools.raptor.timesten.maxparallelloads", String.valueOf(16));
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mapview_html");
    }

    public void loadSchema(List list) {
        for (Object e : list) {
            if (this._allSchemas.contains(e)) continue;
            this._allSchemas.add(e);
        }
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
        this._dialog.addCustomButton((Component)this._loadButton);
    }

    public void setEnabledLoadButton(boolean bl) {
        if (this._dialog != null) {
            this._loadButton.setEnabled(bl);
        }
    }

    private void loadSchemaNodeTable(final SchemaTreeNode schemaTreeNode) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        schemaTreeNode.removeAllChildren();
        this._treeModel.reload(schemaTreeNode);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                try {
                    String string = null;
                    if (schemaTreeNode.getFilter() == null) {
                        string = "SELECT table_name FROM all_tables WHERE owner = '#user#'".replace("#user#", schemaTreeNode.getLabel());
                    } else {
                        string = "SELECT table_name FROM all_tables WHERE owner = '#user#' AND table_name #filter#".replace("#user#", schemaTreeNode.getLabel());
                        string = string.replace("#filter#", schemaTreeNode.getFilter());
                    }
                    List<Object[]> list = LoadOracleTablePanel.this._passthrough.executeQueryOnOracle(string);
                    for (Object[] objectArray : list) {
                        final String string2 = objectArray[0].toString();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                schemaTreeNode.add(new SchemaTreeNode(string2, 3, schemaTreeNode.getLabel()));
                                LoadOracleTablePanel.this._treeModel.reload(schemaTreeNode);
                            }
                        });
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Error while loading tables into schema", sQLException);
                    if (sQLException.getErrorCode() == 15022) {
                        MessageDialog.error(null, (Object)Messages.getString("LoadTablesFromOracle.errorWithOraclePassword"), (String)Messages.getString("TimesTen.common.error"), null);
                    }
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(LoadOracleTablePanel.this._passthrough.getConnection(), LoadOracleTablePanel.this._passthrough.getLastError(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                return null;
            }

            @Override
            protected void done() {
                LoadOracleTablePanel.this._treeModel.reload(schemaTreeNode);
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private void loadTable(final SchemaTreeNode schemaTreeNode) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                LoadOracleTablePanel.this.helpLoadTable(schemaTreeNode);
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private void loadAllTables(final SchemaTreeNode schemaTreeNode, final String string) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                if (schemaTreeNode.isSchema()) {
                    Enumeration<TreeNode> enumeration = schemaTreeNode.depthFirstEnumeration();
                    try {
                        while (enumeration.hasMoreElements()) {
                            SchemaTreeNode schemaTreeNode2 = (SchemaTreeNode)enumeration.nextElement();
                            schemaTreeNode2.setLoadAllSchema(string);
                            LoadOracleTablePanel.this.helpLoadTable(schemaTreeNode2);
                            schemaTreeNode2.setLoadAllSchema(null);
                        }
                    }
                    catch (SQLException sQLException) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private void generateTableSchemaFromOracleQuery(String string, String string2, String string3, int n, Integer n2) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        Integer n3 = 1;
        try {
            if (n2 != null && n2 > 500000) {
                n3 = 2;
            }
            connection = this._dbObject.getConnection();
            Connections.getInstance().lock(connection);
            statement = connection.createStatement();
            String string4 = "call ttTableSchemaFromOraQueryGet('#owner#','#table#','#query#');".replace("#query#", string3).replace("#table#", string2);
            string4 = string4.replace("#owner#", string);
            ResultSet resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                LoadTableRow loadTableRow = new LoadTableRow(string, string2, string3, resultSet.getString(1), null, n, n3);
                this._loadTable.addRow(loadTableRow);
            }
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Couldn't get select query while loading", sQLException);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<Throwable> iterator = sQLException.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), (SQLException)iterator.next()) + "\n");
            }
            MessageDialog.error(null, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Error on closing statement", sQLException);
            }
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void helpLoadTable(SchemaTreeNode schemaTreeNode) throws SQLException {
        if (schemaTreeNode.isTable()) {
            String string = schemaTreeNode.getLoadAllSchema();
            String string2 = schemaTreeNode.getSchema();
            String string3 = schemaTreeNode.getLabel();
            if (string == null) {
                string = string2;
            }
            String string4 = "SELECT * from #schema#.#tableName#".replace("#tableName#", string3).replace("#schema#", string2);
            Integer n = this._passthrough.executeTableCountOnOracleFromAllTables(string2, string3);
            this.generateTableSchemaFromOracleQuery(string, string3, string4, 4, n);
        }
    }

    private void loadCustomQueryRow(final String string, final String string2, final String string3, final Integer n) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                LoadOracleTablePanel.this.generateTableSchemaFromOracleQuery(string, string2, string3, n, null);
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private List<Object> getNotOpenedSchemas() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : this._allSchemas) {
            if (this._openedSchemas.contains(object)) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    private void removeOpenedSchema(String string) {
        for (int i = 0; i < this._openedSchemas.size(); ++i) {
            if (!this._openedSchemas.get(i).toString().equals(string)) continue;
            this._openedSchemas.remove(i);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._plusButton) {
            Object object;
            SelectSchemaPanel selectSchemaPanel = new SelectSchemaPanel();
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)selectSchemaPanel, (String)Messages.getString("LoadTablesFromOracle.chooseSchema"), null);
            jEWTDialog.setButtonMask(3);
            if (jEWTDialog.runDialog() && (object = selectSchemaPanel.getSchema()) != null) {
                this._openedSchemas.add(object);
                if (this.getNotOpenedSchemas().isEmpty()) {
                    this._plusButton.setEnabled(false);
                }
                SchemaTreeNode schemaTreeNode = new SchemaTreeNode(object.toString(), 2, null);
                this._treeRoot.add(schemaTreeNode);
                this._treeModel.reload(this._treeRoot);
                this.loadSchemaNodeTable(schemaTreeNode);
            }
            return;
        }
        if (actionEvent.getSource() == this._lessButton) {
            SchemaTreeNode schemaTreeNode;
            if (this._tree.getSelectionPath().getPath().length > 0 && (schemaTreeNode = (SchemaTreeNode)this._tree.getSelectionPath().getLastPathComponent()).isSchema() && !schemaTreeNode.toString().equalsIgnoreCase(this._dbObject.getSchemaName())) {
                this._treeModel.removeNodeFromParent(schemaTreeNode);
                this.removeOpenedSchema(schemaTreeNode.toString());
                this._plusButton.setEnabled(true);
            }
            return;
        }
        if (actionEvent.getSource() == this._loadButton && this._loadable != null) {
            try {
                this._loadable.loadData(this._loadTable.getData(), this);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Error on loading all tables", actionEvent);
            }
        }
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    public void refreshStatusCell(int n) {
        this._loadTable.refreshStatusCell(n);
    }

    public String getIndexCreationPolicy() {
        return (String)this._indexComboBox.getSelectedItem();
    }

    public TimesTenPassthrough getPassthrough() {
        return this._passthrough;
    }

    @Override
    public void refreshTheCompleteTable() {
        this._loadTable.refreshTheCompleteTable();
    }

    @Override
    public void refreshRow(int n) {
        this._loadTable.refreshRow(n);
    }

    public void setEnabledComponents(boolean bl) {
        this._loadButton.setEnabled(bl);
        this._plusButton.setEnabled(bl);
        this._lessButton.setEnabled(bl);
        this._indexComboBox.setEnabled(bl);
        this._tree.setEnabledComponents(bl);
    }

    public void freeResources() {
        try {
            if (!this._passthrough.getConnection().isClosed()) {
                this._passthrough.getConnection().close();
            }
            this.provider.closeConnection();
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't close connection", sQLException);
        }
    }

    private class FilterPanel
    extends JPanel {
        private JLabel _tableText = new JLabel(Messages.getString("LoadTablesFromOracle.tableName"));
        private JComboBox _options = new JComboBox<String>(Common.likeOptions);
        private JTextField _value;

        public FilterPanel() {
            this._options.setSelectedIndex(2);
            this._value = new JTextField(10);
            this.add(this._tableText);
            this.add(this._options);
            this.add(this._value);
        }

        private String getValue() {
            if (this._options.getSelectedItem().toString().contains("LIKE")) {
                if (this._value.getText().contains("%")) {
                    return "'" + this._value.getText() + "'";
                }
                return "'%" + this._value.getText() + "%'";
            }
            return "'" + this._value.getText() + "'";
        }

        public String getFilter() {
            return this._options.getSelectedItem().toString() + " " + this.getValue();
        }
    }

    private class SelectSchemaPanel
    extends JPanel {
        private JPanel _contentPanel;
        private TT2ColGridBagConstraints constraint;
        private GridBagLayout _gridBag = new GridBagLayout();
        private JComboBox _combo;

        public SelectSchemaPanel() {
            this._contentPanel = new JPanel(this._gridBag);
            this.add(this._contentPanel);
            this.constraint = new TT2ColGridBagConstraints();
            this.constraint.new_row();
            JLabel jLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
            this._gridBag.setConstraints(jLabel, this.constraint);
            this._contentPanel.add(jLabel);
            this.constraint.col2();
            this._combo = new JComboBox<Object>(LoadOracleTablePanel.this.getNotOpenedSchemas().toArray());
            this._gridBag.setConstraints(this._combo, this.constraint);
            this._contentPanel.add(this._combo);
        }

        public Object getSchema() {
            return this._combo.getSelectedItem();
        }
    }

    private class UsernamePanel
    extends JPanel {
        private JLabel _text = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
        private JTextField _user = new JTextField(20);

        public UsernamePanel() {
            this.add(this._text);
            this.add(this._user);
        }

        public String getUserName() {
            return this._user.getText().trim();
        }
    }

    private class PTCValidatedTextField
    extends ValidatedTextField {
        public PTCValidatedTextField(boolean bl) {
            super(bl);
        }

        @Override
        protected String validate(String string) {
            try {
                if (Integer.parseInt(string) < 2) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                return MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelThreadCountError"), string) + " " + Messages.getString("LoadTablesFromOracle.parallelThreadHint");
            }
            return null;
        }
    }

    private class CustomPanel
    extends JPanel {
        private BasicEditorPane _queryEditor;
        private JLabel _queryEditorLable;
        private JLabel _threadCountLabel;
        private JLabel _ttUsernameLabel;
        private JLabel _tableNameLabel;
        private JLabel _oraUsernameLabel;
        private ValidatedTextField _threadCountJTF;
        private JTextField _ttUsernameJTF;
        private JTextField _tableNameJTF;
        private JTextField _oraUsernameJTF;

        public String getUserName() {
            return this._ttUsernameJTF.getText();
        }

        public String getTableName() {
            return this._tableNameJTF.getText();
        }

        public String getThreadCount() {
            return this._threadCountJTF.getText();
        }

        public String getQuery() {
            return this._queryEditor.getText();
        }

        public CustomPanel() {
            this.setLayout(new GridBagLayout());
            this._ttUsernameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
            this._ttUsernameJTF = new JTextField(15);
            this._tableNameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timesTenTableName"));
            this._tableNameJTF = new JTextField(15);
            this._oraUsernameLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
            this._oraUsernameJTF = new JTextField(15);
            this._oraUsernameJTF.setEditable(false);
            this._threadCountLabel = new JLabel(Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
            this._threadCountJTF = new PTCValidatedTextField(true);
            this._threadCountJTF.setText(String.valueOf(4));
            this._threadCountJTF.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    try {
                        CustomPanel.this._threadCountJTF.commit();
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, "Error while validating input of parallel thread count field", exception);
                    }
                }
            });
            this._queryEditorLable = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
            this._queryEditor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._queryEditor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._queryEditor.setPreferredSize(new Dimension(200, 200));
            this._queryEditorLable.setVerticalAlignment(1);
            this._queryEditorLable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            ResourceUtils.resLabel((JLabel)this._ttUsernameLabel, (Component)this._ttUsernameJTF, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"));
            ResourceUtils.resLabel((JLabel)this._oraUsernameLabel, (Component)this._oraUsernameJTF, (String)Messages.getString("LoadTablesFromORacle.schemaName"));
            ResourceUtils.resLabel((JLabel)this._threadCountLabel, (Component)this._threadCountJTF, (String)Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
            ResourceUtils.resLabel((JLabel)this._tableNameLabel, (Component)this._tableNameJTF, (String)Messages.getString("LoadTablesFromOracle.timesTenTableName"));
            ResourceUtils.resLabel((JLabel)this._queryEditorLable, (Component)this._queryEditor, (String)Messages.getString("LoadTablesFromOracle.selectQuery"));
            Insets insets = new Insets(2, 2, 2, 2);
            this.add((Component)this._oraUsernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._oraUsernameJTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._ttUsernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._ttUsernameJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._tableNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._tableNameJTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._queryEditorLable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._queryEditor, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._threadCountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._threadCountJTF, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this._tableNameJTF.setText(LoadOracleTablePanel.this._dbObject.getObjectName());
            this._ttUsernameJTF.setText(LoadOracleTablePanel.this._dbObject.getSchemaName());
            try {
                this._oraUsernameJTF.setText(LoadOracleTablePanel.this._dbObject.getConnection().getMetaData().getUserName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class LoadPanel
    extends JPanel {
        JPanel _tablePanel = new JPanel(new BorderLayout());
        JPanel _indexPanel;

        public LoadPanel(LoadTablesTable loadTablesTable) {
            this._tablePanel.add((Component)new JScrollPane(loadTablesTable), "Center");
            this._indexPanel = new JPanel(new BorderLayout(5, 0));
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this._tablePanel, "Center");
            this.add((Component)this._indexPanel, "South");
        }

        public void addIndexComponents(JComboBox jComboBox, JLabel jLabel) {
            this._indexPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            this._indexPanel.add((Component)jLabel, "West");
            this._indexPanel.add((Component)jComboBox, "Center");
        }
    }

    private class SchemasTreeModel
    extends DefaultTreeModel {
        public SchemasTreeModel(TreeNode treeNode) {
            super(treeNode);
        }
    }

    private class TreeIconRenderer
    extends DefaultTreeCellRenderer {
        private TreeIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof SchemaTreeNode) {
                SchemaTreeNode schemaTreeNode = (SchemaTreeNode)object;
                if (schemaTreeNode.isRoot()) {
                    this.setIcon(Common.SCHEMA_FOLDER_ICON);
                } else if (schemaTreeNode.isSchema()) {
                    this.setIcon(Common.SCHEMA_ICON);
                } else if (schemaTreeNode.isTable()) {
                    this.setIcon(Common.TABLE_ICON);
                }
            }
            return this;
        }
    }

    private class SchemaTreePanel
    extends JTree
    implements ActionListener,
    TreeWillExpandListener {
        private JPopupMenu _menu;
        private JMenuItem _load;
        private JMenuItem _loadAll;
        private JMenuItem _filter;
        private JMenuItem _removeFilter;
        private JMenuItem _custom;
        private SchemaTreeNode _selectedNode;
        private boolean enabledComponents;
        private MouseAdapter mouseAdapter;

        public SchemaTreePanel(SchemasTreeModel schemasTreeModel) {
            super(schemasTreeModel);
            this.mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        SchemaTreePanel.this.displayPopUp(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        SchemaTreePanel.this.displayPopUp(mouseEvent);
                    }
                }
            };
            this.addMouseListener(this.mouseAdapter);
            this._menu = new JPopupMenu();
            this.setCellRenderer(new TreeIconRenderer());
            this.setupMenuItems();
            this.addTreeWillExpandListener(this);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SchemaTreePanel.this.displayPopup();
                }
            };
            this.registerKeyboardAction(actionListener, keyStroke, 0);
            this.registerKeyboardAction(actionListener, keyStroke2, 0);
            this._menu.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SchemaTreePanel.this._menu.setVisible(false);
                }
            }, keyStroke3, 0);
            this.enabledComponents = true;
        }

        private void setupMenuItems() {
            this._custom = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.custom"), this._menu);
            this._load = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.load"), this._menu);
            this._loadAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.loadAll"), this._menu);
            this._filter = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.applyFilter"), this._menu);
            this._removeFilter = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.removeFilter"), this._menu);
            this._custom.addActionListener(this);
            this._load.addActionListener(this);
            this._loadAll.addActionListener(this);
            this._filter.addActionListener(this);
            this._removeFilter.addActionListener(this);
        }

        private void displayPopUp(MouseEvent mouseEvent) {
            if (!this.enabledComponents) {
                return;
            }
            int n = this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            this.setSelectionRow(n);
            TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
            if (treePathArray.length == 1) {
                this._selectedNode = (SchemaTreeNode)treePathArray[0].getLastPathComponent();
                this._menu.removeAll();
                if (this._selectedNode.isSchema()) {
                    this._menu.add(this._loadAll);
                    if (this._selectedNode.getFilter() == null) {
                        this._menu.add(this._filter);
                    } else {
                        this._menu.add(this._removeFilter);
                    }
                }
                if (this._selectedNode.isTable()) {
                    this._menu.add(this._load);
                }
                if (!this._selectedNode.isRoot()) {
                    this._menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this._menu.add(this._custom);
                    this._menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        private void displayPopup() {
            if (!this.enabledComponents) {
                return;
            }
            TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
            if (treePathArray.length == 1) {
                this._selectedNode = (SchemaTreeNode)treePathArray[0].getLastPathComponent();
                this._menu.removeAll();
                Rectangle rectangle = this.getPathBounds(treePathArray[0]);
                if (this._selectedNode.isSchema()) {
                    this._menu.add(this._loadAll);
                    if (this._selectedNode.getFilter() == null) {
                        this._menu.add(this._filter);
                    } else {
                        this._menu.add(this._removeFilter);
                    }
                }
                if (this._selectedNode.isTable()) {
                    this._menu.add(this._load);
                }
                if (!this._selectedNode.isRoot()) {
                    this._menu.show(this, rectangle.x, rectangle.y);
                } else {
                    this._menu.add(this._custom);
                    this._menu.show(this, rectangle.x, rectangle.y);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._load) {
                LoadOracleTablePanel.this.loadTable(this._selectedNode);
                return;
            }
            if (actionEvent.getSource() == this._custom) {
                final CustomPanel customPanel = new CustomPanel();
                final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)customPanel, (String)Messages.getString("LoadTablesFromOracle.customQuery"), null);
                jEWTDialog.setButtonMask(2);
                JButton jButton = new JButton();
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jButton.setText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            int n = new Integer(customPanel.getThreadCount());
                            if (n < 2) {
                                throw new Exception();
                            }
                            LoadOracleTablePanel.this.loadCustomQueryRow(customPanel.getUserName(), customPanel.getTableName(), customPanel.getQuery(), n);
                            jEWTDialog.dispose();
                        }
                        catch (Exception exception) {
                            MessageDialog.error(null, (Object)(MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelThreadCountError"), customPanel.getThreadCount()) + " " + Messages.getString("LoadTablesFromOracle.parallelThreadHint")), (String)Messages.getString("TimesTen.common.error"), null);
                        }
                    }
                });
                jEWTDialog.addCustomButton((Component)jButton);
                jEWTDialog.setVisible(true);
                return;
            }
            if (actionEvent.getSource() == this._loadAll) {
                UsernamePanel usernamePanel = new UsernamePanel();
                JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)usernamePanel, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"), null);
                jEWTDialog.setButtonMask(3);
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jEWTDialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                if (jEWTDialog.runDialog()) {
                    String string = usernamePanel.getUserName();
                    if (string.length() == 0) {
                        MessageDialog.error(null, (Object)"USERNAME CANT BE EMPTY ", (String)Messages.getString("TimesTen.common.error"), null);
                    } else {
                        LoadOracleTablePanel.this.loadAllTables(this._selectedNode, string);
                    }
                }
                return;
            }
            if (actionEvent.getSource() == this._filter) {
                FilterPanel filterPanel = new FilterPanel();
                JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)filterPanel, (String)Messages.getString("LoadTablesFromOracle.filter"), null);
                jEWTDialog.setButtonMask(3);
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jEWTDialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                if (jEWTDialog.runDialog()) {
                    this._selectedNode.setFilter(filterPanel.getFilter());
                    LoadOracleTablePanel.this.loadSchemaNodeTable(this._selectedNode);
                }
                return;
            }
            if (actionEvent.getSource() == this._removeFilter) {
                this._selectedNode.removeFilter();
                LoadOracleTablePanel.this.loadSchemaNodeTable(this._selectedNode);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            SchemaTreeNode schemaTreeNode = (SchemaTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            if (schemaTreeNode == LoadOracleTablePanel.this._treeRoot) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        public void setEnabledComponents(boolean bl) {
            this.enabledComponents = bl;
        }
    }
}

