/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.load.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.load.IndexInfo;

public class LoadTableRow {
    private String timesTenUser;
    private String timesTenTable;
    private String selectQuery;
    private String createTableStatement;
    private Integer rowCount;
    private Integer parallelLoads;
    private Integer parallelThread;
    private int status;
    private long timestenRowCount;
    private String error;
    private List<IndexInfo> indexes;
    private String idxImportError;
    private String oracleTable;
    private boolean enableParallelLoad;

    public LoadTableRow(String string, String string2, String string3, String string4, Integer n, Integer n2, Integer n3) {
        this.timesTenUser = string.toUpperCase();
        this.timesTenTable = string2.toUpperCase();
        this.selectQuery = string3;
        this.createTableStatement = string4;
        this.rowCount = n;
        this.enableParallelLoad = Common.validQuery(string3);
        this.parallelThread = n2;
        this.status = 3;
        this.idxImportError = "";
        this.oracleTable = "";
        this.parallelLoads = n3;
    }

    public String getTimesTenUser() {
        return this.timesTenUser;
    }

    public List<IndexInfo> getIndexes() {
        return this.indexes;
    }

    public String getIdxImportError() {
        return this.idxImportError;
    }

    public String getOracleTable() {
        return this.oracleTable;
    }

    public void setIdxImportError(String string) {
        this.idxImportError = string;
    }

    public void setIndexes(List<IndexInfo> list) {
        this.indexes = list;
    }

    public void setOracleTable(String string) {
        this.oracleTable = string;
    }

    public void setTimesTenUser(String string) {
        this.timesTenUser = string.toUpperCase();
        this.updateCreateTableOnUserNameUpdate(this.timesTenUser);
    }

    public String getTimesTenTable() {
        return this.timesTenTable;
    }

    public void setTimesTenTable(String string) {
        this.timesTenTable = string.toUpperCase();
        this.updateCreateTableOnTableNameUpdate(this.timesTenTable);
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String string) {
        this.selectQuery = string;
        this.enableParallelLoad = Common.validQuery(string);
    }

    public String getCreateTableStatement() {
        return this.createTableStatement;
    }

    public void setCreateTableStatement(String string) {
        this.createTableStatement = string;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Integer n) {
        this.rowCount = n;
    }

    public Integer getParallelLoads() {
        return this.parallelLoads;
    }

    public void setParallelLoads(Integer n) {
        this.parallelLoads = n;
    }

    public Integer getParallelThread() {
        return this.parallelThread;
    }

    public void setParallelThread(Integer n) {
        this.parallelThread = n;
    }

    public boolean getEnableParallelLoad() {
        return this.enableParallelLoad;
    }

    public void setEnableParallelLoad(boolean bl) {
        this.enableParallelLoad = bl;
    }

    private void updateCreateTableOnTableNameUpdate(String string) {
        if (this.getTimesTenTable() != null && this.getTimesTenTable().length() > 0 && this.createTableStatement != null) {
            StringBuffer stringBuffer = new StringBuffer(this.createTableStatement);
            int n = stringBuffer.indexOf("\".\"");
            int n2 = stringBuffer.indexOf("\"", n + 3);
            if (n >= 0 && n2 >= 0) {
                stringBuffer.replace(n + 3, n2, string);
            }
            this.createTableStatement = stringBuffer.toString();
        }
    }

    private void updateCreateTableOnUserNameUpdate(String string) {
        if (this.getTimesTenTable() != null && this.getTimesTenTable().length() > 0 && this.createTableStatement != null) {
            StringBuffer stringBuffer = new StringBuffer(this.createTableStatement);
            int n = stringBuffer.indexOf("\"");
            int n2 = stringBuffer.indexOf("\"", n + 1);
            if (n >= 0 && n2 >= 0) {
                stringBuffer.replace(n + 1, n2, string);
            }
            this.createTableStatement = stringBuffer.toString();
        }
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        if (this.status != 4) {
            return Common.STATUS_TEXT[this.status];
        }
        return this.error;
    }

    public String getDetailedStatusText() {
        if (this.status != 4) {
            StringBuilder stringBuilder = new StringBuilder(Common.STATUS_TEXT[this.status]);
            if (this.indexes != null) {
                stringBuilder.append("\n");
                if (this.idxImportError.equals("")) {
                    int n = this.indexes.size();
                    String string = "";
                    string = n == 1 ? Messages.getString("LoadTablesFromOracle.indexCreationOneIndex") : Messages.getString("LoadTablesFromOracle.indexCreationSeveralIndexes");
                    stringBuilder.append(MessageFormat.format(string, n, this.oracleTable));
                    n = 1;
                    for (IndexInfo indexInfo : this.indexes) {
                        stringBuilder.append("\n " + n++ + ". ");
                        stringBuilder.append(indexInfo.getStatusMsg());
                    }
                } else {
                    stringBuilder.append(this.idxImportError);
                }
            }
            return stringBuilder.toString();
        }
        return this.error;
    }

    public void setError(String string) {
        this.error = string;
    }

    public void setTimestenRowCount(long l) {
        this.timestenRowCount = l;
    }

    public long getTimestenRowCount() {
        return this.timestenRowCount;
    }

    public String getTimestenTableCountSQL() {
        return "SELECT count(*) from " + this.timesTenUser + "." + this.timesTenTable;
    }

    public String getSelectCountSQL() {
        return "SELECT count(*) FROM (" + this.selectQuery + ")";
    }
}

