/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.load.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.dialogs.table.load.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadOracleTablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.load.TableRefresher;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadTablesTable
extends JTable
implements ActionListener,
TableRefresher {
    private static Logger _logger = Logger.getLogger(LoadOracleTablePanel.class.getPackage().getName());
    private LoadTableModel _model;
    private List<LoadTableRow> _data;
    private JPopupMenu _popupMenu;
    private JMenuItem _delete;
    private JMenuItem _deleteAll;
    private JMenuItem _count;
    private JMenuItem _countAll;
    private LoadOracleTablePanel _mainPanel;
    private DBObject _dbObject;
    private TimesTenPassthrough _passthrough;

    public LoadTablesTable(LoadOracleTablePanel loadOracleTablePanel, DBObject dBObject) {
        this._dbObject = dBObject;
        this._passthrough = new TimesTenPassthrough(this._dbObject);
        this._data = new LinkedList<LoadTableRow>();
        this._model = new LoadTableModel();
        this._popupMenu = new JPopupMenu();
        this._mainPanel = loadOracleTablePanel;
        this.setModel(this._model);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                    LoadTablesTable.this.doRightClick(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                    LoadTablesTable.this.doRightClick(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    int n = LoadTablesTable.this.rowAtPoint(point);
                    int n2 = LoadTablesTable.this.columnAtPoint(point);
                    if (n2 == 2) {
                        LoadTablesTable.this.doDoubleClickOnSelectQuery(n, n2);
                    } else if (n2 == 4) {
                        LoadTablesTable.this.doDoubleClickOnCreateStatement(n, n2);
                    } else if (n2 == 7) {
                        LoadTablesTable.this.doDoubleClickOnStatus(n);
                    }
                }
            }
        });
        this.setupMenuItems();
        this.setupColumnsWidth();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadTablesTable.this.displayPopup();
            }
        };
        this.registerKeyboardAction(actionListener, keyStroke, 0);
        this.registerKeyboardAction(actionListener, keyStroke2, 0);
        this._popupMenu.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadTablesTable.this._popupMenu.setVisible(false);
            }
        }, keyStroke3, 0);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer2.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer2);
            if (i >= 2 && i != 6 && i != 5) continue;
            this.getColumnModel().getColumn(i).setCellEditor(new CustomCellEditor(this, i));
        }
    }

    private void setupColumnsWidth() {
        TableColumnSizer.setColumnsWidthToFit(this, true, true);
    }

    private void setupMenuItems() {
        this._delete = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.delete"), this._popupMenu);
        this._deleteAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.deleteAll"), this._popupMenu);
        this._count = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.count"), this._popupMenu);
        this._countAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.countAll"), this._popupMenu);
        this._delete.addActionListener(this);
        this._deleteAll.addActionListener(this);
        this._count.addActionListener(this);
        this._countAll.addActionListener(this);
        this._popupMenu.add(this._delete);
        this._popupMenu.add(this._deleteAll);
        this._popupMenu.add(this._count);
        this._popupMenu.add(this._countAll);
    }

    private void doDoubleClickOnSelectQuery(int n, int n2) {
        LoadTableRow loadTableRow = this._data.get(n);
        EditQueryPanel editQueryPanel = new EditQueryPanel();
        String string = loadTableRow.getSelectQuery().trim();
        editQueryPanel.setSQL(string);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)editQueryPanel, (String)Messages.getString("LoadTablesFromOracle.editSelectQuery"), null);
        jEWTDialog.setButtonMask(3);
        if (jEWTDialog.runDialog()) {
            String string2 = editQueryPanel.getSQL();
            if (!Common.validQuery(string2)) {
                loadTableRow.setParallelLoads(1);
                this._model.fireTableCellUpdated(n, 5);
            }
            if (!string.equalsIgnoreCase(string2.trim())) {
                loadTableRow.setRowCount(null);
                this._model.fireTableCellUpdated(n, 3);
            }
            loadTableRow.setSelectQuery(editQueryPanel.getSQL());
            this._model.fireTableCellUpdated(n, n2);
        }
    }

    private void doDoubleClickOnCreateStatement(int n, int n2) {
        LoadTableRow loadTableRow = this._data.get(n);
        CreateQueryPanel createQueryPanel = new CreateQueryPanel();
        createQueryPanel.setSQL(loadTableRow.getCreateTableStatement());
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)createQueryPanel, (String)Messages.getString("LoadTablesFromOracle.createStatement"), null);
        jEWTDialog.setButtonMask(1);
        if (jEWTDialog.runDialog()) {
            // empty if block
        }
    }

    private void doDoubleClickOnStatus(int n) {
        LoadTableRow loadTableRow = this._data.get(n);
        StatusPanel statusPanel = new StatusPanel();
        statusPanel.setStatus(loadTableRow.getDetailedStatusText());
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)statusPanel, (String)Messages.getString("LoadTablesFromOracle.status"), null);
        jEWTDialog.setButtonMask(1);
        if (jEWTDialog.runDialog()) {
            // empty if block
        }
    }

    private void doRightClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        this.getSelectionModel().setSelectionInterval(n, n);
        this._popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void displayPopup() {
        Rectangle rectangle = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
        this._popupMenu.show(this, rectangle.x, rectangle.y);
    }

    public void addRow(LoadTableRow loadTableRow) {
        this._data.add(loadTableRow);
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableRowsInserted(this._data.size() - 1, this._data.size() - 1);
            this.verifyCanLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoadTablesTable.this._model.fireTableRowsInserted(LoadTablesTable.this._data.size() - 1, LoadTablesTable.this._data.size() - 1);
                    LoadTablesTable.this.verifyCanLoad();
                }
            });
        }
    }

    public void deleteSelectedRows() {
        int[] nArray;
        for (int n : nArray = this.getSelectedRows()) {
            this._data.remove(n);
        }
        this._model.fireTableDataChanged();
        this.verifyCanLoad();
    }

    public void deleteAllRows() {
        this._data.clear();
        this._model.fireTableDataChanged();
        this.verifyCanLoad();
    }

    private void verifyCanLoad() {
        if (this._data.size() > 0) {
            this._mainPanel.setEnabledLoadButton(true);
        } else {
            this._mainPanel.setEnabledLoadButton(false);
        }
    }

    public List<LoadTableRow> getData() {
        return this._data;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._delete == actionEvent.getSource()) {
            if (MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.deleteRowQuestion"), (String)Messages.getString("LoadTablesFromOracle.confirmDelete"), null)) {
                this.deleteSelectedRows();
            }
            return;
        }
        if (this._deleteAll == actionEvent.getSource()) {
            if (MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.deleteAllRowsQuestion"), (String)Messages.getString("LoadTablesFromOracle.confirmDelete"), null)) {
                this.deleteAllRows();
            }
            return;
        }
        if (this._count == actionEvent.getSource()) {
            this.doSelectCount();
            return;
        }
        if (this._countAll == actionEvent.getSource() && MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.countAllQuestion"), (String)Messages.getString("LoadTablesFromOracle.count"), null)) {
            this.doSelectCountAll();
        }
    }

    private void doSelectCountAll() {
        final DeterminateProgressMonitor determinateProgressMonitor = new DeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        determinateProgressMonitor.setMaximum(this._data.size());
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            List<String> rows = new ArrayList<String>();

            @Override
            protected Void doInBackground() throws Exception {
                determinateProgressMonitor.display();
                int n = 1;
                for (LoadTableRow loadTableRow : LoadTablesTable.this._data) {
                    Integer n2 = LoadTablesTable.this.getQueryCount(loadTableRow);
                    loadTableRow.setRowCount(n2);
                    if (n2 < 500000 && loadTableRow.getParallelLoads() > 1) {
                        this.rows.add(String.valueOf(n));
                    }
                    determinateProgressMonitor.incProgress();
                    ++n;
                }
                return null;
            }

            @Override
            protected void done() {
                determinateProgressMonitor.close();
                LoadTablesTable.this._model.fireTableDataChanged();
                if (!this.rows.isEmpty()) {
                    String string = "";
                    if (this.rows.size() == 1) {
                        string = MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadNoEnoughRows1"), this.rows.get(0), 500000);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < this.rows.size(); ++i) {
                            if (i == this.rows.size() - 1) {
                                stringBuilder.append("and " + this.rows.get(i));
                                continue;
                            }
                            stringBuilder.append(this.rows.get(i) + ", ");
                        }
                        string = MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadNoEnoughRowsN"), stringBuilder.toString(), 500000);
                    }
                    MessageDialog.information(null, (Object)string, (String)Messages.getString("LoadTablesFromOracle.loadTablesTitle"), null);
                }
            }
        };
        swingWorker.execute();
    }

    private void doSelectCount() {
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            final int n = nArray[i];
            final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    indeterminateProgressMonitor.display();
                    LoadTableRow loadTableRow = (LoadTableRow)LoadTablesTable.this._data.get(n);
                    Integer n2 = LoadTablesTable.this.getQueryCount(loadTableRow);
                    loadTableRow.setRowCount(n2);
                    return null;
                }

                @Override
                protected void done() {
                    LoadTablesTable.this._model.fireTableCellUpdated(n, 3);
                    indeterminateProgressMonitor.close();
                    if (((LoadTableRow)LoadTablesTable.this._data.get(n)).getRowCount() < 500000 && ((LoadTableRow)LoadTablesTable.this._data.get(n)).getParallelLoads() > 1) {
                        MessageDialog.information(null, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadNoEnoughRows"), ((LoadTableRow)LoadTablesTable.this._data.get(n)).getRowCount(), 500000), (String)Messages.getString("LoadTablesFromOracle.loadTablesTitle"), null);
                    }
                }
            };
            swingWorker.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getQueryCount(LoadTableRow loadTableRow) {
        Connection connection = null;
        Statement statement = null;
        try {
            Integer n = this._passthrough.executeTableCountOnOracle(loadTableRow.getSelectCountSQL());
            return n;
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Couldn't get row count", sQLException);
            MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, loadTableRow.getSelectCountSQL(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't close statement", sQLException);
                }
            }
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        return null;
    }

    public void refreshStatusCell(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableCellUpdated(n, 7);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoadTablesTable.this._model.fireTableCellUpdated(n, 7);
                }
            });
        }
    }

    @Override
    public void refreshTheCompleteTable() {
        this._model.fireTableDataChanged();
    }

    @Override
    public void refreshRow(int n) {
        this._model.fireTableRowsUpdated(n, n);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        this.setEnabledComponents(n2 != 5 && n2 != 6);
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    public void setEnabledComponents(boolean bl) {
        this._mainPanel.setEnabledComponents(bl);
    }

    private class StatusPanel
    extends JPanel {
        private BasicEditorPane _editor;

        public StatusPanel() {
            this.setLayout(new BorderLayout());
            this._editor = EditorFactory.createIdeEditorPane();
            this._editor.setPreferredSize(new Dimension(400, 400));
            this.add((Component)this._editor, "Center");
        }

        public void setStatus(String string) {
            this._editor.setText(string);
            this._editor.setEditable(false);
        }
    }

    private class CreateQueryPanel
    extends JPanel {
        private BasicEditorPane _editor;
        private JLabel _text;

        public CreateQueryPanel() {
            this.setLayout(new BorderLayout());
            this._text = new JLabel(Messages.getString("LoadTablesFromOracle.createStatement"));
            this._editor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._editor.setPreferredSize(new Dimension(300, 400));
            this._text.setVerticalAlignment(1);
            this._text.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this._text, "West");
            this.add((Component)this._editor, "Center");
        }

        public void setSQL(String string) {
            this._editor.setText(string);
            this._editor.setEditable(false);
        }
    }

    private class EditQueryPanel
    extends JPanel {
        private BasicEditorPane _editor;
        private JLabel _text;

        public EditQueryPanel() {
            this.setLayout(new BorderLayout());
            this._text = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
            this._editor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._editor.setPreferredSize(new Dimension(300, 400));
            this._text.setVerticalAlignment(1);
            this._text.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this._text, "West");
            this.add((Component)this._editor, "Center");
        }

        public String getSQL() {
            return this._editor.getText();
        }

        public void setSQL(String string) {
            this._editor.setText(string);
        }
    }

    private class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component;
        int column;
        int row;
        Border defaultBorder;
        LoadTablesTable _table;

        public CustomCellEditor(LoadTablesTable loadTablesTable2, int n) {
            this._table = loadTablesTable2;
            this.column = n;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.component = new JTextField();
            ((JTextField)this.component).setText(String.valueOf(object));
            ((JTextField)this.component).setHorizontalAlignment(0);
            this.defaultBorder = ((JTextField)this.component).getBorder();
            return this.component;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.column == 6 || this.column == 5) {
                try {
                    Object object = this.getCellEditorValue();
                    if (this.column == 5) {
                        Integer n = (Integer)object;
                        if (n > 1 && this._table.getData().get(this.row).getRowCount() != null && this._table.getData().get(this.row).getRowCount() <= 500000) {
                            MessageDialog.information(null, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadNoEnoughRows"), this._table.getData().get(this.row).getRowCount(), 500000), (String)Messages.getString("LoadTablesFromOracle.loadTablesTitle"), null);
                        }
                        if (n > 16) {
                            MessageDialog.information(null, (Object)MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadGreaterThanMax"), 16), (String)Messages.getString("LoadTablesFromOracle.loadTablesTitle"), null);
                        }
                    }
                }
                catch (Exception exception) {
                    ((JTextField)this.component).setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.RED));
                    String string = "";
                    if (this.column == 6) {
                        string = MessageFormat.format(Messages.getString("LoadTablesFromOracle.numberOfThreadsError"), ((JTextField)this.component).getText()) + " " + Messages.getString("LoadTablesFromOracle.parallelThreadHint");
                    } else if (this.column == 5) {
                        string = MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelLoadError"), ((JTextField)this.component).getText()) + " " + Messages.getString("LoadTablesFromOracle.parallelLoadHint");
                    }
                    MessageDialog.error(null, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                    return false;
                }
            }
            ((JTextField)this.component).setBorder(this.defaultBorder);
            this._table.setEnabledComponents(true);
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            String string = ((JTextField)this.component).getText().trim();
            if (this.column == 6) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 2) {
                        throw new Exception();
                    }
                    return n;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (this.column == 5) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 1) {
                        throw new Exception();
                    }
                    return n;
                }
                catch (Exception exception) {
                    throw new RuntimeException();
                }
            }
            return string;
        }
    }

    private class LoadTableModel
    extends AbstractTableModel {
        private LoadTableModel() {
        }

        @Override
        public int getRowCount() {
            return LoadTablesTable.this._data.size();
        }

        @Override
        public int getColumnCount() {
            return Common.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getTimesTenUser();
                }
                case 1: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getTimesTenTable();
                }
                case 2: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getSelectQuery();
                }
                case 3: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getRowCount();
                }
                case 4: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getCreateTableStatement();
                }
                case 5: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getParallelLoads();
                }
                case 6: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getParallelThread();
                }
                case 7: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getStatusText();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return Common.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 5: {
                    return ((LoadTableRow)LoadTablesTable.this._data.get(n)).getEnableParallelLoad();
                }
                case 0: 
                case 1: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            LoadTableRow loadTableRow = null;
            switch (n2) {
                case 0: {
                    loadTableRow = (LoadTableRow)LoadTablesTable.this._data.get(n);
                    loadTableRow.setTimesTenUser((String)object);
                    this.fireTableCellUpdated(n, 4);
                    break;
                }
                case 1: {
                    loadTableRow = (LoadTableRow)LoadTablesTable.this._data.get(n);
                    loadTableRow.setTimesTenTable((String)object);
                    this.fireTableCellUpdated(n, 4);
                    break;
                }
                case 2: {
                    if (!Common.validQuery((String)object)) {
                        ((LoadTableRow)LoadTablesTable.this._data.get(n)).setParallelLoads(1);
                        this.fireTableCellUpdated(n, 5);
                    }
                    ((LoadTableRow)LoadTablesTable.this._data.get(n)).setSelectQuery((String)object);
                    break;
                }
                case 3: {
                    ((LoadTableRow)LoadTablesTable.this._data.get(n)).setRowCount((Integer)object);
                    break;
                }
                case 4: {
                    ((LoadTableRow)LoadTablesTable.this._data.get(n)).setCreateTableStatement((String)object);
                    break;
                }
                case 5: {
                    ((LoadTableRow)LoadTablesTable.this._data.get(n)).setParallelLoads((Integer)object);
                    break;
                }
                case 6: {
                    ((LoadTableRow)LoadTablesTable.this._data.get(n)).setParallelThread((Integer)object);
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 7: {
                    return String.class;
                }
                case 3: 
                case 5: 
                case 6: {
                    return Integer.class;
                }
            }
            return null;
        }
    }
}

