/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.plsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.plsql.BasicPlSqlTab;

public class PlSqlDetails
extends BasicPlSqlTab {
    private MyTableModel theModel;
    protected static Logger theLogger = Logger.getLogger(PlSqlDetails.class.getPackage().getName());

    @Override
    protected AbstractTableModel initializeModel() throws Exception {
        this.theModel = new MyTableModel();
        return this.theModel;
    }

    @Override
    protected void refreshData() throws Exception {
        if (this.theModel == null) {
            this.theModel = new MyTableModel();
            return;
        }
        this.theModel.init();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theDetailColumnNames = new String[]{Messages.getString("TimesTen.plsql.col.name"), Messages.getString("TimesTen.plsql.col.value")};

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, "PL/SQL Details init failed " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Object[] objectArray;
                int n;
                String string = PlSqlDetails.this.theDbObject.getObjectName();
                String string2 = PlSqlDetails.this.theDbObject.getSchemaName();
                String string3 = PlSqlDetails.this.theDbObject.getObjectType();
                this.theRows.clear();
                Connection connection = PlSqlDetails.this.theDbObject.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select * from all_objects where owner = '" + string2 + "' and object_name = '" + string + "' and ROWNUM = 1 and object_type = '" + string3 + "'");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = 0;
                while (resultSet.next()) {
                    for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                        objectArray = new Object[resultSetMetaData.getColumnCount()];
                        objectArray[0] = resultSetMetaData.getColumnName(n);
                        objectArray[1] = resultSet.getString(n);
                        this.theRows.add(objectArray);
                        ++n2;
                    }
                }
                resultSet.close();
                resultSet = statement.executeQuery("select s.nls_length_semantics, s.plsql_ccflags, s.plsql_code_type, s.plsql_debug, s.plsql_optimize_level, s.plsql_warnings, s.plscope_settings from all_plsql_object_settings s where owner = '" + string2 + "' and name = '" + string + "' and ROWNUM = 1 and type = '" + string3 + "'");
                resultSetMetaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                        objectArray = new Object[resultSetMetaData.getColumnCount()];
                        objectArray[0] = resultSetMetaData.getColumnName(n);
                        objectArray[1] = resultSet.getString(n);
                        this.theRows.add(objectArray);
                        ++n2;
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, "PL/SQL Details SELECT failed " + sQLException.toString(), sQLException);
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return this.theDetailColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theDetailColumnNames.length) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theDetailColumnNames[n];
        }
    }
}

