/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.dialogs.table.ImportData;
import oracle.dbtools.raptor.timesten.editors.TTSchemaSQLTab;
import oracle.dbtools.raptor.timesten.utils.TTSchema;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class TTIsql {
    private static Logger theLogger = Logger.getLogger(TTIsql.class.getPackage().getName());
    private static final Pattern PASSWORD_PROMPT_REGEX = Pattern.compile("(^Enter\\s+password\\s+for\\s+[^:]*:\\s*)(.*)");
    private String dsn;
    private String owner;
    private String password;
    private boolean isClientServer;
    private boolean promptFlag;
    private String error;
    private String commandOutput;
    private DBObject dbObject;
    private String jdbcURL;
    private boolean isWindows;
    private final String DIRECT_OR_WINDOWS_COMMAND_NAME = "ttisql";
    private final String CS_COMMAND_NAME = "ttIsqlCS";
    private String commandNameToUse;
    private String dsnString;
    private String[] args;
    private String connectionName;
    private String[] output;

    public TTIsql(DBObject dBObject) {
        TTInstanceInformation tTInstanceInformation;
        this.dbObject = dBObject;
        this.dsn = TTSchemaSQLTab.getDSN(dBObject);
        this.connectionName = dBObject.getConnectionName();
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.isWindows = true;
        }
        try {
            this.jdbcURL = dBObject.getConnection().getMetaData().getURL().toString();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Error on getting jdbc url", sQLException);
        }
        if (this.jdbcURL.toLowerCase().contains(":client:")) {
            this.isClientServer = true;
        }
        this.commandNameToUse = this.isClientServer && !this.isWindows ? "ttIsqlCS" : "ttisql";
        if (this.dsn.toUpperCase().indexOf("TTC_SERVER_DSN") != -1) {
            tTInstanceInformation = TTInstanceInformation.getInstance();
            this.dsnString = "\"" + this.dsn + ";" + tTInstanceInformation.getClientDriver() + "\"";
        } else {
            this.dsnString = "\"DSN=" + this.dsn + "\"";
        }
        tTInstanceInformation = Connections.getInstance();
        Properties properties = tTInstanceInformation.getConnectionInfo(this.connectionName);
        this.password = properties.getProperty("password");
        if (this.password == null) {
            this.password = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)this.connectionName), "sys1");
        }
    }

    public void executeOnTTIsql(String string) {
        this.args = new String[5];
        this.args[0] = this.commandNameToUse;
        this.args[1] = "-connStr";
        this.args[2] = this.dsnString;
        this.args[3] = "-f";
        this.args[4] = '\"' + string + '\"';
        this.output = TTSchema.run(this.args, true, this.password);
        if (this.output[1] != null) {
            String string2 = this.output[1];
            string2 = TTSQLExceptionScrubber.getMessage(string2, null, Logger.getLogger(ImportData.class.getPackage().getName()));
            string2 = string2.replaceAll("Run 'ttIsql -help' for usage information.", "");
            this.error = string2 = string2.replaceAll("\n", " ");
        }
        this.commandOutput = this.output[0];
    }

    public String getError() {
        return this.error;
    }

    public String getCommandOutput() {
        return this.commandOutput;
    }

    public String[] getOutput() {
        return this.output;
    }
}

