/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.patch.PatchException;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class PatchExceptionHandler {
    public final void handleException(Exception e) {
        this.handleException(e, null);
    }

    public final void handleException(final Exception e, final Component parent) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            this.handleExceptionImpl(e, null);
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.handleExceptionImpl(e, parent != null ? parent : VersioningCoreUtil.getCurrentWindow());
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public final void run() {
                    PatchExceptionHandler.this.handleException(e, parent);
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
        }
    }

    protected void handleExceptionImpl(Exception e, Component parent) {
        if (e instanceof ChangeVetoException) {
            return;
        }
        if (!Ide.getIdeArgs().getCreateUI()) {
            e.printStackTrace();
            return;
        }
        if (e instanceof PatchException) {
            this.handlePatchException((PatchException)e, parent);
            return;
        }
        if (FeedbackManager.isOn()) {
            FeedbackManager.reportException((Throwable)e);
            return;
        }
        ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e, (String)IdeUtil.getProgramName(), (String)e.getMessage(), null);
    }

    protected final void handlePatchException(PatchException ce, Component parent) {
        String title = ce.getTitle();
        if (title == null) {
            title = IdeUtil.getProgramName();
        }
        MessageDialog.error((Component)parent, (Object)ce.getMessage(), (String)title, null);
    }
}

