/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import oracle.javatools.patch.PatchContext;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchCreateOptions;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchMatchOptions;
import oracle.javatools.patch.PatchModel;
import oracle.javatools.patch.PatchStreamContributor;
import oracle.jdeveloper.compare.StreamDecoder;

public class PatchUtil {
    public static String generatePatch(URL prvUrl, URL url) throws Exception {
        PatchCreateOptions createOptions = new PatchCreateOptions();
        createOptions.setRecursive(false);
        createOptions.setIncludeNewFiles(false);
        createOptions.setIgnoreWhitespace(false);
        File from = new File(prvUrl.getPath());
        File to = new File(url.getPath());
        PatchContributor fromCont = new PatchContributor(from.getParentFile(), from.getName());
        PatchContributor toCont = new PatchContributor(to.getParentFile(), to.getName());
        PatchEngine patchEngine = new PatchEngine(toCont);
        PatchModel patchModel = patchEngine.createModel(fromCont, createOptions);
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(StreamDecoder.getDefaultEncoding((URL)url));
        String patchSource = patchFormat.format(patchModel);
        return patchSource;
    }

    public static byte[] generatePatch(InputStream fromIO, InputStream toIO, String type, String encoding) throws Exception {
        PatchStreamContributor fromStream = new PatchStreamContributor(fromIO);
        PatchStreamContributor toStream = new PatchStreamContributor(toIO);
        fromStream.setType(type);
        toStream.setType(type);
        PatchCreateOptions createOptions = new PatchCreateOptions();
        createOptions.setRecursive(false);
        createOptions.setIncludeNewFiles(false);
        createOptions.setIgnoreWhitespace(false);
        PatchEngine patchEngine = new PatchEngine(toStream);
        PatchModel patchModel = patchEngine.createModel(fromStream, createOptions);
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(encoding);
        return patchFormat.formatByte(patchModel);
    }

    public static byte[] applyReversePatch(byte[] patch, InputStream is, String encoding) throws ParseException, IOException {
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(encoding);
        PatchModel model = patchFormat.parse(patch, true);
        PatchStreamContributor toStream = new PatchStreamContributor(is);
        PatchEngine engine = new PatchEngine(toStream);
        PatchMatchOptions options = new PatchMatchOptions();
        options.setIgnoreWhitespace(false);
        options.setMaximumFuzzFactor(0);
        options.setPrefixSlashNumber(0);
        PatchModel reverseModel = engine.reverseModel(model, null);
        PatchContext pContext = engine.matchModelNoFiles(reverseModel, options);
        return engine.applyModelNoFiles(reverseModel, pContext);
    }
}

