/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xmlschema;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaResource;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.xmlschema.XmlSchema;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ElementAttributes;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.SectionView;

public class XmlSchemaNode
extends DatabaseSourceNode {
    public boolean isReadOnly() {
        return true;
    }

    protected void saveImpl() throws IOException {
        boolean bl = this.isDirty();
        if (bl) {
            if (!DBURLFormatHelper.isDBURL((URL)this.getURL())) {
                super.saveImpl();
            } else {
                Component component;
                String string = (String)this.getProperty("ConnectionName");
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("URL", this.getProperty("NAME"));
                TextBuffer textBuffer = this.getTextBufferDirectly();
                hashMap.put("DOC", textBuffer.getString(0, textBuffer.getLength()));
                hashMap.put("OWNER", this.getProperty("SCHEMA"));
                QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(((Object)((Object)this)).getClass().getClassLoader(), "/oracle/dbtools/raptor/navigator/xmlschema/XmlSchemaSQL.xml"));
                Query query = queryXMLSupport.getQuery("RegisterXMLSchema", string);
                if (query == null) {
                    throw new IOException(XmlSchema.getString("XMLSCHEMA_BAD_VERSION"));
                }
                DBUtil dBUtil = DBUtil.getInstance((String)string);
                if (!dBUtil.execute(query.getSql(), hashMap)) {
                    SQLException sQLException = dBUtil.getLastException();
                    if (sQLException != null) {
                        throw new IOException(sQLException);
                    }
                    throw new IOException(XmlSchema.getString("XMLSCHEMA_SAVE_ERROR"));
                }
                this.markDirty(false);
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor.getContext().getNode() == this && editor instanceof CodeEditor && (component = ((CodeEditor)editor).getGUI()) instanceof SectionView && ((SectionView)component).getWrappedComponent() instanceof BasicEditorPane) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((BasicEditorPane)((SectionView)component).getWrappedComponent()).setProtected(true);
                        }
                    });
                }
                this.setReadOnly(true);
                this.getAttributes().set(ElementAttributes.READ_ONLY);
                this.getAttributes().set(ElementAttributes.NON_EDITABLE);
                textBuffer.setReadOnly(true);
            }
        }
    }

    protected Reader createReader(URL uRL) throws IOException {
        StringReader stringReader = null;
        String string = (String)this.getProperty("ConnectionName");
        try {
            Database database = Connections.getInstance().getDatabase(string, false);
            XMLSchema xMLSchema = (XMLSchema)database.getObject((String)this.getProperty("TYPE"), database.getSchema((String)this.getProperty("SCHEMA")), (String)this.getProperty("NAME"));
            if (xMLSchema != null) {
                this.setReadOnly(true);
                this.getAttributes().set(ElementAttributes.READ_ONLY);
                this.getAttributes().set(ElementAttributes.NON_EDITABLE);
                Map map = xMLSchema.getProperties();
                String string2 = xMLSchema.getSchemaText();
                stringReader = string2 != null ? new StringReader(string2) : new StringReader("");
            }
        }
        catch (DBException dBException) {
            throw new IOException(dBException.getMessage());
        }
        return stringReader;
    }
}

