/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.peek.HoverOptions;
import oracle.ideimpl.peek.PeekBundle;
import oracle.ideimpl.peek.PeekHookHandler;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.builders.BuiltCombo;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.ComboBuilder;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.combo.CheckComboText;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.javatools.ui.table.RolloverTableRenderer;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

final class HoverOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JTable table;
    private static GenericTablePersistentSettings tableSettings;
    final JLabel smartShortcutLabel = new JLabel(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_SHORTCUT"));
    private JCheckBox smartCheckBox = new JCheckBox(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_CHECK"));
    private JComboBox smartComboBox;
    private ListenableCollection<HoverActivator.Modifier> smartCheckedItems;
    private List<HoverFlavor> flavorList;
    private HoverOptions options;

    public HoverOptionsPanel() {
        this.setHelpID("f1_pref_hoverpage_html");
        this.initializeComponent();
    }

    private static HoverOptions getOptions(TraversableContext tc) {
        return HoverOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.options = HoverOptionsPanel.getOptions(tc);
        this.flavorList.clear();
        this.flavorList.addAll(this.options.getFlavorPriority());
        PeekHookHandler handler = PeekHookHandler.get();
        for (HoverFlavor flavor : handler.hoverFlavors()) {
            if (this.flavorList.contains(flavor)) continue;
            this.flavorList.add(flavor);
        }
        this.smartCheckBox.setSelected(this.options.isSmartEnabled());
        this.smartComboBox.setSelectedItem(this.options.getSmartActivator());
        this.smartShortcutLabel.setEnabled(this.options.isSmartEnabled());
        this.smartComboBox.setEnabled(this.options.isSmartEnabled());
        this.smartCheckedItems.addAll((Collection)this.options.getSmartActivator().getModifiers());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.options.setFlavorPriority(this.flavorList);
        this.options.setSmartEnabled(this.smartCheckBox.isSelected());
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.table instanceof GenericTable) {
            tableSettings = ((GenericTable)this.table).getPersistentSettings();
        }
        this.options = null;
    }

    public void apply(ApplyEvent event) {
    }

    public void cancel(ApplyEvent e) {
    }

    private void initializeComponent() {
        SimpleTableModel model = new SimpleTableModel(new ArrayList(), (SimpleTableFormat)new HoverTableFormat());
        TableBuilder builder = new TableBuilder();
        builder.setReorderable(true);
        builder.setModel((TableModel)model);
        builder.setSortable(false);
        builder.setAutoSizeColumns(false);
        BuiltTable builtTable = builder.build();
        this.flavorList = model.asList();
        this.table = builtTable.getTable();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(77);
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RolloverTableRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    label.setText(((HoverActivator)value).getDisplayName());
                }
                return label;
            }
        }));
        ComboBuilder shortCutComboBuilder = new ComboBuilder();
        shortCutComboBuilder.setModel((Object[])new HoverActivator.Modifier[]{HoverActivator.Modifier.OFF, HoverActivator.Modifier.SHIFT, HoverActivator.Modifier.CONTROL, HoverActivator.Modifier.ALT, HoverActivator.Modifier.META});
        final ListenableCollection checkedItems = shortCutComboBuilder.setCheckable(Collections.singleton(HoverActivator.Modifier.OFF), (CheckComboText)new ActivatorCheckText());
        BuiltCombo builtShortcutCombo = shortCutComboBuilder.build();
        JComboBox shortcutCombo = builtShortcutCombo.getJComboBox();
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(shortcutCombo){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                checkedItems.clear();
                HoverActivator activator = (HoverActivator)value;
                checkedItems.addAll((Collection)activator.getModifiers());
                return combo;
            }
        });
        if (tableSettings != null) {
            ((GenericTable)this.table).setPersistentSettings(tableSettings);
        }
        RichHintLabel hintLabel = new RichHintLabel();
        hintLabel.setHtmlText(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_HINT"));
        ComboBuilder comboBuilder = new ComboBuilder();
        comboBuilder.setModel((Object[])new HoverActivator.Modifier[]{HoverActivator.Modifier.SHIFT, HoverActivator.Modifier.CONTROL, HoverActivator.Modifier.ALT, HoverActivator.Modifier.META});
        this.smartCheckedItems = comboBuilder.setCheckable(null, (CheckComboText)new ActivatorCheckText());
        BuiltCombo builtCombo = comboBuilder.build();
        this.smartComboBox = builtCombo.getJComboBox();
        this.smartCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HoverOptionsPanel.this.smartShortcutLabel.setEnabled(HoverOptionsPanel.this.smartCheckBox.isSelected());
                HoverOptionsPanel.this.smartComboBox.setEnabled(HoverOptionsPanel.this.smartCheckBox.isSelected());
            }
        });
        this.smartCheckedItems.addListener((CollectionListener)new CollectionListener<HoverActivator.Modifier>(){

            public void collectionChanged(CollectionEvent<HoverActivator.Modifier> event) {
                EnumSet<HoverActivator.Modifier> modifiers = EnumSet.noneOf(HoverActivator.Modifier.class);
                for (HoverActivator.Modifier mod : HoverOptionsPanel.this.smartCheckedItems) {
                    modifiers.add(mod);
                }
                if (HoverOptionsPanel.this.smartCheckedItems.isEmpty()) {
                    modifiers.add(HoverActivator.Modifier.NONE);
                } else if (HoverOptionsPanel.this.smartCheckedItems.size() > 1) {
                    modifiers.remove(HoverActivator.Modifier.NONE);
                }
                HoverOptionsPanel.this.options.setSmartActivator(new HoverActivator(modifiers));
            }
        });
        RichHintLabel metaHintLabel = new RichHintLabel();
        metaHintLabel.setHtmlText(PeekBundle.get("PEEK_OPTIONS_PANEL_META_HINT"));
        this.setLayout((LayoutManager)new MigLayout("nogrid, ins 0, aligny top, gapy 0, fillx"));
        this.add(builtTable.getGUI(), "growx, growy 0, h 200, wrap");
        this.add((Component)hintLabel, "gaptop 12, gapbottom 4, growx, span, wrap");
        this.add(this.smartCheckBox, "split");
        this.smartCheckBox.setSelected(true);
        this.add(this.smartShortcutLabel, "gapleft 8");
        this.add(this.smartComboBox, "");
        this.add((Component)metaHintLabel, "newline, gaptop 12, growx, wrap, span");
    }

    private class HoverTableFormat
    implements SimpleTableFormat<HoverFlavor> {
        private HoverTableFormat() {
        }

        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_NAME");
                }
                case 1: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_SHORTCUT");
                }
                case 2: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_DESCRIPTION");
                }
                case 3: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_SMART");
                }
            }
            return "";
        }

        public Object getValueAt(HoverFlavor flavor, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return flavor.getName();
                }
                case 1: {
                    return HoverOptionsPanel.this.options.getFlavorActivator(flavor);
                }
                case 2: {
                    return flavor.getDescription();
                }
                case 3: {
                    return HoverOptionsPanel.this.options.isFlavorSmartEnabled(flavor);
                }
            }
            return "";
        }

        public void setValueAt(HoverFlavor flavor, Object value, int columnIndex) {
            if (columnIndex == 3) {
                HoverOptionsPanel.this.options.setFlavorSmartEnabled(flavor, (Boolean)value);
            } else if (columnIndex == 1) {
                if (value instanceof HoverActivator.Modifier) {
                    HoverOptionsPanel.this.options.setFlavorActivator(flavor, new HoverActivator(EnumSet.of((HoverActivator.Modifier)value)));
                } else if (value instanceof Object[]) {
                    EnumSet<HoverActivator.Modifier> checkedModifiers = EnumSet.noneOf(HoverActivator.Modifier.class);
                    for (Object o : (Object[])value) {
                        if (!(o instanceof HoverActivator.Modifier)) continue;
                        checkedModifiers.add((HoverActivator.Modifier)o);
                    }
                    HoverOptionsPanel.this.options.setFlavorActivator(flavor, new HoverActivator(checkedModifiers));
                } else {
                    HoverOptionsPanel.this.options.setFlavorActivator(flavor, new HoverActivator(EnumSet.of(HoverActivator.Modifier.OFF)));
                }
            }
        }

        public boolean isCellEditable(HoverFlavor flavor, int index) {
            return index == 1 || index == 3;
        }
    }

    private class ActivatorCheckText
    implements CheckComboText<HoverActivator.Modifier> {
        private ActivatorCheckText() {
        }

        public String getSummaryText(JCheckCombo combo, Collection<HoverActivator.Modifier> checkedItems) {
            return HoverActivator.getDisplayName(checkedItems);
        }

        public String getItemText(JCheckCombo combo, HoverActivator.Modifier checkedItem, int row) {
            return checkedItem.getDisplayName();
        }
    }
}

