/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.ideimpl.peek.HoverOptions;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.PlatformUtils;

public final class PeekHookHandler
extends HashStructureHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "hover");
    private Collection<HoverFlavor> hoverFlavors = new HashSet<HoverFlavor>();

    public PeekHookHandler() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                PeekHookHandler.this.addProviders(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                PeekHookHandler.this.addProviders(e.getNewElementHashStructure());
            }
        });
    }

    public static PeekHookHandler get() {
        return (PeekHookHandler)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<HoverFlavor> hoverFlavors() {
        return Collections.unmodifiableCollection(this.hoverFlavors);
    }

    private void addProviders(HashStructure ha) {
        if (ha == null) {
            return;
        }
        List flavors = ha.getAsList("flavor");
        for (Object o : flavors) {
            HashStructure hsFlavor = (HashStructure)o;
            String id = hsFlavor.getString("id");
            String name = hsFlavor.getString("name");
            String desc = hsFlavor.getString("description");
            String activator = hsFlavor.getString("activator");
            int priority = hsFlavor.getInt("priority", 100);
            boolean smartEnable = hsFlavor.getBoolean("smart-enabled", true);
            assert (id != null);
            assert (name != null);
            assert (desc != null);
            HoverActivator hoverActivator = activator == null ? new HoverActivator((String)null) : new HoverActivator(activator);
            List activatorOverrides = hsFlavor.getAsList("activator-override");
            if (activatorOverrides != null) {
                for (Object a : activatorOverrides) {
                    HashStructure hsActivator = (HashStructure)a;
                    String platform = hsActivator.getString("platform");
                    activator = hsActivator.getString("activator");
                    if (activator == null) continue;
                    if ("windows".equalsIgnoreCase(platform) && PlatformUtils.isWindows()) {
                        hoverActivator = new HoverActivator(activator);
                    }
                    if ("mac".equalsIgnoreCase(platform) && PlatformUtils.isMac()) {
                        hoverActivator = new HoverActivator(activator);
                    }
                    if (!"linux".equalsIgnoreCase(platform) || !PlatformUtils.isLinux()) continue;
                    hoverActivator = new HoverActivator(activator);
                }
            }
            this.hoverFlavors.add(new HoverFlavor(id, name, desc, hoverActivator, priority, smartEnable));
        }
        this.updateOptions();
    }

    private void updateOptions() {
        Collection<HoverFlavor> flavors = PeekHookHandler.get().hoverFlavors();
        HoverOptions hoverOptions = HoverOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        ArrayList<HoverFlavor> optionFlavors = new ArrayList<HoverFlavor>(hoverOptions.getFlavorPriority());
        for (HoverFlavor flavor : flavors) {
            HoverFlavor optionFlavor;
            if (optionFlavors.contains(flavor)) continue;
            int i = optionFlavors.size();
            while (--i >= 0 && (optionFlavor = (HoverFlavor)optionFlavors.get(i)).getDefaultPriority() >= flavor.getDefaultPriority()) {
            }
            optionFlavors.add(i + 1, flavor);
            hoverOptions.setFlavorActivator(flavor, flavor.getDefaultHoverActivator());
            hoverOptions.setFlavorSmartEnabled(flavor, flavor.isDefaultSmartEnable());
        }
        hoverOptions.setFlavorPriority(optionFlavors);
    }

    public HoverFlavor getFlavor(String id) {
        for (HoverFlavor flavor : this.hoverFlavors) {
            if (!flavor.getId().equals(id)) continue;
            return flavor;
        }
        return null;
    }
}

