/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.browse;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;

final class JavaBrowseNavigationPoint
extends CodeNavigationPoint {
    private JavaHasType result;
    private JavaManager provider;
    private boolean flag_nooffset;

    JavaBrowseNavigationPoint(Context context, int start, JavaHasType result, JavaManager provider) {
        super(context, start, 0);
        this.result = result;
        this.provider = provider;
        if (start == -1) {
            this.flag_nooffset = true;
        }
    }

    private JavaBrowseNavigationPoint() {
    }

    public Object copyTo(Object target) {
        JavaBrowseNavigationPoint point = target != null ? (JavaBrowseNavigationPoint)((Object)target) : new JavaBrowseNavigationPoint();
        this.copyToImpl(point);
        return point;
    }

    protected final void copyToImpl(JavaBrowseNavigationPoint point) {
        super.copyToImpl((CodeNavigationPoint)point);
        point.result = this.result;
        point.provider = this.provider;
        point.flag_nooffset = this.flag_nooffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int navigateImpl() throws Exception {
        try {
            Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(this.getContext());
            if (editor == null) {
                int n = 1;
                return n;
            }
            if (editor instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)editor;
                codeEditor.setSelectionEnd(0);
                Context ctx = codeEditor.getContext();
                Node node = ctx.getNode();
                Project prj = ctx.getProject();
                Workspace wsp = ctx.getWorkspace();
                this.nodeURL = node != null ? node.getURL() : null;
                this.prjURL = prj != null ? prj.getURL() : null;
                this.wspURL = wsp != null ? wsp.getURL() : null;
                this.viewClass = codeEditor.getClass();
                this.viewID = codeEditor.getId();
                if (this.flag_nooffset) {
                    TextNode textNode = (TextNode)node;
                    textNode.acquireTextBuffer();
                    try {
                        URL url = textNode.getURL();
                        this.start = JavaBrowseNavigationPoint.helper(url, this.result, this.provider);
                    }
                    finally {
                        textNode.releaseTextBuffer();
                    }
                }
                if (this.start != -1) {
                    codeEditor.gotoOffset(this.start, 0);
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.result = null;
            this.provider = null;
            this.done = true;
        }
    }

    private static int helper(URL url, JavaHasType input, JavaManager provider) {
        SourceHasName hasName;
        SourceName name;
        SourceFile file = provider.getSourceFile(url);
        SourceElement sourceElement = CommonUtilities.getSourceElement((JavaElement)input, (SourceFile)file);
        if (sourceElement == null) {
            return -1;
        }
        if (sourceElement instanceof SourceHasName && (name = (hasName = (SourceHasName)sourceElement).getNameElement()) != null) {
            return name.getStartOffset();
        }
        return sourceElement.getStartOffset();
    }
}

