/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.builder.InterfaceSelectionPanel;
import oracle.jdeveloper.builder.cls.AbstractGenerator;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdevimpl.java.JavaHelper;
import oracle.jdevimpl.java.util.CodeGenUtil;

public class ClassGenerator
extends AbstractGenerator {
    private JPanel attributes;
    private JRadioButton publicRadio;
    private JRadioButton packageRadio;
    private JCheckBox mainCheck;
    private JCheckBox superCtorsCheck;
    private JCheckBox abstractMethodCheck;
    private InterfaceSelectionPanel interfaceSelector;
    private JRadioButton abstractRadio;
    private JRadioButton finalRadio;
    private JRadioButton noneRadio;

    @Override
    public JComponent getAttributes(String baseType) {
        if (this.attributes == null) {
            this.interfaceSelector = new InterfaceSelectionPanel(this.getProject());
            this.interfaceSelector.setInitialSearchString("");
            this.publicRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.publicRadio, (String)BuilderArb.getString(11));
            this.packageRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.packageRadio, (String)BuilderArb.getString(150));
            this.noneRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.noneRadio, (String)BuilderArb.getString(151));
            this.abstractRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.abstractRadio, (String)BuilderArb.getString(152));
            this.abstractRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ClassGenerator.this.abstractMethodCheck != null) {
                        ClassGenerator.this.abstractMethodCheck.setEnabled(!ClassGenerator.this.abstractRadio.isSelected());
                    }
                }
            });
            this.finalRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.finalRadio, (String)BuilderArb.getString(153));
            this.superCtorsCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.superCtorsCheck, (String)BuilderArb.getString(155));
            this.abstractMethodCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.abstractMethodCheck, (String)BuilderArb.getString(154));
            this.mainCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.mainCheck, (String)BuilderArb.getString(15));
            ButtonGroup accessGroup = new ButtonGroup();
            accessGroup.add(this.publicRadio);
            accessGroup.add(this.packageRadio);
            this.publicRadio.setSelected(true);
            ButtonGroup modsGroup = new ButtonGroup();
            modsGroup.add(this.noneRadio);
            modsGroup.add(this.abstractRadio);
            modsGroup.add(this.finalRadio);
            this.noneRadio.setSelected(true);
            this.superCtorsCheck.setSelected(true);
            this.mainCheck.setSelected(false);
            this.abstractMethodCheck.setSelected(true);
            JPanel accessPanel = new JPanel(new GridBagLayout());
            accessPanel.setBorder(BorderFactory.createTitledBorder(BuilderArb.getString(148)));
            JPanel otherModsPanel = new JPanel(new GridBagLayout());
            otherModsPanel.setBorder(BorderFactory.createTitledBorder(BuilderArb.getString(149)));
            this.attributes = new JPanel(new GridBagLayout());
            int y = -1;
            accessPanel.add((Component)this.publicRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 6, 0, 6), 0, 0));
            accessPanel.add((Component)this.packageRadio, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 6, 0, 6), 0, 0));
            otherModsPanel.add((Component)this.noneRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 6, 0, 6), 0, 0));
            otherModsPanel.add((Component)this.abstractRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 6, 0, 6), 0, 0));
            otherModsPanel.add((Component)this.finalRadio, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 6, 6, 6), 0, 0));
            this.attributes.add((Component)this.interfaceSelector, new GridBagConstraints(0, y, 2, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 7, 0), 0, 0));
            this.attributes.add((Component)accessPanel, new GridBagConstraints(0, y, 1, 1, 0.4, 0.0, 18, 1, new Insets(0, 0, 8, 5), 0, 0));
            this.attributes.add((Component)otherModsPanel, new GridBagConstraints(1, y, 1, 1, 0.8, 0.0, 18, 2, new Insets(0, 0, 8, 0), 0, 0));
            this.attributes.add((Component)this.superCtorsCheck, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.attributes.add((Component)this.abstractMethodCheck, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 18, 0, new Insets(1, 0, 0, 0), 0, 0));
            this.attributes.add((Component)this.mainCheck, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 18, 0, new Insets(1, 0, 0, 0), 0, 0));
        }
        return this.attributes;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ClassGenerator.enableTree(this.attributes, isEnabled);
    }

    @Override
    protected void addDetails(JavaManager mgr, SourceFile file, SourceClass cls) {
        this.maybeAddConstructorsFromSuper(cls);
        this.maybeAddMainMethod(cls);
        this.setModifiers(cls);
        this.maybeAddInterfaces(cls);
        this.maybeImplementAbstractMethods(cls);
    }

    private void setModifiers(SourceClass cls) {
        int mods = cls.getModifiers();
        mods = this.isPublicClass() ? (mods |= 1) : (mods &= 0xFFFFFFFE);
        if (this.isAbstract()) {
            mods |= 0x400;
        } else {
            mods &= 0xFFFFFBFF;
            mods = this.isFinal() ? (mods |= 0x10) : (mods &= 0xFFFFFFEF);
        }
        cls.setModifiers(mods);
    }

    private void maybeAddConstructorsFromSuper(SourceClass cls) {
        if (this.isGenerateConstructorsFromSuper()) {
            int mods = cls.getModifiers();
            int modifier = this.isPublicClass() ? mods | 1 : mods & 0xFFFFFFFE;
            JavaType javaType = cls.getSuperclass();
            List<JavaMethod> constructors = this.getConstructors(javaType);
            for (JavaMethod ctor : constructors) {
                SourceMethod addConstructor = SourceUtils.addConstructor((SourceClass)cls, (int)modifier);
                Set<String> params = this.maybeAddMethodParameters(ctor, addConstructor);
                Set<String> exceptions = this.maybeAddMethodExceptions(ctor, addConstructor);
                String[] paramNames = params.toArray(new String[params.size()]);
                SourceBlock body = addConstructor.getBlock();
                for (String except : exceptions) {
                    SourceUtils.addThrows((SourceMethod)addConstructor, (String)except);
                }
                SourceUtils.addMethodCallStatement((SourceBlock)body, (String)"", (String)"super", (String[])paramNames);
            }
        }
    }

    private List<JavaMethod> getConstructors(JavaType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>();
        Collection constructors = type.getDeclaredConstructors();
        if (constructors.size() > 0) {
            for (JavaMethod m : constructors) {
                if (m.isPrivate() || m.isDeprecated() || m.isSynthetic()) continue;
                list.add(m);
            }
        }
        return list;
    }

    private void maybeAddInterfaces(SourceClass cls) {
        List<String> interfaces = this.getInterfaces();
        if (!interfaces.isEmpty()) {
            for (String iface : interfaces) {
                SourceUtils.addSuperInterface((SourceClass)cls, (String)iface);
            }
        }
    }

    private void maybeAddMainMethod(SourceClass cls) {
        if (this.isMain()) {
            SourceMethod main = SourceUtils.addMainMethod((SourceClass)cls);
            if (!this.isAbstract()) {
                String clsName = JotNames.getShortClassName(cls.getName());
                String varName = clsName.substring(0, 1).toLowerCase() + clsName.substring(1);
                String initText = "new " + clsName + "()";
                SourceBlock block = main.getBlock();
                SourceUtils.addLocalVariableDeclaration((SourceBlock)block, (String)clsName, (String)varName, (String)initText);
            }
        }
    }

    private void maybeImplementAbstractMethods(SourceClass cls) {
        Collection<JavaMethod> methods;
        if (!this.isAbstract() && this.isImplementAbstractMethods() && !(methods = JavaHelper.getUnimplementedMethods(cls)).isEmpty()) {
            for (JavaMethod toImplement : methods) {
                int mods = toImplement.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF;
                CodeGenUtil.implementMethod(toImplement, cls, mods, false, true, null, false);
            }
        }
    }

    private Set<String> maybeAddMethodParameters(JavaMethod sourceMethod, SourceMethod tagetMethod) {
        JavaType[] javaTypes;
        if (sourceMethod.getParameters().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> usedNames = new LinkedHashSet<String>();
        for (JavaType type : javaTypes = CommonUtilities.getParameterTypes((JavaMethod)sourceMethod)) {
            String paramName = JavaHelper.getParameterName(null, (JavaHasType)type, usedNames);
            String paramType = type.getResolvedType().getQualifiedName();
            SourceUtils.addMethodParameter((SourceMethod)tagetMethod, (String)paramType, (String)paramName);
            usedNames.add(paramName);
        }
        return usedNames;
    }

    private Set<String> maybeAddMethodExceptions(JavaMethod sourceMethod, SourceMethod tagetMethod) {
        if (sourceMethod.getExceptions().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection exceptions = sourceMethod.getExceptions();
        LinkedHashSet<String> exceptionTypes = new LinkedHashSet<String>(sourceMethod.getExceptions().size());
        for (JavaType jt : exceptions) {
            exceptionTypes.add(jt.getQualifiedName());
        }
        return exceptionTypes;
    }

    boolean isMain() {
        return this.mainCheck != null && this.mainCheck.isSelected();
    }

    @Deprecated
    boolean isDefaultConstructor() {
        return this.isGenerateConstructorsFromSuper();
    }

    boolean isGenerateConstructorsFromSuper() {
        return this.superCtorsCheck != null && this.superCtorsCheck.isSelected();
    }

    boolean isPublicClass() {
        return this.publicRadio != null && this.publicRadio.isSelected() || this.packageRadio != null && !this.packageRadio.isSelected();
    }

    boolean isFinal() {
        return this.finalRadio != null && this.finalRadio.isSelected();
    }

    boolean isAbstract() {
        return !this.isFinal() && this.abstractRadio != null && this.abstractRadio.isSelected();
    }

    boolean isImplementAbstractMethods() {
        return this.abstractMethodCheck == null || this.abstractMethodCheck.isSelected();
    }

    List<String> getInterfaces() {
        return this.interfaceSelector.getInterfaces();
    }
}

