/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.folder;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ViewSupport;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.resource.GalleryArb;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.folder.FolderSourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;

public class EmptyFolderBuilderModel
extends FileBuilderModel {
    public EmptyFolderBuilderModel(Context context) {
        super(context);
    }

    @Override
    public String getFileType() {
        return GalleryArb.getString((int)29);
    }

    @Override
    public String getBuilderType() {
        return "Folder";
    }

    @Override
    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            URL url;
            if (node != null && !URLFileSystem.exists((URL)(url = node.getURL()))) {
                try {
                    URLFileSystem.openOutputStream((URL)url).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getFileContents() {
        return BuilderArb.getString(185);
    }

    @Override
    protected String getBaseName() {
        return "folder";
    }

    @Override
    protected String getDefaultRelativeDirectory(Project project) {
        return "";
    }

    @Override
    protected void initializeSourceDir(Context ctx) {
        Context context = new Context(ctx);
        if (ctx != null && ctx.getElement() == null) {
            if (ctx.getNode() != null) {
                context.setElement((Element)ctx.getNode());
            } else if (ctx.getProject() != null) {
                context.setElement((Element)ctx.getProject());
            }
        }
        super.initializeSourceDir(context);
    }

    @Override
    protected SourceModel createSourceModel() {
        return new FolderSourceModel();
    }

    @Override
    public boolean isRaiseEditor() {
        return false;
    }

    @Override
    public boolean shouldAcquireTextBuffer() {
        return !ViewSupport.isDirectoryView() && !ContentLevel.showsEmptyFolders();
    }

    @Override
    protected void postProcess(Node node) {
        if (ViewSupport.isDirectoryView() || ContentLevel.showsEmptyFolders()) {
            VirtualFileSystemHelper.invalidateDirectoryTree((URL)node.getURL());
            UpdateMessage.fireStructureChanged((Subject)Ide.getActiveProject(), Collections.singletonList(node));
            Context context = Context.newIdeContext();
            context.setSelection(new Element[]{node});
            context.setElement((Element)node);
            context.setNode(node);
            context.setBoolean("oracle.ide.model.ProjectContent.AutoSelecter", true);
            NavigatorWindow.openContextInLastActiveNavigator((Context)context);
        }
    }
}

