/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.iface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.AbstractSimpleTypeBuilderPanel;
import oracle.jdeveloper.builder.EmptyFieldWatcher;
import oracle.jdeveloper.builder.InterfaceSelectionPanel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.iface.InterfaceBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public final class InterfaceBuilderPanel
extends JPanel
implements BaliWizardPanel {
    private final BasicPanel _basicsPanel = new BasicPanel();
    private final InterfaceSelectionPanel _implementsPanel = new InterfaceSelectionPanel();
    private final JRadioButton packageAccessRadio = new JRadioButton();
    private final JRadioButton publicAccessRadio = new JRadioButton();
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    public InterfaceBuilderPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeFromState(BaliWizardState wizardState) {
        this._basicsPanel.initializeFromState(wizardState);
        InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
        this._implementsPanel.setProject(state.getProject());
    }

    public boolean validateAndWriteToState(BaliWizardState wizardState) {
        if (!this._basicsPanel.validateAndWriteToState(wizardState)) {
            return false;
        }
        InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
        state.setSuperInterfaces(this._implementsPanel.getInterfaces());
        state.setPublic(this.publicAccessRadio.isSelected());
        return true;
    }

    private void jbInit() throws Exception {
        this._implementsPanel.setListLabel(BuilderArb.getString(159));
        this._implementsPanel.setInitialSearchString("");
        ResourceUtils.resButton((AbstractButton)this.publicAccessRadio, (String)BuilderArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this.packageAccessRadio, (String)BuilderArb.getString(150));
        ButtonGroup group = new ButtonGroup();
        group.add(this.publicAccessRadio);
        group.add(this.packageAccessRadio);
        this.publicAccessRadio.setSelected(true);
        JPanel accessModifiersPanel = new JPanel();
        accessModifiersPanel.setLayout(new GridBagLayout());
        accessModifiersPanel.setBorder(BorderFactory.createTitledBorder(BuilderArb.getString(148)));
        accessModifiersPanel.add((Component)this.publicAccessRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 0, 0), 0, 0));
        accessModifiersPanel.add((Component)this.packageAccessRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 6, 6, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 8));
        this.add((Component)this._basicsPanel, "North");
        this.add((Component)this._implementsPanel, "Center");
        this.add((Component)accessModifiersPanel, "South");
    }

    public String getPackageName() {
        return this._basicsPanel.getPackageName();
    }

    private static class BasicPanel
    extends AbstractSimpleTypeBuilderPanel {
        private BasicPanel() {
            this.setPackageLabel(BuilderArb.getString(8));
            this.setNameLabel(BuilderArb.getString(7));
        }

        public void initializeFromState(BaliWizardState wizardState) {
            InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
            this._pkgPopup.setProject(state.getProject());
            this._pkgPopup.setText(state.getPackage());
            this._nameField.setText(state.getClassName());
            JEWTDialog builderDialog = state.getBuilderDialog();
            builderDialog.setInitialFocus((Component)this._nameField);
            this._nameField.getDocument().addDocumentListener(new EmptyFieldWatcher(builderDialog));
        }

        public boolean validateAndWriteToState(BaliWizardState wizardState) {
            String clsName;
            InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
            boolean result = false;
            String pkgName = this._pkgPopup.getText();
            if (pkgName != null) {
                pkgName = pkgName.trim();
            }
            if ((clsName = this._nameField.getText()) != null) {
                clsName = clsName.trim();
            }
            try {
                state.setPackage(pkgName);
                state.setClassName(clsName);
                result = true;
            }
            catch (ClassBuilderModel.IllegalPackageNameException ex) {
                state.reportError(BuilderArb.getString(30), BuilderArb.format(178, pkgName), "f1_idedclassnameinvalid_html");
                this._pkgPopup.requestFocus();
            }
            catch (ClassBuilderModel.IllegalClassNameException ex) {
                state.reportError(BuilderArb.getString(141), BuilderArb.format(180, this._getDisplayName(clsName, false)), "f1_idedclassnameinvalid_html");
                this._nameField.requestFocus();
            }
            catch (ClassBuilderModel.DuplicateClassException ex) {
                this._nameField.requestFocus();
            }
            catch (ClassBuilderModel.InvalidFileException ex) {
                state.reportError(BuilderArb.getString(23), BuilderArb.format(137, this._getDisplayName(ex.getPath(), true)), null);
            }
            catch (ClassBuilderModel.UserCancelledFileException ex) {
                this._nameField.requestFocus();
            }
            return result;
        }

        private String getPackageName() {
            return this._pkgPopup.getPackage();
        }

        private String _getDisplayName(String name, boolean shortenInMiddle) {
            String result = name;
            if (name.length() > FILENAME_DISPLAY_MAX_LENGTH) {
                result = shortenInMiddle ? BuilderArb.format(136, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), name.substring(name.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(135, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
            }
            return result;
        }
    }
}

