/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.NewProjectPanel;

public class NewEmptyProjectCommand
extends Command {
    private static List initializers;
    public static final String WORKSPACE_PACKAGE_COUNTER_PROPERTY = "packageCounter";

    public NewEmptyProjectCommand() {
        super(3);
    }

    public final int doit() throws Exception {
        final Context ctx = this.getContext();
        Assert.check((ctx != null && ctx.getWorkspace() != null ? 1 : 0) != 0);
        final NewProjectPanel newProjectPanel = new NewProjectPanel();
        newProjectPanel.setContext(ctx);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        URL projURL = newProjectPanel.getFileURL(false);
                        if (projURL == null) break block5;
                        try {
                            Workspace wksp = ctx.getWorkspace();
                            Project newProj = NewEmptyProjectCommand.createProjectInWorkspace(projURL, wksp);
                            if (newProj != null) {
                                newProj.save();
                                ctx.setProject(newProj);
                            }
                        }
                        catch (Exception e) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)newProjectPanel), (Throwable)e, (String)("An error occured creating the project " + URLFileSystem.getPlatformPathName((URL)projURL)));
                        }
                    }
                    catch (TraversalException e) {
                        e.showMessageDialog((Component)((Object)newProjectPanel));
                    }
                }
            }
        };
        URL projectURL = newProjectPanel.getProjectURL(runnable);
        if (projectURL == null) {
            return 1;
        }
        return 0;
    }

    public static Project createProjectInWorkspace(URL projectURL, Workspace workspace) throws IllegalAccessException, InstantiationException {
        return NewEmptyProjectCommand.createProjectInWorkspace(projectURL, workspace, null);
    }

    public static Project createProjectInWorkspace(URL projectURL, Workspace workspace, String defaultPackage) throws IllegalAccessException, InstantiationException {
        Project origProj = (Project)NodeFactory.find((URL)projectURL);
        Project newProject = NewEmptyProjectCommand.createProject(projectURL);
        if (newProject != null) {
            NewEmptyProjectCommand.initializeProjectSettings(newProject, workspace, defaultPackage);
            if (origProj != null) {
                try {
                    origProj.close();
                    NewEmptyProjectCommand.setPackage(newProject, defaultPackage, workspace);
                    newProject.save();
                    newProject.close();
                    origProj.open();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                newProject = origProj;
                NodeFactory.recache((URL)projectURL, (URL)projectURL, (Node)newProject);
            } else {
                try {
                    newProject.open();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (workspace != null) {
                workspace.add((Element)newProject, true);
            }
        } else {
            NewEmptyProjectCommand._showError(projectURL);
        }
        return newProject;
    }

    public static void initializeProjectSettings(Project project, final Workspace workspace, final String defaultPackage) {
        final Project final_newProject = project;
        project.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                BuildSystemConfiguration buildConfig = BuildSystemConfiguration.getInstance((PropertyStorage)final_newProject);
                if (buildConfig != null) {
                    buildConfig.setCurrentEncoding(IdeUtil.getIdeEncoding());
                    buildConfig.setCurrentWebIanaEncoding(IdeUtil.getIdeIanaEncoding());
                }
                ProjectContent.initializeContentSets((Project)final_newProject);
                ProjectVersion.initializeVersions((PropertyStorage)final_newProject, (String)ProjectMigrator.MIGRATOR_NAME);
                NewEmptyProjectCommand.initializeProject(final_newProject, workspace);
                NewEmptyProjectCommand.setPackage(final_newProject, defaultPackage, workspace);
            }
        });
    }

    public static Project createProject(URL projectURL) throws IllegalAccessException, InstantiationException {
        Project newProject;
        Project defProject = Ide.getDefaultProject();
        if (defProject != null) {
            if (defProject.isDirty()) {
                try {
                    defProject.save();
                }
                catch (IOException ex) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    if (mainWindow != null) {
                        ExceptionDialog.showExceptionDialog((Window)mainWindow, (Exception)ex);
                    }
                    throw new InstantiationException();
                }
            }
            newProject = (Project)NodeFactory.clone((Node)defProject, (URL)projectURL);
        } else {
            newProject = (Project)NodeFactory.findOrCreate(Project.class, (URL)projectURL);
        }
        return newProject;
    }

    public static String getProjectPackage(Workspace workspace) {
        ApplicationContent content = ApplicationContent.getInstance((Workspace)workspace);
        String appPackagePrefix = content.getAppPackagePrefix();
        Project defProject = Ide.getDefaultProject();
        String pkgName = defProject != null ? JavaProject.getInstance(defProject).getDefaultPackage() : ModelArb.getString((int)4);
        return appPackagePrefix != null && appPackagePrefix.length() > 0 ? appPackagePrefix + '.' + pkgName : pkgName;
    }

    public static void setProjectPackage(String pkgName, Project newProject, Workspace wksp) {
        if (pkgName == null) {
            pkgName = "";
        }
        newProject.getProperties().putString("defaultPackage", pkgName);
        JavaProject.getInstance(newProject).setMostRecentPackage(pkgName);
    }

    public static synchronized void registerProjectInitializer(ProjectInitializer init) {
        if (initializers == null) {
            initializers = new ArrayList();
        }
        if (!initializers.contains(init)) {
            initializers.add(init);
        }
    }

    public static synchronized void unregisterProjectInitializer(ProjectInitializer init) {
        if (initializers != null) {
            initializers.remove(init);
        }
    }

    private static void _showError(URL projectURL) {
        String fileName = URLFileSystem.getPlatformPathName((URL)projectURL);
        if (fileName.length() > 80) {
            fileName = ComponentArb.format((int)33, (Object)StringUtil.truncateFileNameForMessage((String)fileName));
        }
        String msg = ComponentArb.format((int)37, (Object)WizardsArb.getString((int)5), (Object)fileName);
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            MessageDialog.error((Component)mainWindow, (Object)msg, (String)ComponentArb.getString((int)36), null);
        } else {
            System.err.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeProject(Project proj, Workspace workspace) {
        ProjectInitializer[] inits = null;
        Class<NewEmptyProjectCommand> clazz = NewEmptyProjectCommand.class;
        synchronized (NewEmptyProjectCommand.class) {
            if (initializers != null) {
                inits = initializers.toArray(new ProjectInitializer[initializers.size()]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (inits != null) {
                for (int i = 0; i < inits.length; ++i) {
                    inits[i].initializeProject(proj, workspace);
                }
            }
            return;
        }
    }

    private static void setPackage(Project project, String packageName, Workspace workspace) {
        String pkg = null;
        if (packageName != null) {
            pkg = packageName;
        } else if (workspace != null) {
            ApplicationContent content = ApplicationContent.getInstance((Workspace)workspace);
            pkg = content.getAppPackagePrefix();
        }
        if (pkg == null) {
            pkg = JavaProject.generateDefaultPackageName(project);
        }
        NewEmptyProjectCommand.setProjectPackage(pkg, project, workspace);
    }

    public static interface ProjectInitializer {
        public void initializeProject(Project var1, Workspace var2);
    }
}

