/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.ui.GraphicsUtils;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.compiler.CompilerOptionManager;

public class BuildSystemConfiguration
extends HashStructureAdapter {
    private static final String COPY_FILES_NO_EXTENSION = "copyFilesNoExtension";
    private static String[] defaultCopyRes;
    private PropertyStorage project;

    private BuildSystemConfiguration(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.project = project;
    }

    public static BuildSystemConfiguration getInstance(PropertyStorage project) {
        return new BuildSystemConfiguration(BuildSystemConfiguration.findOrCreate((PropertyStorage)project, (String)OjcConfiguration.DATA_KEY), project);
    }

    public boolean isJDK12OrHigher() {
        return this.getShortJdkVersion().compareTo("1.2") >= 0;
    }

    public boolean isJDK13OrHigher() {
        return this.getShortJdkVersion().compareTo("1.3") >= 0;
    }

    public boolean isJDK14OrHigher() {
        return this.getShortJdkVersion().compareTo("1.4") >= 0;
    }

    public boolean isJDK15() {
        return this.getShortJdkVersion().startsWith("1.5");
    }

    public boolean isJDK15OrHigher() {
        return this.getShortJdkVersion().compareTo("1.5") >= 0;
    }

    public boolean isJDK16() {
        return this.getShortJdkVersion().startsWith("1.6");
    }

    public boolean isJDK16OrHigher() {
        return this.getShortJdkVersion().compareTo("1.6") >= 0;
    }

    public boolean isJDK17() {
        return this.getShortJdkVersion().startsWith("1.7");
    }

    public boolean isJDK17OrHigher() {
        return this.getShortJdkVersion().compareTo("1.7") >= 0;
    }

    public boolean isJDK18() {
        return this.getShortJdkVersion().startsWith("1.8");
    }

    public boolean isJDK18OrHigher() {
        return this.getShortJdkVersion().compareTo("1.8") >= 0;
    }

    private String getFullJdkVersion() {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)this.project);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver.toString();
        }
        return "1.1";
    }

    private String getShortJdkVersion() {
        String fullJdkVersion;
        String jdkVersion = fullJdkVersion = this.getFullJdkVersion();
        int index = fullJdkVersion.indexOf(46);
        if (index > 0) {
            if (index == 1 && fullJdkVersion.charAt(0) == '1') {
                if ((index = fullJdkVersion.indexOf(46, index + 1)) > 0) {
                    jdkVersion = fullJdkVersion.substring(0, index);
                }
            } else {
                jdkVersion = fullJdkVersion.substring(0, index);
            }
        }
        if ((index = jdkVersion.indexOf(95)) > 0) {
            jdkVersion = jdkVersion.substring(0, index);
        }
        return jdkVersion;
    }

    public String[] getTargets() {
        String v = this.getShortJdkVersion();
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_TARGETS[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_TARGETS.length; ++i) {
            if (OjcConfiguration.DEFAULT_TARGETS[i].compareTo(v) > 0) continue;
            result.add(OjcConfiguration.DEFAULT_TARGETS[i]);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public String getTargetString() {
        String target = this._hash.getString("target");
        if (target == null) {
            String source = this._hash.getString("source");
            target = source == null ? "Default" : source;
        }
        return target;
    }

    public String getTarget() {
        String target = this.getTargetString();
        String jdkVersion = this.getShortJdkVersion();
        if (target.equals("Default") || this.isHigherVersion(target, jdkVersion)) {
            target = jdkVersion.compareTo("1.5") >= 0 ? jdkVersion : (jdkVersion.compareTo("1.2") >= 0 ? "1.2" : "1.1");
        }
        return target;
    }

    public void setTarget(String target) {
        if (target != null) {
            this._hash.putString("target", target);
        } else {
            this._hash.remove("target");
        }
    }

    public String[] getSources() {
        String v = this.getShortJdkVersion();
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_SOURCES[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_SOURCES.length; ++i) {
            if (OjcConfiguration.DEFAULT_SOURCES[i].compareTo(v) > 0) continue;
            result.add(OjcConfiguration.DEFAULT_SOURCES[i]);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public String getSourceString() {
        String source = this._hash.getString("source");
        if (source == null) {
            String target = this._hash.getString("target");
            source = target == null ? "Default" : target;
        }
        return source;
    }

    public String getSource() {
        String source = this.getSourceString();
        String jdkVersion = this.getShortJdkVersion();
        if (source.equals("Default") || this.isHigherVersion(source, jdkVersion)) {
            source = jdkVersion.compareTo("1.5") >= 0 ? jdkVersion : (jdkVersion.compareTo("1.4") == 0 ? "1.3" : jdkVersion);
        }
        return source;
    }

    public void setSource(String source) {
        if (source != null) {
            this._hash.putString("source", source);
        } else {
            this._hash.remove("source");
        }
    }

    private boolean isHigherVersion(String otherVersion, String jdkVersion) {
        if (jdkVersion.startsWith("1.") && otherVersion.startsWith("1.")) {
            return jdkVersion.compareTo(otherVersion) < 0;
        }
        if (jdkVersion.startsWith("1.")) {
            return jdkVersion.substring(2).compareTo(otherVersion) < 0;
        }
        if (otherVersion.startsWith("1.")) {
            return jdkVersion.compareTo(otherVersion.substring(2)) < 0;
        }
        return jdkVersion.compareTo(otherVersion) < 0;
    }

    public JdkVersion getSourceJdkVersion() {
        String source = this.getSource();
        if ("1.3".equals(source)) {
            return JdkVersion.JDK_1_3;
        }
        if ("1.4".equals(source)) {
            return JdkVersion.JDK_1_4;
        }
        if ("1.5".equals(source)) {
            return JdkVersion.JDK_1_5;
        }
        if ("1.6".equals(source)) {
            return JdkVersion.JDK_1_6;
        }
        if ("1.7".equals(source)) {
            return JdkVersion.JDK_1_7;
        }
        if ("1.8".equals(source)) {
            return JdkVersion.JDK_1_8;
        }
        return JavaParser.getJdkVersion();
    }

    public synchronized String[] getCopyRes() {
        ListStructure list = this._hash.getListStructure("copyRes");
        if (list != null) {
            return (String[])list.toArray((Object[])new String[list.size()]);
        }
        if (defaultCopyRes == null) {
            HashSet<String> extensionList = new HashSet<String>();
            String[] imageExtensions = GraphicsUtils.getImageExtensions();
            for (int i = 0; i < imageExtensions.length; ++i) {
                extensionList.add(imageExtensions[i]);
            }
            extensionList.add(".properties");
            extensionList.add(".xml");
            extensionList.add(".ejx");
            extensionList.add(".xcfg");
            extensionList.add(".cpx");
            extensionList.add(".dcx");
            extensionList.add(".sva");
            extensionList.add(".wsdl");
            extensionList.add(".ini");
            extensionList.add(".tld");
            extensionList.add(".tag");
            extensionList.add(".xlf");
            extensionList.add(".xsl");
            extensionList.add(".xsd");
            defaultCopyRes = extensionList.toArray(new String[extensionList.size()]);
            Arrays.sort(defaultCopyRes);
        }
        return defaultCopyRes;
    }

    public synchronized boolean addCopyResExtension(String extension) {
        if (extension == null) {
            return false;
        }
        if ((extension = extension.trim()).length() < 2 || extension.charAt(0) != '.') {
            return false;
        }
        String[] copyRes = this.getCopyRes();
        String[] newCopyRes = new String[copyRes.length + 1];
        int insertIndex = 0;
        int x = 0;
        while (x < copyRes.length) {
            int comparison = extension.compareTo(copyRes[x]);
            if (comparison == 0) {
                return false;
            }
            if (x == insertIndex && comparison < 0) {
                newCopyRes[insertIndex++] = extension;
            }
            newCopyRes[insertIndex] = copyRes[x];
            ++x;
            ++insertIndex;
        }
        if (insertIndex < newCopyRes.length) {
            newCopyRes[insertIndex] = extension;
        }
        this.setCopyRes(newCopyRes);
        return true;
    }

    public synchronized boolean removeCopyResExtension(String extension) {
        if (extension == null) {
            return false;
        }
        if ((extension = extension.trim()).length() < 2 || extension.charAt(0) != '.') {
            return false;
        }
        String[] copyRes = this.getCopyRes();
        if (copyRes.length == 0) {
            return false;
        }
        String[] newCopyRes = new String[copyRes.length - 1];
        int insertIndex = 0;
        for (int x = 0; x < copyRes.length; ++x) {
            if (extension.equals(copyRes[x])) continue;
            if (insertIndex >= newCopyRes.length) {
                return false;
            }
            newCopyRes[insertIndex++] = copyRes[x];
        }
        this.setCopyRes(newCopyRes);
        return true;
    }

    public synchronized void setCopyRes(String[] copyRes) {
        if (copyRes == null) {
            this._hash.remove("copyRes");
        } else {
            ListStructure list = this._hash.getOrCreateListStructure("copyRes");
            list.mirror(Arrays.asList(copyRes));
        }
    }

    public boolean getReverseCopyRes() {
        return this._hash.getBoolean("reverseCopyRes", false);
    }

    public void setReverseCopyRes(boolean reverseCopyRes) {
        this._hash.putBoolean("reverseCopyRes", reverseCopyRes);
    }

    public boolean getCopyFilesNoExtension() {
        return this._hash.getBoolean(COPY_FILES_NO_EXTENSION, false);
    }

    public void setCopyFilesNoExtension(boolean copyFilesNoExtension) {
        this._hash.putBoolean(COPY_FILES_NO_EXTENSION, copyFilesNoExtension);
    }

    public String getCurrentEncoding() {
        String currentEncoding = this.getInternalEncoding();
        return currentEncoding == null || "Default".equals(currentEncoding) ? Encodings.getDefaultEncoding() : currentEncoding;
    }

    public void setCurrentEncoding(String currentEncoding) {
        if (currentEncoding == null) {
            currentEncoding = "Default";
        }
        this.setInternalEncoding(currentEncoding);
    }

    private String getInternalEncoding() {
        return this._hash.getString("internalEncoding", "Default");
    }

    private void setInternalEncoding(String encoding) {
        this._hash.putString("internalEncoding", encoding);
    }

    public String getCurrentWebIanaEncoding() {
        String enc = this._hash.getString("webIANAEncoding");
        if (enc == null) {
            enc = IdeUtil.getIdeIanaEncoding();
        }
        return enc;
    }

    public void setCurrentWebIanaEncoding(String encoding) {
        this._hash.putString("webIANAEncoding", encoding);
    }

    public boolean getOutOfProcess() {
        return this._hash.getBoolean("outOfProcess", false);
    }

    public void setOutOfProcess(boolean outOfProcess) {
        if (!outOfProcess) {
            this._hash.remove("outOfProcess");
        } else {
            this._hash.putBoolean("outOfProcess", outOfProcess);
        }
    }

    public String getOutOfProcessJavaOptions() {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        return this._hash.getString("outOfProcessJavaOptions", defaultOptions);
    }

    public void setOutOfProcessJavaOptions(String options) {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        if (options == null || options.trim().length() == 0) {
            options = defaultOptions;
        }
        if (defaultOptions.equals(options)) {
            this._hash.remove("outOfProcessJavaOptions");
        } else {
            this._hash.putString("outOfProcessJavaOptions", options);
        }
    }

    public void enableCompilerOption(String optionName, String argument) {
        if (optionName.equals("-source")) {
            this.setSource(argument);
            return;
        }
        if (optionName.equals("-target")) {
            this.setTarget(argument);
            return;
        }
        if (optionName.equals("-encoding")) {
            this.setCurrentEncoding(argument);
            return;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.project);
        optionManager.enableCompilerOption(null, optionName, argument);
    }

    public void disableCompilerOption(String optionName) {
        if (optionName.equals("-source")) {
            this.setSource(null);
            return;
        }
        if (optionName.equals("-target")) {
            this.setTarget(null);
            return;
        }
        if (optionName.equals("-encoding")) {
            this.setCurrentEncoding(null);
            return;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.project);
        optionManager.disableCompilerOption(null, optionName);
    }

    public boolean compilerRecognizesOption(String optionName) {
        if (optionName.equals("-source")) {
            return true;
        }
        if (optionName.equals("-target")) {
            return true;
        }
        if (optionName.equals("-encoding")) {
            return true;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.project);
        return optionManager.compilerRecognizesOption(null, optionName);
    }

    public boolean compilerOptionRequiresArgument(String optionName) {
        if (optionName.equals("-source")) {
            return true;
        }
        if (optionName.equals("-target")) {
            return true;
        }
        if (optionName.equals("-encoding")) {
            return true;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.project);
        return optionManager.compilerOptionRequiresArgument(null, optionName);
    }

    public String getCompilerOption(String optionName) {
        if (optionName.equals("-source")) {
            return optionName + " " + this.getSource();
        }
        if (optionName.equals("-target")) {
            return optionName + " " + this.getTarget();
        }
        if (optionName.equals("-encoding")) {
            return optionName + " " + this.getCurrentEncoding();
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.project);
        return optionManager.getCompilerOptionAsString(null, optionName);
    }
}

