/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.controls.classpick.DualFiter;
import oracle.jdeveloper.controls.classpick.Entry;
import oracle.jdeveloper.controls.classpick.Filter;
import oracle.jdeveloper.controls.classpick.PatternFilter;
import oracle.jdeveloper.controls.classpick.SmartFilter;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.model.PathsConfiguration;

public class TextFieldAdapter {
    private static final int MAX_CONTENT = 10;
    private int _flags = 26;
    private JTextField _textField;
    private Context _context;
    private Listeners _listeners = new Listeners();
    private Popup _popup;
    private JList _jList;
    private DefaultListModel _dataModel = new DefaultListModel();
    private JavaManager _javaManager;
    private boolean _updateListOnTextChanges = true;
    private String _valueBeforeListUpdate = null;
    private volatile int _changeId;
    private Filter _filter;
    private JavaClassLocator _javaClassLocator;
    private Timer _timer;
    private boolean _textExists;

    TextFieldAdapter(JTextField textField, Context context, int flags) {
        this(textField, context, JavaManager.getJavaManager(context.getProject()), flags);
    }

    TextFieldAdapter(JTextField textField, Context context, JavaManager javaManager, int flags) {
        this._textField = textField;
        this._context = context;
        this._javaManager = javaManager;
        this._flags = flags;
        Document document = textField.getDocument();
        document.addDocumentListener(this._listeners);
        textField.addFocusListener(this._listeners);
        textField.addKeyListener(this._listeners);
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    private void updateDropDown() {
        if (this._updateListOnTextChanges) {
            if (this._timer == null) {
                this._timer = new Timer(500, this._listeners);
                this._timer.setRepeats(false);
            }
            if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }
    }

    private void whenTimerKiks(final String text) {
        new Thread(){

            @Override
            public void run() {
                final int changeId = ++TextFieldAdapter.this._changeId;
                final ArrayList entries = TextFieldAdapter.this.getEntries(text, changeId);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (changeId == TextFieldAdapter.this._changeId) {
                            TextFieldAdapter.this.updateList(entries);
                        }
                    }
                });
            }
        }.start();
    }

    private void updateList(ArrayList entries) {
        if (this._textField.hasFocus()) {
            String text = this._textField.getText();
            this._dataModel.removeAllElements();
            this._textExists = false;
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                if (!text.equals(entry.getFullName())) {
                    this._dataModel.addElement(entry);
                    continue;
                }
                this._textExists = true;
            }
            this.closeDropDown();
            if (!this._dataModel.isEmpty() && this._textField.isShowing()) {
                this.showPopup();
            }
        }
    }

    private ArrayList getEntries(String text, int changeId) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try {
            DualFiter dualFiter = text.indexOf(42) == -1 ? new SmartFilter() : new PatternFilter();
            dualFiter.setMatchName(text);
            JavaClassLocator javaClassLocator = this.getJavaLocator();
            Collection allPackages = javaClassLocator.getAllPackages((PackageNameFilter)dualFiter);
            int contentCount = 0;
            Iterator allPackagesIterator = allPackages.iterator();
            while (changeId == this._changeId && contentCount < 10 && allPackagesIterator.hasNext()) {
                String packageName = (String)allPackagesIterator.next();
                if (this._filter != null && !this._filter.acceptPackageName(packageName)) continue;
                Entry packageEntry = Entry.createPackageEntry(packageName);
                entries.add(packageEntry);
                ++contentCount;
            }
            if (changeId == this._changeId && contentCount < 10) {
                boolean showClasses = BitField.isSet((int)this._flags, (int)8);
                boolean showInterfaces = BitField.isSet((int)this._flags, (int)16);
                if (showClasses || showInterfaces) {
                    Collection classesByPrefix = javaClassLocator.getAllClasses((ClassNameFilter)dualFiter);
                    Iterator iterator = classesByPrefix.iterator();
                    while (changeId == this._changeId && contentCount < 10 && iterator.hasNext()) {
                        String fqClassName = (String)iterator.next();
                        JavaClass javaClass = this._javaManager.getClass(fqClassName);
                        if (javaClass == null) continue;
                        String className = javaClass.getName();
                        String packageName = javaClass.getPackageName();
                        if (this._filter != null && !this._filter.acceptClassName(packageName, className)) continue;
                        Entry classEntry = null;
                        if (javaClass.isInterface()) {
                            if (showInterfaces) {
                                classEntry = Entry.createInterface(packageName, className);
                            }
                        } else if (showClasses) {
                            classEntry = Entry.createClassEntry(packageName, className);
                        }
                        if (classEntry == null) continue;
                        entries.add(classEntry);
                        ++contentCount;
                    }
                }
            }
            if (contentCount == 10) {
                Entry dddEntry = Entry.createDotDotDotEntry();
                entries.add(dddEntry);
            }
            Collections.sort(entries);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        return entries;
    }

    private JavaClassLocator getJavaLocator() {
        if (this._javaClassLocator == null) {
            switch (this._flags & 3) {
                case 2: {
                    this._javaClassLocator = this.getBaseProjectSourcesLocator();
                    break;
                }
                case 1: {
                    Project project = this._context.getProject();
                    BaseClassLocator sourceLocator = this.getSourceLocator(project);
                    this._javaClassLocator = sourceLocator;
                    break;
                }
                default: {
                    this._javaClassLocator = this._javaManager.getJavaClassLocator();
                }
            }
        }
        return this._javaClassLocator;
    }

    private ArrayClassLocator getBaseProjectSourcesLocator() {
        Project deepestProject = this._context.getProject();
        HashSet<Object> bases = new HashSet<Object>();
        ArrayList<Object> dependables = new ArrayList<Object>();
        bases.add(deepestProject);
        dependables.add(deepestProject);
        while (!dependables.isEmpty()) {
            Project project = (Project)dependables.remove(0);
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Element dependableSource = dependable.getSource();
                if (!(dependableSource instanceof Project) || !bases.add(dependableSource)) continue;
                dependables.add(dependableSource);
            }
        }
        Project[] projects = bases.toArray(new Project[bases.size()]);
        BaseClassLocator[] locators = new BaseClassLocator[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            Project project = projects[i];
            locators[i] = this.getSourceLocator(project);
        }
        ArrayClassLocator arrayClassLocator = new ArrayClassLocator(locators);
        return arrayClassLocator;
    }

    private BaseClassLocator getSourceLocator(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)project);
        URLPath sourcePath = pathsConfiguration.getProjectSourcePath();
        ClassLocatorFactory factory = ClassLocatorFactory.getInstance();
        BaseClassLocator sourceLocator = factory.getSourceLocator(sourcePath);
        return sourceLocator;
    }

    private void showPopup() {
        PopupFactory sharedInstance = PopupFactory.getSharedInstance();
        this._jList = new JList(this._dataModel);
        this._jList.addListSelectionListener(this._listeners);
        this._jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Entry entry = (Entry)value;
                this.setIcon(entry.getIcon());
                return component;
            }
        });
        this._jList.addFocusListener(this._listeners);
        this._jList.addMouseListener(this._listeners);
        Border border = UIManager.getLookAndFeel().getDefaults().getBorder("ScrollPane.border");
        this._jList.setBorder(border);
        Dimension size = this._jList.getPreferredSize();
        size.width = this._textField.getWidth();
        this._jList.setPreferredSize(size);
        Point locationOnScreen = this._textField.getLocationOnScreen();
        int x = locationOnScreen.x;
        int y = locationOnScreen.y + this._textField.getHeight();
        this._popup = sharedInstance.getPopup(this._textField, this._jList, x, y);
        this._popup.show();
    }

    private void closeDropDown() {
        if (this._popup != null) {
            this._updateListOnTextChanges = true;
            this._valueBeforeListUpdate = null;
            this._popup.hide();
            this._jList.removeListSelectionListener(this._listeners);
            this._popup = null;
            this._jList = null;
        }
    }

    private void focusLost(FocusEvent e) {
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this._jList != null) {
            boolean close = true;
            Component oppositeComponent = e.getOppositeComponent();
            if (oppositeComponent != null && SwingUtilities.isDescendingFrom(oppositeComponent, this._jList)) {
                close = false;
            }
            if (close) {
                this.closeDropDown();
            }
        }
    }

    private void keyPressed(KeyEvent e) {
        if (this._jList != null) {
            switch (e.getKeyCode()) {
                case 40: {
                    e.consume();
                    int selectedIndex = this._jList.getSelectedIndex();
                    int newIndex = selectedIndex + 1;
                    int modelSize = this._dataModel.getSize();
                    if (newIndex < modelSize) {
                        this._jList.ensureIndexIsVisible(newIndex);
                        this._jList.setSelectedIndex(newIndex);
                        break;
                    }
                    if (modelSize <= 0) break;
                    this._jList.ensureIndexIsVisible(0);
                    this._jList.setSelectedIndex(0);
                    break;
                }
                case 38: {
                    e.consume();
                    int selectedIndex = this._jList.getSelectedIndex();
                    int newIndex = selectedIndex - 1;
                    if (newIndex >= 0) {
                        this._jList.ensureIndexIsVisible(newIndex);
                        this._jList.setSelectedIndex(newIndex);
                        break;
                    }
                    if (this._dataModel.isEmpty()) break;
                    int lastEntry = this._dataModel.size() - 1;
                    this._jList.ensureIndexIsVisible(lastEntry);
                    this._jList.setSelectedIndex(lastEntry);
                    break;
                }
                case 27: {
                    if (this._popup == null) break;
                    e.consume();
                    String valueBeforeListUpdate = this._valueBeforeListUpdate;
                    this.closeDropDown();
                    if (valueBeforeListUpdate == null) break;
                    this._updateListOnTextChanges = false;
                    this._textField.setText(valueBeforeListUpdate);
                    this._updateListOnTextChanges = true;
                    break;
                }
                case 10: {
                    int size;
                    if (this._popup == null) break;
                    e.consume();
                    if (!this._textExists && (size = this._dataModel.getSize()) == 1) {
                        Entry firstEntry = (Entry)this._dataModel.get(0);
                        String fullName = firstEntry.getFullName();
                        this._updateListOnTextChanges = false;
                        this._textField.setText(fullName);
                        this._updateListOnTextChanges = true;
                    }
                    this.closeDropDown();
                }
            }
        }
    }

    private void valueChanged(ListSelectionEvent e) {
        Entry selectedValue;
        if (!e.getValueIsAdjusting() && (selectedValue = (Entry)this._jList.getSelectedValue()) != null && selectedValue.getType() != 20) {
            if (this._valueBeforeListUpdate == null) {
                this._valueBeforeListUpdate = this._textField.getText();
            }
            this._updateListOnTextChanges = false;
            this._textField.setText(selectedValue.getFullName());
            this._updateListOnTextChanges = true;
        }
    }

    private class Listeners
    implements DocumentListener,
    FocusListener,
    KeyListener,
    MouseListener,
    ListSelectionListener,
    ActionListener {
        private Listeners() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextFieldAdapter.this.updateDropDown();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextFieldAdapter.this.updateDropDown();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextFieldAdapter.this.updateDropDown();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            TextFieldAdapter.this.focusLost(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TextFieldAdapter.this.keyPressed(e);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TextFieldAdapter.this.valueChanged(e);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = TextFieldAdapter.this._textField.getText();
            if (text.length() >= 2) {
                TextFieldAdapter.this.whenTimerKiks(text);
            } else {
                TextFieldAdapter.this.closeDropDown();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Entry selectedValue = (Entry)TextFieldAdapter.this._jList.getSelectedValue();
            if (selectedValue != null) {
                TextFieldAdapter.this._textField.setText(selectedValue.getFullName());
                TextFieldAdapter.this.closeDropDown();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

