/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineUtils;

public class AnnotationUtils
implements EngineConstants {
    public static String getAnnotationAttr(JavaElement javaElem, String annoClass, String attrName, String defaultValue) {
        SourceElement srcElem = javaElem.getSourceElement();
        if (srcElem != null) {
            return AnnotationUtils.getSourceAnnotationAttr(srcElem, annoClass, attrName, defaultValue);
        }
        return AnnotationUtils.getJavaAnnotationAttr(javaElem, annoClass, attrName, defaultValue);
    }

    public static String getAnnotationAttr(JavaAnnotation javaAnnotation, String attrName, String defaultValue) {
        SourceAnnotation srcAnnotation = (SourceAnnotation)javaAnnotation.getSourceElement();
        if (srcAnnotation != null) {
            return AnnotationUtils.getSourceAnnotationAttr(srcAnnotation, attrName, defaultValue);
        }
        return AnnotationUtils.getJavaAnnotationAttr(javaAnnotation, attrName, defaultValue);
    }

    public static JavaElement getAnnotatedProperty(JavaClass javaClass, String annoClass) {
        if (javaClass == null) {
            return null;
        }
        SourceClass srcClass = (SourceClass)javaClass.getSourceElement();
        if (srcClass != null) {
            for (SourceFieldDeclaration javaField : srcClass.getSourceFieldDeclarations()) {
                if (AnnotationUtils.getSourceAnnotation((SourceElement)javaField, annoClass) == null) continue;
                return javaField;
            }
            for (SourceMethod javaMethod : srcClass.getSourceMethods()) {
                if (AnnotationUtils.getSourceAnnotation((SourceElement)javaMethod, annoClass) == null) continue;
                return javaMethod;
            }
        } else {
            for (JavaField javaField : javaClass.getDeclaredFields()) {
                if (AnnotationUtils.getJavaAnnotation((JavaElement)javaField, annoClass) == null) continue;
                return javaField;
            }
            for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
                if (AnnotationUtils.getJavaAnnotation((JavaElement)javaMethod, annoClass) == null) continue;
                return javaMethod;
            }
        }
        return null;
    }

    public static List<JavaElement> getAnnotatedProperties(JavaClass javaClass, String annoClass) {
        ArrayList<JavaElement> annotatedProperties = new ArrayList<JavaElement>();
        if (javaClass == null) {
            return annotatedProperties;
        }
        SourceClass srcClass = (SourceClass)javaClass.getSourceElement();
        if (srcClass != null) {
            for (SourceFieldDeclaration javaField : srcClass.getSourceFieldDeclarations()) {
                if (AnnotationUtils.getSourceAnnotation((SourceElement)javaField, annoClass) == null) continue;
                annotatedProperties.add((JavaElement)javaField);
            }
            for (SourceMethod javaMethod : srcClass.getSourceMethods()) {
                if (AnnotationUtils.getSourceAnnotation((SourceElement)javaMethod, annoClass) == null) continue;
                annotatedProperties.add((JavaElement)javaMethod);
            }
        } else {
            for (JavaField javaField : javaClass.getDeclaredFields()) {
                if (AnnotationUtils.getJavaAnnotation((JavaElement)javaField, annoClass) == null) continue;
                annotatedProperties.add((JavaElement)javaField);
            }
            for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
                if (AnnotationUtils.getJavaAnnotation((JavaElement)javaMethod, annoClass) == null) continue;
                annotatedProperties.add((JavaElement)javaMethod);
            }
        }
        return annotatedProperties;
    }

    public static JavaAnnotation getAnnotation(JavaElement javaElem, String annoClass) {
        SourceElement srcElem = javaElem.getSourceElement();
        if (srcElem != null) {
            return AnnotationUtils.getSourceAnnotation(srcElem, annoClass);
        }
        return AnnotationUtils.getJavaAnnotation(javaElem, annoClass);
    }

    public static SourceAnnotation addAnnotation(SourceElement srcElem, String annoClass, List exprs) {
        if (srcElem == null) {
            return null;
        }
        StringBuffer annoBuf = new StringBuffer();
        annoBuf.append("@");
        annoBuf.append(EngineUtils.getShortName(annoClass));
        if (exprs != null && exprs.size() > 0) {
            annoBuf.append("(");
            boolean first = true;
            for (String expr : exprs) {
                if (first) {
                    first = false;
                } else {
                    annoBuf.append(", ");
                }
                annoBuf.append(expr);
            }
            annoBuf.append(")");
        }
        return AnnotationUtils.addAnnotationFromText(srcElem, annoClass, annoBuf.toString());
    }

    public static SourceAnnotation addAnnotationFromText(SourceElement srcElem, String annoClass, String text) {
        Collection srcAnnos = AnnotationUtils._getSourceAnnotations(srcElem);
        SourceAnnotation srcAnno = AnnotationUtils._findSourceAnnotation(annoClass, srcAnnos);
        SourceFile srcFile = srcElem.getOwningSourceFile();
        SourceFactory factory = srcFile.getFactory();
        EngineUtils.openTransaction(srcFile);
        EngineUtils.addImport(annoClass, srcFile);
        if (text != null) {
            if (srcAnno != null) {
                srcAnno.replaceSelf((SourceElement)factory.createAnnotationFromText(text));
            } else {
                srcAnno = factory.createAnnotationFromText(text);
                srcAnnos.add(srcAnno);
            }
        } else if (srcAnno == null) {
            srcAnno = factory.createAnnotation(EngineUtils.getShortName(annoClass));
            srcAnnos.add(srcAnno);
        }
        return srcAnno;
    }

    private static SourceAnnotation _findSourceAnnotation(String annoClass, Collection srcAnnos) {
        SourceAnnotation srcAnno = null;
        if (srcAnnos != null) {
            for (JavaAnnotation ja : srcAnnos) {
                String annoName = null;
                JavaType annoType = ja.getAnnotationType();
                annoName = annoType != null ? annoType.getQualifiedName() : ja.getUnresolvedType().getSimplifiedName();
                SourceAnnotation sa = null;
                if (!annoClass.equals(annoName) && !EngineUtils.getShortName(annoClass).equals(annoName)) continue;
                if (sa == null) {
                    sa = (SourceAnnotation)ja.getSourceElement();
                }
                srcAnno = sa;
                break;
            }
        }
        return srcAnno;
    }

    private static Collection _getSourceAnnotations(SourceElement srcElem) {
        Collection srcAnnos = null;
        if (SourceHasModifiers.class.isAssignableFrom(srcElem.getClass())) {
            srcAnnos = ((SourceHasModifiers)srcElem).getSourceAnnotations();
        } else if (JavaHasAnnotations.class.isAssignableFrom(srcElem.getClass())) {
            srcAnnos = ((JavaHasAnnotations)srcElem).getAnnotations();
        }
        return srcAnnos;
    }

    public static String getSourceAnnotationAttr(SourceElement srcElem, String annoClass, String attrName, String defaultValue) {
        Collection srcAnnos = AnnotationUtils._getSourceAnnotations(srcElem);
        SourceAnnotation srcAnno = AnnotationUtils._findSourceAnnotation(annoClass, srcAnnos);
        return AnnotationUtils.getSourceAnnotationAttr(srcAnno, attrName, defaultValue);
    }

    public static String getSourceAnnotationAttr(SourceAnnotation srcAnno, String attrName, String defaultValue) {
        SourceListExpression exprList;
        if (srcAnno != null && (exprList = srcAnno.getArgumentList()) != null) {
            List annoChildren = exprList.getOperands();
            for (SourceExpression childExpr : annoChildren) {
                if (attrName == null || attrName.equals("value")) {
                    return childExpr.getText().replaceAll("\"", "");
                }
                SourceExpression oper0 = childExpr.getOperandAt(0);
                if (oper0 == null || (attrName != null || oper0.getText() != null) && !ModelUtil.areEqual((Object)attrName, (Object)oper0.getText()) || childExpr.getOperandCount() <= 1) continue;
                return childExpr.getOperandAt(1).getText().replaceAll("\"", "");
            }
        }
        return defaultValue;
    }

    public static SourceAnnotation getSourceAnnotation(SourceElement srcElem, String annoClass) {
        if (srcElem == null) {
            return null;
        }
        Collection srcAnnos = AnnotationUtils._getSourceAnnotations(srcElem);
        return AnnotationUtils._findSourceAnnotation(annoClass, srcAnnos);
    }

    private static JavaAnnotation _findJavaAnnotation(String annoClass, Collection javaAnnos) {
        JavaAnnotation javaAnno = null;
        if (javaAnnos != null) {
            for (JavaAnnotation ja : javaAnnos) {
                JavaType annoType = ja != null ? ja.getResolvedType() : null;
                if (annoType == null || !annoClass.equals(annoType.getQualifiedName())) continue;
                javaAnno = ja;
                break;
            }
        }
        return javaAnno;
    }

    private static Collection _getJavaAnnotations(JavaElement javaElem) {
        Collection javaAnnos = null;
        if (JavaMethod.class.isAssignableFrom(javaElem.getClass())) {
            javaAnnos = ((JavaMethod)javaElem).getAnnotations();
        } else if (JavaClass.class.isAssignableFrom(javaElem.getClass())) {
            javaAnnos = ((JavaClass)javaElem).getAnnotations();
        } else if (JavaField.class.isAssignableFrom(javaElem.getClass())) {
            javaAnnos = ((JavaField)javaElem).getAnnotations();
        } else if (JavaHasAnnotations.class.isAssignableFrom(javaElem.getClass())) {
            javaAnnos = ((JavaHasAnnotations)javaElem).getAnnotations();
        }
        return javaAnnos;
    }

    public static String getJavaAnnotationAttr(JavaElement javaElem, String annoClass, String attrName, String defaultValue) {
        Collection javaAnnos = AnnotationUtils._getJavaAnnotations(javaElem);
        JavaAnnotation javaAnno = AnnotationUtils._findJavaAnnotation(annoClass, javaAnnos);
        return AnnotationUtils.getJavaAnnotationAttr(javaAnno, attrName, defaultValue);
    }

    public static String getJavaAnnotationAttr(JavaAnnotation javaAnno, String attrName, String defaultValue) {
        Map exprList;
        if (javaAnno != null && (exprList = javaAnno.getComponents()) != null) {
            for (Map.Entry entry : exprList.entrySet()) {
                if (!attrName.equals(entry.getKey())) continue;
                return entry.getValue().toString();
            }
        }
        return defaultValue;
    }

    public static JavaAnnotation getJavaAnnotation(JavaElement javaElem, String annoClass) {
        Collection javaAnnos = AnnotationUtils._getJavaAnnotations(javaElem);
        return AnnotationUtils._findJavaAnnotation(annoClass, javaAnnos);
    }

    public static void removeSourceAnnotation(SourceElement srcElem, String annoClass) {
        SourceAnnotation srcAnno = AnnotationUtils.getSourceAnnotation(srcElem, annoClass);
        if (srcAnno != null) {
            SourceFile srcFile = srcElem.getOwningSourceFile();
            EngineUtils.openTransaction(srcFile);
            srcAnno.removeSelf();
        }
    }
}

