/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceChange;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.java.v2.write.SourceTransactionListener;
import oracle.jdeveloper.engine.BaseEngine;
import oracle.jdeveloper.engine.CallMode;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineException;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.MethodEngine;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;

public class ClassEngine
extends BaseEngine
implements EngineConstants,
SourceTransactionListener,
Observer {
    private Project _project;
    private String _className;
    private SourceFile _srcFile;
    private static final boolean _enableMICaching = true;
    private boolean _attachedToNode;
    private boolean _attachedToSrcTrans;
    private JavaSourceNode _node;
    private MethodInfo[] _methodInfos;
    private MethodInfo[] _constructorMethodInfos;
    private boolean _onlyPublic;
    private Set _ignoreClasses;

    public ClassEngine(Project project, String className) {
        this._project = project;
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
        this.invalidateCache();
    }

    public JavaManager getJavaManager() {
        return JavaManager.getJavaManager(this._project);
    }

    public JavaClass getJavaClass() {
        return this.getJavaManager().getClass(this._className);
    }

    public SourceClass getSourceClass() {
        if (this.getSourceFile() != null) {
            return (SourceClass)this._srcFile.getPrimaryClass().getSourceElement();
        }
        return null;
    }

    public SourceFile getSourceFile() {
        if (this._srcFile == null || this._srcFile.isExpired()) {
            this._srcFile = EngineUtils.getSourceFile(this.getJavaManager(), this._className);
        }
        return this._srcFile;
    }

    public SourceFactory getFactory() {
        return this.getSourceFile().getFactory();
    }

    public SourceTransaction openTransaction() {
        return EngineUtils.openTransaction(this.getSourceFile());
    }

    public SourceSavepoint createSavepoint() {
        return EngineUtils.createSavepoint(this.getSourceFile());
    }

    public JavaSourceNode getJavaSourceNode() {
        if (this._node == null && this.getSourceFile() != null) {
            this._node = (JavaSourceNode)EngineUtils.findNode(JavaSourceNode.class, this._srcFile.getURL());
        }
        return this._node;
    }

    public boolean isInnerClass() {
        SourceClass javaClass = this.getSourceClass();
        return javaClass != null && !this.getClassName().endsWith(javaClass.getName());
    }

    public boolean isEditable() {
        return this.getSourceFile() != null && !URLFileSystem.isReadOnly((URL)this._srcFile.getURL());
    }

    public long getTimestamp() {
        Node node;
        if (this.getSourceFile() != null && (node = NodeFactory.find((URL)this._srcFile.getURL())) != null) {
            return node.getTimestamp();
        }
        return 0L;
    }

    public MethodInfo[] getMethods(boolean publicOnly, Set ignoreClasses) {
        return this.getMethods(publicOnly, ignoreClasses, true);
    }

    public MethodInfo findMethod(String name, List params) {
        MethodInfo[] methods;
        if (name != null && (methods = this.getMethods(false, null, true)) != null) {
            for (int i = methods.length - 1; i >= 0; --i) {
                if (!name.equals(methods[i].name) || !EngineUtils.areEquivalentCollections(params, methods[i].parameters)) continue;
                return methods[i];
            }
        }
        return null;
    }

    public MethodInfo[] getConstructorMethods(Set ignoreClasses, boolean useCache) {
        if (useCache) {
            SourceTransaction srcTrans = null;
            if (this._constructorMethodInfos != null && EngineUtils.areEquivalentCollections(this._ignoreClasses, ignoreClasses) && !this._attachedToSrcTrans && (srcTrans = this.getSrcTrans()) == null) {
                return this.cloneMethodInfos(this._constructorMethodInfos);
            }
            if (this.getSourceClass() != null) {
                this.attachNode(this, null);
                this.attachSourceTransactionListener(this, srcTrans);
            }
        }
        List methodList = this.getConstructorMethodsImpl(ignoreClasses);
        MethodInfo[] methodInfos = new MethodInfo[methodList.size()];
        methodList.toArray(methodInfos);
        if (useCache) {
            this._constructorMethodInfos = this.cloneMethodInfos(methodInfos);
            this._ignoreClasses = ignoreClasses;
        }
        return methodInfos;
    }

    public MethodInfo[] getMethods(boolean publicOnly, Set ignoreClasses, boolean useCache) {
        if (useCache) {
            SourceTransaction srcTrans = null;
            if (this._methodInfos != null && this._onlyPublic == publicOnly && EngineUtils.areEquivalentCollections(this._ignoreClasses, ignoreClasses) && !this._attachedToSrcTrans && (srcTrans = this.getSrcTrans()) == null) {
                return this.cloneMethodInfos(this._methodInfos);
            }
            if (this.getSourceClass() != null) {
                this.attachNode(this, null);
                this.attachSourceTransactionListener(this, srcTrans);
            }
        }
        List methodList = this.getMethodsImpl(publicOnly, ignoreClasses);
        JavaClass javaClass = this.getJavaClass();
        if (javaClass != null) {
            if (javaClass.isInterface()) {
                Collection interfaces = javaClass.getInterfaces();
                if (interfaces != null) {
                    for (JavaType javaType : interfaces) {
                        this._addSuperMethods(publicOnly, ignoreClasses, useCache, methodList, javaType.getQualifiedName());
                    }
                }
            } else {
                String superName = javaClass.getSuperclass().getQualifiedName();
                this._addSuperMethods(publicOnly, ignoreClasses, useCache, methodList, superName);
            }
        }
        MethodInfo[] methodInfos = new MethodInfo[methodList.size()];
        methodList.toArray(methodInfos);
        if (useCache) {
            this._methodInfos = this.cloneMethodInfos(methodInfos);
            this._onlyPublic = publicOnly;
            this._ignoreClasses = ignoreClasses;
        }
        return methodInfos;
    }

    private void _addSuperMethods(boolean publicOnly, Set ignoreClasses, boolean useCache, List methodList, String superName) {
        ClassEngine superEngine;
        MethodInfo[] superMethods;
        if (!"java.lang.Object".equals(superName) && superName.compareTo(this._className) != 0 && (superMethods = (superEngine = new ClassEngine(this._project, superName)).getMethods(publicOnly, ignoreClasses, useCache)) != null && superMethods.length > 0) {
            for (int i = 0; i < superMethods.length; ++i) {
                if (methodList.contains(superMethods[i])) continue;
                methodList.add(superMethods[i]);
            }
        }
    }

    private List getMethodsImpl(boolean publicOnly, Set ignoreClasses) {
        Collection methods;
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        SourceClass javaClass = this.getSourceClass();
        if (javaClass == null || this.isInnerClass()) {
            javaClass = this.getJavaClass();
            if (javaClass != null) {
                methods = javaClass.getDeclaredMethods();
            } else {
                methods = null;
                Assert.println((String)("Could not find source or compiled class for " + this._className));
            }
        } else {
            methods = javaClass.getSourceMethods();
        }
        if (methods != null) {
            boolean isInterface = javaClass.isInterface();
            for (JavaMethod meth : methods) {
                MethodInfo mi;
                if (!isInterface && publicOnly && !EngineUtils.isPublic(meth.getModifiers()) || ignoreClasses != null && ignoreClasses.contains(meth.getOwningClass().getQualifiedName()) || methodInfos.contains(mi = new MethodInfo(meth))) continue;
                methodInfos.add(mi);
            }
        }
        return methodInfos;
    }

    private List getConstructorMethodsImpl(Set ignoreClasses) {
        Collection methods;
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        SourceClass javaClass = this.getSourceClass();
        if (javaClass == null || this.isInnerClass()) {
            javaClass = this.getJavaClass();
            if (javaClass != null) {
                methods = javaClass.getDeclaredConstructors();
            } else {
                methods = null;
                Assert.println((String)("Could not find source or compiled class for " + this._className));
            }
        } else {
            methods = javaClass.getDeclaredConstructors();
        }
        if (methods != null) {
            boolean isInterface = javaClass.isInterface();
            for (JavaMethod meth : methods) {
                MethodInfo mi;
                if (!EngineUtils.isPublic(meth.getModifiers()) || ignoreClasses != null && ignoreClasses.contains(meth.getOwningClass().getQualifiedName()) || methodInfos.contains(mi = new MethodInfo(meth))) continue;
                methodInfos.add(mi);
            }
        }
        return methodInfos;
    }

    private MethodInfo[] cloneMethodInfos(MethodInfo[] methodInfos) {
        int len = methodInfos != null ? methodInfos.length : 0;
        MethodInfo[] newMethodInfos = new MethodInfo[len];
        for (int i = len - 1; i >= 0; --i) {
            newMethodInfos[i] = new MethodInfo(methodInfos[i]);
        }
        return newMethodInfos;
    }

    public MethodInfo addMethod(MethodInfo mi) throws EngineException {
        return this.addMethod(mi, null);
    }

    public MethodInfo addMethod(MethodInfo mi, MethodInfo prevMi) throws EngineException {
        return this.addMethodImpl(mi, prevMi, CallMode.VALIDATE_AND_EXECUTE);
    }

    MethodInfo addMethodImpl(MethodInfo mi, CallMode callMode) throws EngineException {
        return this.addMethodImpl(mi, null, callMode);
    }

    MethodInfo addMethodImpl(MethodInfo mi, MethodInfo prevMi, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            return new MethodInfo(MethodEngine.addMethod(this, mi, prevMi));
        }
        return null;
    }

    public MethodInfo updateMethod(MethodInfo oldMi, MethodInfo newMi) throws EngineException {
        return this.updateMethodImpl(oldMi, newMi, CallMode.VALIDATE_AND_EXECUTE);
    }

    MethodInfo updateMethodImpl(MethodInfo oldMi, MethodInfo newMi, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            return new MethodInfo(MethodEngine.updateMethod(this, oldMi, newMi));
        }
        return newMi;
    }

    public void removeMethod(MethodInfo mi) throws EngineException {
        this.removeMethodImpl(mi, CallMode.VALIDATE_AND_EXECUTE);
    }

    void removeMethodImpl(MethodInfo mi, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            MethodEngine.removeMethod(this, mi);
        }
    }

    @Override
    protected void doApply() {
        SourceTransaction trans;
        if (this.isEditable() && this._srcFile != null && (trans = this._srcFile.getTransaction()) != null) {
            try {
                this._srcFile.reformatSelf(0);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            this.invalidateCache(trans);
            trans.commit();
        }
    }

    @Override
    protected void doRevert() {
        SourceTransaction trans;
        if (this.isEditable() && this._srcFile != null && (trans = this._srcFile.getTransaction()) != null) {
            this.invalidateCache(trans);
            trans.abort();
        }
    }

    protected void invalidateCache() {
        this.invalidateCache(null);
    }

    protected void invalidateCache(SourceTransaction srcTrans) {
        this._methodInfos = null;
        this.detachNode(this);
        this.detachSourceTransactionListener(this, srcTrans);
    }

    private void attachSourceTransactionListener(SourceTransactionListener l, SourceTransaction srcTrans) {
        if (!this._attachedToSrcTrans) {
            if (srcTrans == null) {
                srcTrans = this.getSrcTrans();
            }
            if (srcTrans != null) {
                srcTrans.removeListener(l);
                srcTrans.addListener(l);
                this._attachedToSrcTrans = true;
            } else {
                this._attachedToSrcTrans = false;
            }
        }
    }

    private void detachSourceTransactionListener(SourceTransactionListener l, SourceTransaction srcTrans) {
        if (this._attachedToSrcTrans) {
            if (srcTrans == null) {
                srcTrans = this.getSrcTrans();
            }
            if (srcTrans != null) {
                srcTrans.removeListener(l);
            }
            this._attachedToSrcTrans = false;
        }
    }

    private SourceTransaction getSrcTrans() {
        SourceFile srcFile = this.getSourceFile();
        return srcFile != null ? srcFile.getTransaction() : null;
    }

    private void attachNode(Observer observer, JavaSourceNode node) {
        if (!this._attachedToNode) {
            this._node = node == null ? this.getJavaSourceNode() : node;
            if (this._node != null) {
                this._node.detach(observer);
                this._node.attach(observer);
                this._attachedToNode = true;
            } else {
                this._attachedToNode = false;
            }
        }
    }

    private void detachNode(Observer observer) {
        if (this._attachedToNode) {
            if (this._node != null) {
                this._node.detach(observer);
            }
            this._attachedToNode = false;
        }
    }

    public void update(Object observed, UpdateMessage change) {
        this.invalidateCache(null);
    }

    public void changeUpdate(SourceTransaction trans, SourceChange change) {
        this.invalidateCache(trans);
    }

    public void closeUpdate(SourceTransaction trans, boolean commit) {
    }
}

