/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodEngine;

public class MethodInfo
extends FieldInfo
implements Comparable {
    public List parameters;
    public Set thrown;
    private Collection javaAnnotations;
    public List<String> typeParameters = null;

    public MethodInfo() {
    }

    public MethodInfo(String returnType, String name, int modifiers) {
        this.type = returnType;
        this.name = name;
        this.modifiers = modifiers;
    }

    public MethodInfo(JavaMethod javaMethod) {
        Collection params;
        this.name = javaMethod.isConstructor() ? javaMethod.getOwningClass().getName() : javaMethod.getName();
        JavaType javaType = javaMethod.getReturnType();
        this.type = javaType != null ? javaType.getQualifiedName() : "void";
        this.typeSignature = javaType != null ? javaType.getTypeSignature() : "void";
        JavaClass owningClass = javaMethod.getOwningClass();
        if (owningClass != null) {
            this.declaringClassName = owningClass.getQualifiedName();
        }
        if ((params = javaMethod.getParameters()) != null && params.size() > 0) {
            SourceMethod srcMethod = (SourceMethod)javaMethod.getSourceElement();
            if (srcMethod != null) {
                this.extractParameters(srcMethod);
            } else {
                int index = 0;
                for (JavaVariable jparam : params) {
                    String tname;
                    JavaType ptype = jparam.getResolvedType();
                    if (ptype == null) {
                        Assert.println((String)("MethodInfo: Java parser unable to resolve param type " + jparam.getName() + " on method " + javaMethod.getName()));
                        tname = jparam.getUnresolvedType().getSimplifiedName();
                    } else {
                        tname = ptype.getQualifiedName();
                    }
                    String pname = jparam.getName();
                    if (!ModelUtil.hasLength((String)pname)) {
                        pname = "p" + index++;
                    }
                    this.addParameter(tname, pname);
                }
            }
        }
        this.extractExceptions(javaMethod);
        this.extractTypeParameters(javaMethod);
        this.modifiers = javaMethod.getModifiers();
        this.javaAnnotations = javaMethod.getAnnotations();
        if (this.isGetter()) {
            JavaField javaField = owningClass.getField(Introspector.decapitalize(this.name.substring(3)));
            this.getJavaFieldAnnotations(javaField);
        }
    }

    public MethodInfo(SourceMethod srcMethod) {
        JavaType ptype;
        this.name = srcMethod.getName();
        SourceTypeReference javaType = srcMethod.getSourceReturnType();
        this.type = javaType == null ? "void" : ((ptype = javaType.getResolvedType()) == null ? javaType.getName() : ptype.getQualifiedName());
        JavaClass owningClass = srcMethod.getOwningClass();
        if (owningClass != null) {
            this.declaringClassName = owningClass.getQualifiedName();
        }
        this.extractParameters(srcMethod);
        this.extractExceptions((JavaMethod)srcMethod);
        this.extractTypeParameters((JavaMethod)srcMethod);
        this.modifiers = srcMethod.getModifiers();
    }

    private void extractTypeParameters(JavaMethod javaMethod) {
        Collection typeParams = javaMethod.getTypeParameters();
        if (typeParams != null) {
            this.typeParameters = new ArrayList<String>();
            for (JavaTypeVariable typeParam : typeParams) {
                this.typeParameters.add(typeParam.getName());
            }
        }
    }

    private void extractExceptions(JavaMethod javaMethod) {
        String throwsText;
        SourceThrowsClause throwsClause;
        Collection exceptions = javaMethod.getExceptions();
        this.thrown = new TreeSet();
        if (exceptions.size() > 0) {
            for (JavaType exc : exceptions) {
                this.thrown.add(exc != null ? exc.getQualifiedName() : "void");
            }
        } else if (javaMethod.getSourceElement() != null && (throwsClause = ((SourceMethod)javaMethod.getSourceElement()).getThrowsClause()) != null && ModelUtil.hasLength((String)(throwsText = throwsClause.getText()))) {
            String exceptionsAsString = null;
            exceptionsAsString = throwsText.startsWith("throws ") ? throwsText.substring(7) : throwsText;
            this.thrown.add(exceptionsAsString);
        }
    }

    private void extractParameters(SourceMethod srcMethod) {
        List params = srcMethod.getSourceParameters();
        for (SourceVariable jparam : params) {
            String ptext;
            int index;
            JavaType ptype = jparam.getResolvedType();
            String tname = ptype != null ? ptype.getQualifiedName() : ((index = (ptext = jparam.getText()).indexOf(32)) > 0 ? ptext.substring(0, index) : ptext);
            this.addParameter(tname, jparam.getName());
        }
    }

    public MethodInfo(MethodInfo mi) {
        super(mi);
        if (mi != null) {
            if (mi.parameters != null) {
                this.parameters = (List)((ArrayList)mi.parameters).clone();
            }
            if (mi.thrown != null) {
                this.thrown = (Set)((TreeSet)mi.thrown).clone();
            }
            this.javaAnnotations = mi.javaAnnotations;
            this.setJavaFieldAnnotations(mi.getJavaFieldAnnotations());
            this.modifiers = mi.modifiers;
            this.typeParameters = mi.typeParameters != null ? (List)((ArrayList)mi.typeParameters).clone() : null;
        }
    }

    @Override
    public Object copyTo(Object target) {
        MethodInfo copy = target != null ? (MethodInfo)target : new MethodInfo();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(MethodInfo copy) {
        super.copyToImpl(copy);
        if (this.parameters == null || this.parameters.size() == 0) {
            copy.parameters = null;
        } else {
            copy.parameters = new ArrayList();
            ModelUtil.deepCopy((List)this.parameters, (List)copy.parameters);
        }
        if (this.thrown == null || this.thrown.size() == 0) {
            copy.thrown = null;
        } else {
            copy.thrown = new TreeSet();
            MethodInfo.deepCopy(this.thrown, copy.thrown);
        }
        if (this.typeParameters == null || this.typeParameters.size() == 0) {
            copy.typeParameters = null;
        } else {
            copy.typeParameters = new ArrayList<String>();
            MethodInfo.deepCopy(this.typeParameters, copy.typeParameters);
        }
    }

    public boolean isGetter() {
        return !Modifier.isStatic(this.modifiers) && (this.name.startsWith("get") && this.name.length() > 3 || ("boolean".equals(this.type) || "java.lang.Boolean".equals(this.type)) && this.name.startsWith("is") && this.name.length() > 2) && this.type != null && this.type != "void" && (this.parameters == null || this.parameters.size() == 0);
    }

    public boolean isSetter() {
        return !Modifier.isStatic(this.modifiers) && this.name.startsWith("set") && this.name.length() > 3 && (this.type == null || this.type == "void") && this.parameters != null && this.parameters.size() == 1;
    }

    public FieldInfo getField() {
        FieldInfo fieldInfo = null;
        if (this.isGetter()) {
            int index = this.name.startsWith("is") ? 2 : 3;
            fieldInfo = new FieldInfo(this.type, Introspector.decapitalize(this.name.substring(index)), 0);
        } else if (this.isSetter()) {
            fieldInfo = new FieldInfo((String)((List)this.parameters.get(0)).get(0), Introspector.decapitalize(this.name.substring(3)), 0);
        }
        if (fieldInfo != null) {
            fieldInfo.setJavaFieldAnnotations(this.getJavaFieldAnnotations());
        }
        return fieldInfo;
    }

    public Collection getJavaMethodAnnotations() {
        return this.javaAnnotations;
    }

    @Override
    public int validate() {
        int result = super.validate();
        if (result != 0) {
            return result;
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            Iterator iter = this.parameters.iterator();
            ArrayList<String> used = new ArrayList<String>(this.parameters.size());
            while (iter.hasNext()) {
                List param = (List)iter.next();
                String type = (String)param.get(0);
                String name = (String)param.get(1);
                if (name != null) {
                    name = name.trim();
                }
                if (type != null) {
                    type = type.trim();
                }
                if (name != null && name.length() > 0) {
                    if (used.contains(name)) {
                        return 6;
                    }
                    used.add(name);
                    if (!IdeUtil.isJavaIdentifier((String)name)) {
                        return 7;
                    }
                } else {
                    return 8;
                }
                if (type != null) continue;
                return 9;
            }
        }
        if (this.thrown != null && this.thrown.size() > 0) {
            for (String type : this.thrown) {
                if (type != null) {
                    type = type.trim();
                }
                if (type != null && type.length() != 0) continue;
                return 12;
            }
        }
        return 0;
    }

    public void addParameter(String type, String name) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        ArrayList<String> param = new ArrayList<String>();
        param.add(type);
        param.add(name);
        this.parameters.add(param);
    }

    public void addException(String exception) {
        if (this.thrown == null) {
            this.thrown = new TreeSet();
        }
        this.thrown.add(exception);
    }

    public void removeException(String exception) {
        if (this.thrown != null) {
            this.thrown.remove(exception);
        }
    }

    @Override
    public String render() {
        return EngineUtils.renderMethod(this.modifiers, this.type, this.name, this.parameters, this.thrown);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)o;
            return EngineUtils.renderMethod(-1, null, this.name, this.parameters, null).compareTo(EngineUtils.renderMethod(-1, null, mi.name, mi.parameters, null));
        }
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((MethodInfo)o);
    }

    protected final boolean equalsImpl(MethodInfo methodInfo) {
        return super.equalsImpl(methodInfo) && EngineUtils.areEquivalentCollections(this.parameters, methodInfo.parameters) && EngineUtils.areEquivalentCollections(this.thrown, methodInfo.thrown);
    }

    @Override
    public String toString() {
        return EngineUtils.renderMethod(-1, null, this.name, this.parameters, null);
    }

    public SourceMethod createSourceConstructor(SourceFile srcFile, boolean addDefaultImpl) {
        return this.createSourceMethod(srcFile, addDefaultImpl, null, null, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile srcFile, String stmt) {
        return this.createSourceMethod(srcFile, false, stmt, null, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile srcFile, String[] stmts) {
        return this.createSourceMethod(srcFile, false, null, stmts, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile srcFile, SourceBlock srcBlock) {
        return this.createSourceMethod(srcFile, false, null, null, srcBlock, true);
    }

    public SourceMethod createSourceMethod(SourceFile srcFile, boolean addDefaultImpl) {
        return this.createSourceMethod(srcFile, addDefaultImpl, null, null, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile srcFile, String stmt) {
        return this.createSourceMethod(srcFile, false, stmt, null, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile srcFile, String[] stmts) {
        return this.createSourceMethod(srcFile, false, null, stmts, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile srcFile, SourceBlock srcBlock) {
        return this.createSourceMethod(srcFile, false, null, null, srcBlock, false);
    }

    private SourceMethod createSourceMethod(SourceFile srcFile, boolean addDefaultImpl, String stmt, String[] stmts, SourceBlock srcBlock, boolean isConstructor) {
        SourceMethod srcMethod;
        boolean isInterface;
        EngineUtils.openTransaction(srcFile);
        SourceFactory factory = srcFile.getFactory();
        SourceFormalParameterList params = null;
        if (this.parameters != null && this.parameters.size() > 0) {
            params = factory.createFormalParameterList();
            List paramChildren = params.getChildren();
            for (List param : this.parameters) {
                String stype = (String)param.get(0);
                EngineUtils.addImport(stype, srcFile);
                SourceTypeReference ptype = EngineUtils.createType(factory, stype);
                SourceLocalVariable var = factory.createLocalVariable(ptype, (String)param.get(1));
                paramChildren.add(var);
            }
        }
        SourceThrowsClause throwsClause = null;
        if (this.thrown != null && this.thrown.size() > 0) {
            SourceTypeReference[] ttypes = new SourceTypeReference[this.thrown.size()];
            int i = 0;
            for (String stype : this.thrown) {
                EngineUtils.addImport(stype, srcFile);
                ttypes[i++] = EngineUtils.createType(factory, stype);
            }
            throwsClause = factory.createThrowsClause(ttypes);
        }
        EngineUtils.addImport(this.type, srcFile);
        SourceTypeReference mtype = isConstructor ? null : EngineUtils.createType(factory, !ModelUtil.hasLength((String)this.type) ? "void" : this.type);
        SourceClass srcClass = (SourceClass)srcFile.getPrimaryClass();
        boolean bl = isInterface = srcClass == null ? false : srcClass.isInterface();
        if ((this.modifiers & 0x400) != 0 || isInterface) {
            srcBlock = null;
        } else if (srcBlock == null) {
            if (ModelUtil.hasLength((String)stmt)) {
                if (!stmt.endsWith(";")) {
                    stmt = stmt + ';';
                }
                srcBlock = factory.createBlock(new SourceElement[]{factory.createStatement(stmt)});
            } else if (ModelUtil.hasNonNullElement((Object[])stmts)) {
                SourceElement[] srcElems = new SourceElement[stmts.length];
                for (int i = 0; i < stmts.length; ++i) {
                    if (!stmts[i].endsWith(";")) {
                        int n = i;
                        stmts[n] = stmts[n] + ';';
                    }
                    srcElems[i] = factory.createStatement(stmts[i]);
                }
                srcBlock = factory.createBlock(srcElems);
            } else {
                srcBlock = factory.createBlock();
            }
        }
        SourceTypeParameter[] typeParams = null;
        if (this.typeParameters != null && this.typeParameters.size() > 0) {
            typeParams = new SourceTypeParameter[this.typeParameters.size()];
            int i = 0;
            for (String typeParam : this.typeParameters) {
                typeParams[i++] = factory.createTypeParameter(typeParam);
            }
        }
        SourceMethod sourceMethod = isConstructor ? factory.createConstructor(params, throwsClause, srcBlock) : (srcMethod = typeParams != null ? factory.createMethod(typeParams, mtype, this.name, params, throwsClause, srcBlock) : factory.createMethod(mtype, this.name, params, throwsClause, srcBlock));
        if (!isInterface) {
            srcMethod.setModifiers(this.modifiers);
            if (addDefaultImpl) {
                MethodEngine.addDefaultImpl(this, srcFile, srcMethod);
            }
        }
        return srcMethod;
    }

    private static final void deepCopy(Collection src, Collection dst) {
        if (src == null || dst == null) {
            return;
        }
        for (Object srcValue : src) {
            if (dst.contains(srcValue)) continue;
            Object valueCopy = srcValue instanceof Copyable ? ((Copyable)srcValue).copyTo(null) : srcValue;
            dst.add(valueCopy);
        }
    }
}

