/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import oracle.ide.file.FileSetTable;
import oracle.ide.net.JarUtil;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.URLClassLocator;

public final class FileTableClassLocator
extends BaseClassLocator {
    private final FileSetTable table;
    private final Type type;
    private final boolean isJarTable;

    public FileTableClassLocator(FileSetTable table, Type type) {
        this.table = table;
        this.type = type;
        URL root = table.getFileSet().getRoot();
        this.isJarTable = JarUtil.isJarURL((URL)root) && "".equals(JarUtil.getJarEntry((URL)root));
    }

    public void buildIndex() {
        try {
            this.table.update();
        }
        catch (InterruptedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        try {
            this.table.update();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        try {
            this.getPackagesImpl(packagePrefix, out);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getPackagesImpl(packagePrefix, out);
    }

    private void getPackagesImpl(String packagePrefix, Collection<String> out) throws InterruptedException {
        try {
            for (String s : this.table.getSubdirectories(this.getRelativePath(packagePrefix))) {
                if (s.indexOf(45) != -1) continue;
                out.add(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getRelativePath(String pkg) {
        String relativePath = pkg.replace('.', '/');
        relativePath = relativePath + '/';
        return relativePath;
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        try {
            this.getClassesInPackageImpl(packagePrefix, out, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getClassesInPackageImpl(packagePrefix, out, true);
    }

    private void getClassesInPackageImpl(String packagePrefix, Collection<String> out, boolean checkInterrupt) throws InterruptedException {
        try {
            for (String s : this.table.getFiles(this.getRelativePath(packagePrefix))) {
                int lastDot;
                if (checkInterrupt) {
                    FileTableClassLocator.checkInterrupt();
                }
                if (!this.isMatchingFileType(s) || (lastDot = s.lastIndexOf(46)) == -1 || s.indexOf(36) != -1) continue;
                out.add(s.substring(0, lastDot));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        try {
            this.getAllClassesImpl(out, filter, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getAllClassesImpl(out, filter, true);
    }

    private void getAllClassesImpl(Collection<String> out, ClassNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            FileTableClassLocator.checkInterrupt();
        }
        try {
            for (String s : this.table.getFilePaths()) {
                if (this.isMatchingFileType(s)) {
                    String name = s.substring(0, s.length() - (this.type == Type.CLASS ? 6 : 5));
                    int lastDot = name.lastIndexOf(47);
                    String pkg = "";
                    String n = name;
                    if (lastDot != -1) {
                        pkg = name.substring(0, lastDot);
                        n = name.substring(lastDot + 1);
                    }
                    if (n.indexOf(36) > -1) continue;
                    pkg = pkg.replace('/', '.');
                    if (filter == null || filter.acceptClassName(n, pkg)) {
                        out.add(pkg + "." + n);
                    }
                }
                if (!checkInterrupt) continue;
                FileTableClassLocator.checkInterrupt();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected Collection<String> getClassesDirectly() {
        return this.getAllClasses();
    }

    protected Collection<URL> getResourcesDirectly(String name) {
        return this.getResourceURLs(name);
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        try {
            this.getAllPackagesImpl(out, filter, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.getAllPackagesImpl(out, filter, true);
    }

    private void getAllPackagesImpl(Collection<String> out, PackageNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        try {
            for (String s : this.table.getDirectoryPaths()) {
                if (checkInterrupt) {
                    FileTableClassLocator.checkInterrupt();
                }
                String pkg = s.replace('/', '.');
                if ((pkg = pkg.substring(0, pkg.length() - 1)).indexOf(45) != -1 || filter != null && !filter.acceptPackageName(pkg)) continue;
                out.add(pkg);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public URL getURL(String fqClassName) {
        try {
            return this.getURLImpl(fqClassName, false);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getURLImpl(fqClassName, true);
    }

    private URL getURLImpl(String fqClassName, boolean checkInterrupt) throws InterruptedException {
        String[] suffixes;
        for (String suffix : suffixes = this.type == Type.SOURCE ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES) {
            URL u;
            String relativePath = fqClassName.replace('.', '/') + suffix;
            URL uRL = u = checkInterrupt ? this.locateInterruptibly(relativePath) : this.locate(relativePath);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public URL getSourceURL(String fqClassName) {
        return this.type == Type.SOURCE ? this.getURL(fqClassName) : null;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.type == Type.SOURCE ? this.getURLInterruptibly(fqClassName) : null;
    }

    public URL getClassURL(String fqClassName) {
        return this.type == Type.CLASS ? this.getURL(fqClassName) : null;
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.type == Type.CLASS ? this.getURLInterruptibly(fqClassName) : null;
    }

    public URL getResourceURL(String resourceName) {
        return this.type == Type.CLASS ? this.locate(resourceName) : null;
    }

    private URL locate(String relativePath) {
        try {
            return this.table.locate(relativePath);
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private URL locateInterruptibly(String relativePath) throws InterruptedException {
        try {
            return this.table.locate(relativePath);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean isMatchingFileType(String relativePath) {
        for (String suffix : this.getSuffixes()) {
            if (!relativePath.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private String[] getSuffixes() {
        return this.type == Type.SOURCE ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
    }

    public static enum Type {
        SOURCE,
        CLASS;

    }
}

