/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.FileTableClassLocator;
import oracle.jdevimpl.java.types.JavaTypeTable;

public final class JavaTypeTableClassLocator
extends BaseClassLocator {
    private final JavaTypeTable table;
    private final FileTableClassLocator.Type type;

    public JavaTypeTableClassLocator(JavaTypeTable table, FileTableClassLocator.Type type) {
        this.table = table;
        this.type = type;
    }

    public void buildIndex() {
        try {
            this.table.update();
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        try {
            this.table.update();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        try {
            this.getPackagesImpl(packagePrefix, out);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getPackagesImpl(packagePrefix, out);
    }

    private void getPackagesImpl(final String packagePrefix, final Collection<String> out) throws InterruptedException {
        try {
            this.table.visitTypes(new JavaTypeTable.JavaTypeVisitor(){

                @Override
                public JavaTypeTable.Result visit(JavaTypeTable.TypeInfo info) throws InterruptedException {
                    String pkg = info.getPackage();
                    if (pkg.startsWith(packagePrefix) && pkg.length() > packagePrefix.length()) {
                        String remainder = pkg.substring(packagePrefix.length());
                        if (!packagePrefix.isEmpty()) {
                            if (!remainder.startsWith(".")) {
                                return JavaTypeTable.Result.CONTINUE;
                            }
                            remainder = remainder.substring(1);
                        }
                        if (!remainder.isEmpty()) {
                            int dot = remainder.indexOf(46);
                            if (dot == -1) {
                                out.add(remainder);
                            } else {
                                out.add(remainder.substring(0, dot));
                            }
                        }
                    }
                    return JavaTypeTable.Result.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        try {
            this.getClassesInPackageImpl(packagePrefix, out, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getClassesInPackageImpl(packagePrefix, out, true);
    }

    private void getClassesInPackageImpl(final String packagePrefix, final Collection<String> out, final boolean checkInterrupt) throws InterruptedException {
        try {
            this.table.visitTypes(new JavaTypeTable.JavaTypeVisitor(){

                @Override
                public JavaTypeTable.Result visit(JavaTypeTable.TypeInfo info) throws InterruptedException {
                    if (checkInterrupt) {
                        BaseClassLocator.checkInterrupt();
                    }
                    if (packagePrefix.equals(info.getPackage())) {
                        out.add(info.getName());
                    }
                    return JavaTypeTable.Result.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        try {
            this.getAllClassesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getAllClassesImpl(out, filter, true);
    }

    private void getAllClassesImpl(final Collection<String> out, final ClassNameFilter filter, final boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            JavaTypeTableClassLocator.checkInterrupt();
        }
        try {
            this.table.visitTypes(new JavaTypeTable.JavaTypeVisitor(){

                @Override
                public JavaTypeTable.Result visit(JavaTypeTable.TypeInfo info) throws InterruptedException {
                    if (checkInterrupt) {
                        BaseClassLocator.checkInterrupt();
                    }
                    if (filter == null || filter.acceptClassName(info.getName(), info.getPackage())) {
                        out.add(info.getQualifiedName());
                    }
                    return JavaTypeTable.Result.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        try {
            this.getAllPackagesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.getAllPackagesImpl(out, filter, true);
    }

    private void getAllPackagesImpl(final Collection<String> out, final PackageNameFilter filter, final boolean checkInterrupt) throws InterruptedException {
        try {
            this.table.visitTypes(new JavaTypeTable.JavaTypeVisitor(){

                @Override
                public JavaTypeTable.Result visit(JavaTypeTable.TypeInfo info) throws InterruptedException {
                    String pkg;
                    if (checkInterrupt) {
                        BaseClassLocator.checkInterrupt();
                    }
                    if ((pkg = info.getPackage()).indexOf(45) == -1 && (filter == null || filter.acceptPackageName(pkg))) {
                        out.add(pkg);
                    }
                    return JavaTypeTable.Result.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public URL getURL(String fqClassName) {
        try {
            return this.getURLImpl(fqClassName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getURLImpl(fqClassName);
    }

    private URL getURLImpl(String fqClassName) throws InterruptedException {
        try {
            URL url = this.table.getURL(fqClassName);
            if (url == null && this.type == FileTableClassLocator.Type.CLASS && fqClassName.contains("$")) {
                String relativePath = fqClassName.replace('.', '/') + ".class";
                url = this.locate(relativePath);
            }
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getSourceURL(String fqClassName) {
        return this.type == FileTableClassLocator.Type.SOURCE ? this.getURL(fqClassName) : null;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.type == FileTableClassLocator.Type.SOURCE ? this.getURLInterruptibly(fqClassName) : null;
    }

    public URL getClassURL(String fqClassName) {
        return this.type == FileTableClassLocator.Type.CLASS ? this.getURL(fqClassName) : null;
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.type == FileTableClassLocator.Type.CLASS ? this.getURLInterruptibly(fqClassName) : null;
    }

    public URL getResourceURL(String resourceName) {
        return this.type == FileTableClassLocator.Type.CLASS ? this.locate(resourceName) : null;
    }

    private URL locate(String relativePath) {
        if (this.type == FileTableClassLocator.Type.CLASS) {
            try {
                return this.table.getFileTable().locate(relativePath);
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

