/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.net.URL;
import javax.swing.Timer;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.util.SourceElementPath;

public class SourceElementHandle
implements TextBufferListener,
ActionListener {
    public static final String PROPERTY_VALID = "VALID";
    private static final int DELAY = 500;
    private static final boolean TEST_SOFT_REFERENCES = Boolean.getBoolean("jdev.refactoring.test.soft.references");
    private static final boolean DISABLE_SOFT_REFERENCES = Boolean.getBoolean("jdev.refactoring.disable.soft.references");
    private SoftReference<SourceElement> _ref;
    private SourceElement _sourceElement;
    private JavaFileProvider _javaFileProvider;
    private URL _url;
    private SourceElementPath _sourceElementPath;
    private int _hashCode;
    private PropertyChangeListener _propertyChangeListener;
    private Timer _timer;
    private final NodeListener _nodeListener = new NodeListener(){

        public void nodeOpened(NodeEvent e) {
            SourceElementHandle.this.attachTextBufferListener();
            SourceElementHandle.this.getElement();
        }

        public void nodeWillClose(NodeEvent e) {
            SourceElementHandle.this._sourceElement = null;
            if (!DISABLE_SOFT_REFERENCES) {
                SourceElementHandle.this._ref.clear();
            }
            SourceElementHandle.this.detachTextBufferListener();
        }

        public void nodeDeleted(NodeEvent e) {
            if (SourceElementHandle.this._propertyChangeListener != null) {
                PropertyChangeEvent evt = new PropertyChangeEvent((Object)this, SourceElementHandle.PROPERTY_VALID, null, false);
                SourceElementHandle.this._propertyChangeListener.propertyChange(evt);
            }
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            if (SourceElementHandle.this._propertyChangeListener != null) {
                PropertyChangeEvent evt = new PropertyChangeEvent((Object)this, SourceElementHandle.PROPERTY_VALID, null, false);
                SourceElementHandle.this._propertyChangeListener.propertyChange(evt);
            }
            SourceElementHandle.this._url = newURL;
        }
    };

    public SourceElementHandle(SourceElement sourceElement) {
        if (DISABLE_SOFT_REFERENCES) {
            this._sourceElement = sourceElement;
        } else {
            this._ref = new SoftReference<SourceElement>(sourceElement);
        }
        SourceFile owningSourceFile = sourceElement.getOwningSourceFile();
        this._url = owningSourceFile.getURL();
        try {
            JavaProvider provider = owningSourceFile.getProvider();
            if (provider instanceof JavaFileProvider) {
                this._javaFileProvider = (JavaFileProvider)provider;
                this._sourceElementPath = SourceElementPath.createElement(sourceElement);
                TextNode node = this.getNode(true);
                if (node != null) {
                    node.addNodeListener(this._nodeListener);
                    this.attachTextBufferListener();
                }
            }
            String text = sourceElement.getText();
            this._hashCode = text.hashCode();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    public void pinSourceElement() {
        this._sourceElement = this.getElement();
    }

    private TextNode getNode(boolean create) {
        TextNode node = null;
        try {
            node = (TextNode)(create ? NodeFactory.findOrCreate((URL)this._url) : NodeFactory.find((URL)this._url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    private void attachTextBufferListener() {
        TextNode node = this.getNode(true);
        if (node != null) {
            node.addTextBufferListener((TextBufferListener)this);
        }
    }

    private void detachTextBufferListener() {
        TextNode node = this.getNode(false);
        if (node != null) {
            node.removeTextBufferListener((TextBufferListener)this);
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        if (this._sourceElementPath != null) {
            this._sourceElementPath.updateOffsets(offset, count);
            this.whenBufferUpdated();
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        if (this._sourceElementPath != null) {
            this._sourceElementPath.updateOffsets(offset, -count);
            this.whenBufferUpdated();
        }
    }

    private void whenBufferUpdated() {
        Timer timer = this.getTimer();
        timer.restart();
    }

    private Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer(500, this);
            this._timer.setCoalesce(true);
            this._timer.setRepeats(false);
        }
        return this._timer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._propertyChangeListener != null) {
            boolean isValid = this.getElement() != null;
            PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_VALID, null, isValid);
            this._propertyChangeListener.propertyChange(evt);
        }
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }

    public URL getURL() {
        return this._url;
    }

    public SourceElement getElement() {
        SourceElement sourceElement;
        if (!DISABLE_SOFT_REFERENCES && TEST_SOFT_REFERENCES) {
            this._ref.clear();
        }
        if ((sourceElement = this._sourceElement) == null && !DISABLE_SOFT_REFERENCES) {
            sourceElement = this._ref.get();
        }
        if (sourceElement != null && sourceElement.getOwningSourceFile().isExpired()) {
            sourceElement = null;
            this._sourceElement = null;
            if (!DISABLE_SOFT_REFERENCES) {
                this._ref.clear();
            }
        }
        if (sourceElement == null) {
            for (int x = 0; x < 2; ++x) {
                try {
                    SourceFile sourceFile = this._javaFileProvider.getSourceFile(this._url);
                    if (this._sourceElementPath != null && sourceFile != null) {
                        SourceElement pathElement = this._sourceElementPath.find(sourceFile, this.getNode(true));
                        if (pathElement == null || this._hashCode != 0 && pathElement.getText().hashCode() != this._hashCode) break;
                        sourceElement = pathElement;
                        break;
                    }
                    sourceElement = sourceFile;
                    break;
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    continue;
                }
            }
            if (sourceElement != null) {
                if (DISABLE_SOFT_REFERENCES || this._sourceElement != null) {
                    this._sourceElement = sourceElement;
                }
                if (!DISABLE_SOFT_REFERENCES) {
                    this._ref = new SoftReference<SourceElement>(sourceElement);
                }
            }
        }
        return sourceElement;
    }

    public void release() {
        TextNode textNode;
        if (this._timer != null) {
            this._timer.stop();
        }
        if ((textNode = this.getNode(false)) != null) {
            textNode.removeNodeListener(this._nodeListener);
            this.detachTextBufferListener();
        }
        this._sourceElement = null;
        if (!DISABLE_SOFT_REFERENCES) {
            this._ref.clear();
        }
    }

    public int getOffset() {
        if (this._sourceElementPath != null) {
            return this._sourceElementPath.getOffset();
        }
        return 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (this._propertyChangeListener == null);
        this._propertyChangeListener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListener = null;
    }
}

