/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public final class VariableNaming {
    private static HashMap _altNames;

    private VariableNaming() {
    }

    public static String format(VariableType variableType, String name) {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        if (codingStyleManager == null) {
            return name;
        }
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        name = name.substring(name.lastIndexOf(46) + 1);
        name = name.substring(name.lastIndexOf(36) + 1);
        switch (variableType) {
            case FIELD: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getFieldName(name);
            }
            case CONSTANT: {
                return codingStyleOptions.getStaticFieldName(name).toUpperCase();
            }
            case LOCAL: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getLocalVariableName(name);
            }
            case PARAMETER: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getParameterName(name);
            }
        }
        return null;
    }

    private static String lowCapName(String name) {
        name = name.length() > 1 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : Character.toString(Character.toLowerCase(name.charAt(0)));
        return name;
    }

    public static boolean canIntroduceVariable(SourceElement sourceElement, String variableName) {
        SourceElement scope;
        boolean ret = true;
        ret = VariableNaming.isNameDefinedInParents(sourceElement.getParent(), sourceElement, variableName) ? false : (VariableNaming.isNameDefinedInChildren(scope = VariableNaming.getNameInChildrenScope(sourceElement), variableName) ? false : !VariableNaming.fieldShadowing(scope, variableName, false));
        return ret;
    }

    private static SourceElement getNameInChildrenScope(SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 2: 
            case 9: 
            case 18: {
                return sourceElement;
            }
            case 3: {
                return sourceElement;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                SourceBlock sourceBlock = sourceMethod.getBlock();
                if (sourceBlock != null) {
                    return sourceBlock;
                }
                return sourceMethod;
            }
            case 67: {
                return sourceElement;
            }
        }
        return VariableNaming.getNameInChildrenScope(sourceElement.getParent());
    }

    private static boolean isNameDefinedInChildren(SourceElement sourceElement, String variableName) {
        boolean ret = false;
        List children = sourceElement.getChildren();
        block4: for (int i = 0; !ret && i < children.size(); ++i) {
            SourceElement child = (SourceElement)children.get(i);
            switch (child.getSymbolKind()) {
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)child;
                    if (!variableName.equals(sourceLocalVariable.getName())) continue block4;
                    ret = true;
                    continue block4;
                }
                case 4: {
                    continue block4;
                }
                default: {
                    ret = VariableNaming.isNameDefinedInChildren(child, variableName);
                }
            }
        }
        return ret;
    }

    private static boolean isNameDefinedInParents(SourceElement scope, SourceElement skipChild, String variableName) {
        boolean ret = false;
        if (scope.getSymbolKind() != 4) {
            List children = scope.getChildren();
            block4: for (int i = 0; !ret && i < children.size(); ++i) {
                SourceElement child = (SourceElement)children.get(i);
                if (skipChild == child) continue;
                switch (child.getSymbolKind()) {
                    case 18: {
                        SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)child;
                        List variables = sourceLocalVariableDeclaration.getVariables();
                        for (SourceVariable sourceVariable : variables) {
                            if (sourceVariable == null || !variableName.equals(sourceVariable.getName())) continue;
                            return true;
                        }
                        continue block4;
                    }
                    case 12: {
                        SourceFormalParameterList sourceFormalParameterList = (SourceFormalParameterList)child;
                        for (SourceVariable sourceVariable : sourceFormalParameterList.getSourceParameters()) {
                            if (sourceVariable == child || !variableName.equals(sourceVariable.getName())) continue;
                            return true;
                        }
                        continue block4;
                    }
                }
            }
            if (!ret) {
                ret = VariableNaming.isNameDefinedInParents(scope.getParent(), scope, variableName);
            }
        }
        return ret;
    }

    public static List<String> suggestNamesFromCamelWord(String shortName, VariableType variableType) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < shortName.length(); ++i) {
            String formatedName;
            char c = shortName.charAt(i);
            if (i != 0 && !Character.isUpperCase(c)) continue;
            String name = Character.toLowerCase(c) + shortName.substring(i + 1);
            String string = formatedName = variableType == null ? name : VariableNaming.format(variableType, name);
            if (!NamingUtil.isJavaReservedWord((String)formatedName)) {
                names.add(formatedName);
                continue;
            }
            String altName = VariableNaming.getAltName(formatedName);
            if (altName == null) continue;
            names.add(altName);
        }
        ArrayList<String> ret = new ArrayList<String>(names);
        Collections.sort(ret);
        return ret;
    }

    private static Collection<String> suggestAbbreviatedNameFromCamelWord(String camelWord, Collection<String> excludeNames, VariableType variableType) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelWord.length(); ++i) {
            char c = camelWord.charAt(i);
            if (i != 0 && !Character.isUpperCase(c)) continue;
            sb.append(Character.toLowerCase(c));
        }
        return VariableNaming.suggestNamesFromWords(excludeNames, variableType, sb.toString());
    }

    private static Collection<String> suggestNamesFromCamelWord(String shortName, Collection<String> excludeNames, VariableType variableType) {
        List<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(shortName, variableType);
        if (!suggestedNames.isEmpty()) {
            String firstName = (String)suggestedNames.iterator().next();
            suggestedNames.removeAll(excludeNames);
            if (suggestedNames.isEmpty()) {
                HashSet<String> excludeNamesSet = new HashSet<String>(excludeNames);
                String newName = firstName + "_2";
                int i = 3;
                while (excludeNamesSet.contains(newName)) {
                    newName = firstName + "_" + i;
                    ++i;
                }
                suggestedNames.add(newName);
            }
        }
        return suggestedNames;
    }

    private static String getAltName(String name) {
        if (_altNames == null) {
            _altNames = new HashMap();
            _altNames.put("boolean", "b");
            _altNames.put("byte", "i");
            _altNames.put("short", "i");
            _altNames.put("int", "i");
            _altNames.put("long", "i");
            _altNames.put("char", "c");
            _altNames.put("float", "f");
            _altNames.put("double", "f");
            _altNames.put("class", "cls");
        }
        return (String)_altNames.get(name);
    }

    public static List<String> suggestNames(SourceElement sourceElement, String typeName, VariableType variableType, String currentName) {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> existingNames = new HashSet<String>();
        VariableNaming.fillWithParentVariableDeclaration(sourceElement, existingNames);
        VariableNaming.fillWithMembers(sourceElement, existingNames);
        if (currentName != null) {
            existingNames.remove(currentName);
        }
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 57: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                String methodName = sourceMethodCallExpression.getName();
                if (VariableNaming.suggestNamesForAccessor(set, methodName, "get", true, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "is", false, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "has", false, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "can", false, existingNames, variableType)) break;
                Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(methodName, existingNames, variableType);
                set.addAll(suggestedNames);
                break;
            }
            case 53: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                VariableNaming.suggestNameForFieldAccess(variableType, existingNames, set, sourceDotExpression);
                break;
            }
            case 35: {
                set.addAll(VariableNaming.suggestNamesFromWords(existingNames, variableType, "e", "ex", "exception"));
                if (typeName == null || "".equals(typeName)) break;
                set.addAll(VariableNaming.suggestAbbreviatedNameFromCamelWord(typeName, existingNames, variableType));
                break;
            }
            default: {
                String formatedName;
                SourceHasName sourceHasName;
                String name;
                if (!(sourceElement instanceof SourceHasName) || (name = VariableNaming.getBaseName(sourceHasName = (SourceHasName)sourceElement)) == null || name.length() <= 0) break;
                String string = formatedName = variableType == null ? name : VariableNaming.format(variableType, name);
                if (existingNames.contains(formatedName)) break;
                set.add(formatedName);
            }
        }
        if (typeName != null) {
            int firstLt;
            int firstBracket;
            int lastDollar;
            int lastDot = typeName.lastIndexOf(46);
            if (lastDot >= 0) {
                typeName = typeName.substring(lastDot + 1);
            }
            if ((lastDollar = typeName.lastIndexOf(36)) >= 0) {
                typeName = typeName.substring(lastDollar + 1);
            }
            if ((firstBracket = typeName.indexOf(91)) >= 0) {
                typeName = typeName.substring(0, firstBracket);
            }
            if ((firstLt = typeName.indexOf(60)) >= 0) {
                typeName = typeName.substring(0, firstLt);
            }
            Collection<String> typeNames = VariableNaming.suggestNamesFromCamelWord(typeName, existingNames, variableType);
            set.addAll(typeNames);
        }
        ArrayList<String> ret = new ArrayList<String>(set);
        Collections.sort(ret);
        return ret;
    }

    private static Collection<String> suggestNamesFromWords(Collection<String> excludeNames, VariableType variableType, String ... names) {
        HashSet<String> suggestedNames = new HashSet<String>();
        if (names != null && names.length != 0) {
            block0: for (String name : names) {
                for (int suffix = 0; suffix < 100; ++suffix) {
                    String suggestedName = VariableNaming.format(variableType, name + (suffix == 0 ? "" : "_" + suffix));
                    if (excludeNames.contains(suggestedName)) continue;
                    suggestedNames.add(suggestedName);
                    continue block0;
                }
            }
        }
        return suggestedNames;
    }

    private static String getBaseName(SourceHasName sourceHasName) {
        String ret = sourceHasName.getName();
        if (sourceHasName instanceof SourceSimpleNameExpression) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            String[][] fixes = new String[][]{{codingStyleOptions.getFieldPrefix(), codingStyleOptions.getFieldSuffix()}, {codingStyleOptions.getStaticFieldPrefix(), codingStyleOptions.getStaticFieldSuffix()}, {codingStyleOptions.getParameterPrefix(), codingStyleOptions.getParameterSuffix()}, {codingStyleOptions.getLocalVariablePrefix(), codingStyleOptions.getLocalVariableSuffix()}};
            boolean check = false;
            for (int i = 0; !check && i < fixes.length; ++i) {
                String[] fix = fixes[i];
                if ((fix[0] == null || !ret.startsWith(fix[0])) && (fix[1] == null || !ret.endsWith(fix[1]))) continue;
                check = true;
            }
            if (check) {
                int fixNo;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceHasName;
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                switch (resolvedObject.getElementKind()) {
                    case 5: {
                        JavaField javaField = (JavaField)resolvedObject;
                        fixNo = javaField.isStatic() ? 1 : 0;
                        break;
                    }
                    case 7: {
                        JavaLocalVariable javaLocalVariable = (JavaLocalVariable)resolvedObject;
                        SourceVariable sourceVariable = (SourceVariable)javaLocalVariable.getSourceElement();
                        fixNo = sourceVariable.getSymbolKind() == 13 ? 2 : 3;
                        break;
                    }
                    default: {
                        fixNo = -1;
                    }
                }
                String[] fix = fixes[fixNo];
                String prefix = fix[0];
                String suffix = fix[1];
                if (prefix != null && ret.startsWith(prefix)) {
                    ret = ret.substring(prefix.length());
                }
                if (suffix != null && ret.endsWith(suffix)) {
                    ret = ret.substring(0, ret.length() - suffix.length());
                }
            }
        }
        return ret;
    }

    private static void suggestNameForFieldAccess(VariableType variableType, HashSet existingNames, Collection ret, SourceDotExpression sourceDotExpression) {
        String name = sourceDotExpression.getName();
        int lastUnderscorePos = name.lastIndexOf(95);
        if ((name = name.substring(lastUnderscorePos + 1)).length() > 0) {
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(name, existingNames, variableType);
            ret.addAll(suggestedNames);
        }
    }

    private static boolean suggestNamesForAccessor(Collection ret, String methodName, String accessorPrefix, boolean removePrefix, HashSet existingNames, VariableType variableType) {
        if (methodName.startsWith(accessorPrefix)) {
            String baseName = removePrefix ? methodName.substring(accessorPrefix.length()) : methodName;
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(baseName, existingNames, variableType);
            ret.addAll(suggestedNames);
            return true;
        }
        return false;
    }

    private static SourceClass getClassParent(SourceElement sourceElement) {
        while (sourceElement != null) {
            if (sourceElement instanceof SourceClass) {
                return (SourceClass)sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static void fillWithMembers(SourceElement element, HashSet existingNames) {
        for (SourceClass sourceClass = VariableNaming.getClassParent(element); sourceClass != null; sourceClass = sourceClass.getSuperclass()) {
            Collection declaredFields = sourceClass.getDeclaredFields();
            for (JavaField javaField : declaredFields) {
                if (javaField.isPrivate()) continue;
                if (javaField.isPackagePrivate()) {
                    JavaPackage currentPackage = element.getOwningSourceFile().getPackage();
                    JavaPackage fieldPackage = javaField.getOwningClass().getPackage();
                    if (currentPackage == null && fieldPackage == null || currentPackage != null && fieldPackage != null && !currentPackage.equals(fieldPackage)) continue;
                }
                String fieldName = javaField.getName();
                existingNames.add(fieldName);
            }
        }
    }

    public static void fillWithParentVariableDeclaration(SourceElement sourceElement, HashSet<String> existingNames) {
        while (sourceElement != null) {
            int nodeID = sourceElement.getSymbolKind();
            if (nodeID == 19 || nodeID == 5 || nodeID == 6) {
                return;
            }
            SourceElement parent = sourceElement.getParent();
            if (parent != null) {
                VariableNaming.fillWithVariableDeclarations(parent, existingNames);
                SourceElement[] containedElements = parent.getContainedElements();
                for (int i = 0; i < containedElements.length; ++i) {
                    SourceElement containedElement = containedElements[i];
                    if (containedElement == sourceElement) continue;
                    VariableNaming.fillWithVariableDeclarations(containedElement, existingNames);
                }
            }
            sourceElement = parent;
        }
    }

    private static void fillWithVariableDeclarations(SourceElement sourceElement, HashSet existingNames) {
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 18: {
                SourceLocalVariableDeclaration declaration = (SourceLocalVariableDeclaration)sourceElement;
                List variables = declaration.getVariables();
                for (SourceVariable sourceVariable : variables) {
                    String localVariableName = sourceVariable.getName();
                    existingNames.add(localVariableName);
                }
                break;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                Collection parameters = sourceMethod.getParameters();
                for (JavaVariable javaVariable : parameters) {
                    String paramName = javaVariable.getName();
                    existingNames.add(paramName);
                }
                break;
            }
            case 35: {
                SourceCatchClause sourceCatchClause = (SourceCatchClause)sourceElement;
                SourceVariable catchVariable = sourceCatchClause.getCatchVariable();
                String exceptionName = catchVariable.getName();
                existingNames.add(exceptionName);
                break;
            }
            case 42: {
                SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                if (sourceForStatement.getForType() != 1) break;
                List variables = sourceForStatement.getForVariables();
                for (SourceVariable sourceVariable : variables) {
                    String variableName = sourceVariable.getName();
                    existingNames.add(variableName);
                }
                break;
            }
        }
    }

    public static String canIntroduceField(SourceElement sourceElement, String fieldName) {
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)fieldName)) {
            message = RefactoringArb.getString((int)197);
        } else if (NamingUtil.isJavaReservedWord((String)fieldName)) {
            message = RefactoringArb.getString((int)197);
        } else if (VariableNaming.isFieldAlreadyPresent(sourceElement, fieldName)) {
            message = MessageFormat.format(RefactoringArb.getString((int)198), fieldName);
        }
        return message;
    }

    private static boolean isFieldAlreadyPresent(SourceElement sourceElement, String fieldName) {
        SourceClass declClass = VariableNaming.getClassParent(sourceElement.getParent());
        if (declClass.getDeclaredField(fieldName) != null) {
            return true;
        }
        while (declClass != null) {
            int modifiers;
            JavaField declaredField = declClass.getDeclaredField(fieldName);
            if (declaredField != null && !BitField.isSet((int)(modifiers = declaredField.getModifiers()), (int)2)) {
                return true;
            }
            declClass = declClass.getSuperclass();
        }
        return false;
    }

    public static boolean isFieldShadowing(SourceElement element, String newVariableName) {
        SourceBlock scope = null;
        if (element.getSymbolKind() == 13) {
            scope = ((SourceFormalParameter)element).getOwningBlock();
        } else if (element.getSymbolKind() == 17) {
            scope = ((SourceLocalVariable)element).getOwningBlock();
        }
        return scope != null ? VariableNaming.fieldShadowing((SourceElement)scope, newVariableName, true) : false;
    }

    private static boolean fieldShadowing(SourceElement element, String variableName, boolean fieldsOnly) {
        List children;
        SourceElement parent;
        int parentKind;
        SourceName name;
        if (element.getSymbolKind() == 20 && variableName.equals((name = (SourceName)element).getName()) && (parentKind = (parent = name.getParent()).getSymbolKind()) != 53 && parentKind != 57) {
            JavaHasType resolvedObject;
            if (!fieldsOnly) {
                return true;
            }
            if (parent instanceof SourceExpression && (resolvedObject = ((SourceExpression)parent).getResolvedObject()) != null && resolvedObject.getElementKind() == 5) {
                return true;
            }
        }
        if ((children = element.getChildren()).isEmpty()) {
            return false;
        }
        for (SourceElement child : children) {
            if (!VariableNaming.fieldShadowing(child, variableName, false)) continue;
            return true;
        }
        return false;
    }

    public static enum VariableType {
        FIELD,
        CONSTANT,
        LOCAL,
        PARAMETER;

    }
}

